## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, collapse = TRUE)
library(dplyr)
library(ggplot2)
library(maraca)

## ----maraca1, eval = TRUE, fig.width = 7, fig.height = 6----------------------
library(maraca)

data(hce_scenario_a, package = "maraca")

data <- hce_scenario_a
column_names <- c(
    outcome = "GROUP",
    arm = "TRTP",
    value = "AVAL0"
)

step_outcomes <- c(
  "Outcome I", "Outcome II", "Outcome III", "Outcome IV"
)
last_outcome <- "Continuous outcome"

arm_levels = c(active = "Active", control = "Control")

mar <- maraca(
  data, step_outcomes, last_outcome, arm_levels, column_names, 
  fixed_followup_days = 3*365,
  compute_win_odds = TRUE
)

## Static plot
plot(mar)

## ----out.width=700, out.height=500, message=FALSE-----------------------------
animate_plot(mar)

## ----out.width=700, out.height=500, message=FALSE-----------------------------
animate_plot(mar,
             continuous_grid_spacing_x = 20,
             density_plot_type = "scatter",
             vline_type = "mean",
             remove_outliers = TRUE,
             theme = "color1")

## ----out.width=800, out.height=600, message=FALSE-----------------------------
animate_plot(mar,
             frames_per_step = 12,
             gif_duration = 20,
             end_duration = 40,
             speed_factor = 8,
             anim_order = "control",
             anim_width = 800,
             anim_height = 600,
             continuous_grid_spacing_x = 20)

## -----------------------------------------------------------------------------
data("hce_scenario_a")
# Create data with binary version of 2 step outcomes and
# continuous final endpoint
bin_data <- hce_scenario_a

idx_bin <- bin_data$GROUP %in% c("Outcome III", "Outcome IV")
# Binary version (>= 0/< 0), coded as 1
bin_data[idx_bin,"AVAL0"] <- bin_data[idx_bin,"AVAL0"] >= 500
bin_data[idx_bin,"AVAL"] <- bin_data[idx_bin,"AVAL0"] +
  bin_data[idx_bin,"GROUPN"]
# Remove 0 rows (only include patients that had the outcome)
bin_data <- bin_data[bin_data$AVAL0 != 0,]

# Index of all continuous outcome rows
idx_cont <- bin_data$GROUP == "Continuous outcome"
# Rename outcome
bin_data[idx_cont,"GROUP"] <- "Binary outcome"
# Binary version (>= 0/< 0)
bin_data[idx_cont,"AVAL0"] <- bin_data[idx_cont,"AVAL0"] >= 0
bin_data[idx_cont,"AVAL"] <- bin_data[idx_cont,"AVAL0"] +
  bin_data[idx_cont,"GROUPN"]
last_outcome_binary <- "Binary outcome"


mar_binary <- maraca(
  bin_data, step_outcomes, last_outcome_binary,
  arm_levels, column_names,
  fixed_followup_days = 3*365,
  compute_win_odds = TRUE,
  # Important change: Add information that last endpoint is
  # not continuous (the default)
  step_types = c("tte","tte","binary","binary"),
  last_type = "binary"
)

## ----out.width=700, out.height=500, message=FALSE-----------------------------
animate_plot(mar_binary, anim_order = "control")

## ----fig.width = 7, fig.height = 6--------------------------------------------
Rates_A <- c(1.72, 1.74, 0.58, 1.5, 1)
Rates_P <- c(2.47, 2.24, 2.9, 4, 6)
hce_dat <- hce::simHCE(n = 2500, TTE_A = Rates_A, TTE_P = Rates_P,
              CM_A = -6, CM_P = 3, CSD_A = 15, CSD_P = 16, fixedfy = 3,
              seed = 31337)

## ----out.width=700, out.height=500, message=FALSE-----------------------------
animate_plot(hce_dat, compute_win_odds = TRUE, lowerBetter = TRUE,
             trans = "reverse")

## ----out.width=700, out.height=500, message=FALSE-----------------------------
animate_plot(mar,
             density_plot_type = "box",
             anim_order = "control",
             continuous_grid_spacing_x = 20)

## -----------------------------------------------------------------------------
# Example - do not run
# animate_plot(mar, gif_file_name = "tmp/maraca_anim.gif")

