## ----include=FALSE----------------------------------------
library(knitr)
opts_chunk$set(
concordance=TRUE
)

## ----echo=FALSE---------------------------------------------------------------
rm(list=ls(all=TRUE))
options(width=80)

## ----results='hide'-----------------------------------------------------------
library(catdata)
data(retinopathy)

## -----------------------------------------------------------------------------
library(VGAM)

## -----------------------------------------------------------------------------
seqm1 <- vglm(RET ~ SM + DIAB + GH + BP, family = sratio (link="logitlink", 
parallel=FALSE), data = retinopathy)
deviance(seqm1)

## -----------------------------------------------------------------------------
seqm2 <- vglm(RET ~ SM + DIAB + GH + BP, family = sratio (link="logitlink", 
parallel=FALSE ~ SM + GH + BP), data = retinopathy)
deviance(seqm2)

## -----------------------------------------------------------------------------
1-pchisq(deviance(seqm2)-deviance(seqm1), df=1)

## -----------------------------------------------------------------------------
seqm3 <- vglm(RET ~ SM + DIAB + GH + BP, family = sratio (link="logitlink", 
parallel=FALSE ~ SM + BP), data = retinopathy)
deviance(seqm3)

## -----------------------------------------------------------------------------
1-pchisq(deviance(seqm3)-deviance(seqm2), df=1)

## -----------------------------------------------------------------------------
seqm4 <- vglm(RET ~ SM + DIAB + GH + BP, family = sratio (link="logitlink", 
parallel=FALSE ~ SM), data = retinopathy)
deviance(seqm4)

## -----------------------------------------------------------------------------
1-pchisq(deviance(seqm4)-deviance(seqm3), df=1)

## -----------------------------------------------------------------------------
seqm5 <- vglm(RET ~ SM + DIAB + GH + BP, family = sratio (link="logitlink", 
parallel=TRUE), data = retinopathy)
deviance(seqm5)

## -----------------------------------------------------------------------------
1-pchisq(deviance(seqm5)-deviance(seqm4), df=1)

## -----------------------------------------------------------------------------
summary(seqm4)

## -----------------------------------------------------------------------------
1 - pchisq(9.5223^2, df=1)

## -----------------------------------------------------------------------------
1 - pchisq(8.9957^2, df=1)

## -----------------------------------------------------------------------------
1 - pchisq((-1.8646)^2, df=1)

## -----------------------------------------------------------------------------
1 - pchisq(1.5687^2, df=1)

## -----------------------------------------------------------------------------
1 - pchisq((-10.4303)^2, df=1)

## -----------------------------------------------------------------------------
1 - pchisq((-6.3116)^2, df=1)

## -----------------------------------------------------------------------------
1 - pchisq((-5.1037)^2, df=1)

## -----------------------------------------------------------------------------
exp(coefficients(seqm4)[3:7])

## ----echo=FALSE---------------------------------------------------------------
detach(package:VGAM)

