# PropertyRunner\[T: T\]
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-76)</span>

Actor executing a Property1 implementation
in a way that allows garbage collection between single
property executions, because it uses recursive behaviours
for looping.


```pony
actor tag PropertyRunner[T: T]
```

## Constructors

### create
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-110)</span>


```pony
new tag create(
  p1: Property1[T] iso,
  params: PropertyParams val,
  notify: PropertyResultNotify val,
  logger: PropertyLogger val,
  env: Env val)
: PropertyRunner[T] tag^
```
#### Parameters

*   p1: [Property1](pony_check-Property1.md)\[T\] iso
*   params: [PropertyParams](pony_check-PropertyParams.md) val
*   notify: [PropertyResultNotify](pony_check-PropertyResultNotify.md) val
*   logger: [PropertyLogger](pony_check-PropertyLogger.md) val
*   env: [Env](builtin-Env.md) val

#### Returns

* [PropertyRunner](pony_check-PropertyRunner.md)\[T\] tag^

---

## Public Behaviours

### complete_run
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-128)</span>


Complete a property run.

This behaviour is called from the PropertyHelper
or from the actor itself.


```pony
be complete_run(
  round: (_Shrink val | _Run val),
  success: Bool val)
```
#### Parameters

*   round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)
*   success: [Bool](builtin-Bool.md) val

---

### run
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-183)</span>


```pony
be run()
```

---

### complete_shrink
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-229)</span>


```pony
be complete_shrink(
  failed_repr: String val,
  last_repr: String val,
  shrink_round: (_Shrink val | _Run val),
  success: Bool val)
```
#### Parameters

*   failed_repr: [String](builtin-String.md) val
*   last_repr: [String](builtin-String.md) val
*   shrink_round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)
*   success: [Bool](builtin-Bool.md) val

---

### do_shrink
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-250)</span>


```pony
be do_shrink(
  failed_repr: String val)
```
#### Parameters

*   failed_repr: [String](builtin-String.md) val

---

### expect_action
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-304)</span>


```pony
be expect_action(
  name: String val,
  round: (_Shrink val | _Run val))
```
#### Parameters

*   name: [String](builtin-String.md) val
*   round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)

---

### complete_action
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-313)</span>


```pony
be complete_action(
  name: String val,
  round: (_Shrink val | _Run val),
  ph: PropertyHelper val)
```
#### Parameters

*   name: [String](builtin-String.md) val
*   round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)
*   ph: [PropertyHelper](pony_check-PropertyHelper.md) val

---

### fail_action
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-322)</span>


```pony
be fail_action(
  name: String val,
  round: (_Shrink val | _Run val),
  ph: PropertyHelper val)
```
#### Parameters

*   name: [String](builtin-String.md) val
*   round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)
*   ph: [PropertyHelper](pony_check-PropertyHelper.md) val

---

### dispose_when_done
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-346)</span>


Let us not have older rounds interfere with newer ones, 
thus dispose directly.


```pony
be dispose_when_done(
  disposable: DisposableActor tag,
  round: (_Shrink val | _Run val))
```
#### Parameters

*   disposable: [DisposableActor](builtin-DisposableActor.md) tag
*   round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)

---

### dispose
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-360)</span>


```pony
be dispose()
```

---

### log
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-368)</span>


```pony
be log(
  msg: String val,
  verbose: Bool val = false)
```
#### Parameters

*   msg: [String](builtin-String.md) val
*   verbose: [Bool](builtin-Bool.md) val = false

---

## Public Functions

### complete
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-373)</span>


Complete the Property execution successfully.


```pony
fun ref complete()
: None val
```

#### Returns

* [None](builtin-None.md) val

---

### fail
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-379)</span>


Complete the Property execution
while signalling failure to the `PropertyResultNotify`.


```pony
fun ref fail(
  repr: String val,
  rounds: USize val = 0,
  err: Bool val = false)
: None val
```
#### Parameters

*   repr: [String](builtin-String.md) val
*   rounds: [USize](builtin-USize.md) val = 0
*   err: [Bool](builtin-Bool.md) val = false

#### Returns

* [None](builtin-None.md) val

---

## Private Behaviours

### _run_finished
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-221)</span>


```pony
be _run_finished(
  round: (_Shrink val | _Run val))
```
#### Parameters

*   round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)

---

### _shrink_finished
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-292)</span>


```pony
be _shrink_finished(
  failed_repr: String val,
  current_repr: String val,
  shrink_round: (_Shrink val | _Run val))
```
#### Parameters

*   failed_repr: [String](builtin-String.md) val
*   current_repr: [String](builtin-String.md) val
*   shrink_round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)

---

## Private Functions

### _prepare_next_round
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-164)</span>


```pony
fun ref _prepare_next_round()
: None val
```

#### Returns

* [None](builtin-None.md) val

---

### _generate_with_retry
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-171)</span>


```pony
fun ref _generate_with_retry(
  max_retries: USize val)
: (T^ , Iterator[T^] ref) ?
```
#### Parameters

*   max_retries: [USize](builtin-USize.md) val

#### Returns

* (T^ , [Iterator](builtin-Iterator.md)\[T^\] ref) ?

---

### _finish_action
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-331)</span>


```pony
fun ref _finish_action(
  name: String val,
  success: Bool val,
  round: (_Shrink val | _Run val),
  ph: PropertyHelper val)
: None val
```
#### Parameters

*   name: [String](builtin-String.md) val
*   success: [Bool](builtin-Bool.md) val
*   round: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)
*   ph: [PropertyHelper](pony_check-PropertyHelper.md) val

#### Returns

* [None](builtin-None.md) val

---

### _dispose
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-363)</span>


```pony
fun ref _dispose()
: None val
```

#### Returns

* [None](builtin-None.md) val

---

### _report_error
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-391)</span>


Report an error that happened during property evaluation
and signal failure to the `PropertyResultNotify`.


```pony
fun box _report_error(
  sample_repr: String val,
  shrink_rounds: USize val = 0,
  loc: SourceLoc val = __loc)
: None val
```
#### Parameters

*   sample_repr: [String](builtin-String.md) val
*   shrink_rounds: [USize](builtin-USize.md) val = 0
*   loc: [SourceLoc](builtin-SourceLoc.md) val = __loc

#### Returns

* [None](builtin-None.md) val

---

### _report_failed
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-406)</span>


Report a failed property and signal failure to the `PropertyResultNotify`.


```pony
fun box _report_failed(
  sample_repr: String val,
  shrink_rounds: USize val = 0,
  loc: SourceLoc val = __loc)
: None val
```
#### Parameters

*   sample_repr: [String](builtin-String.md) val
*   shrink_rounds: [USize](builtin-USize.md) val = 0
*   loc: [SourceLoc](builtin-SourceLoc.md) val = __loc

#### Returns

* [None](builtin-None.md) val

---

