/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.utils;

import com.google.common.base.Strings;
import java.util.Locale;

public class StringUtils {
    public static String unquoteText(String text) {
        char lastChar;
        if (text.length() < 2) {
            return text;
        }
        char enclosingQuote = '\u0000';
        char firstChar = text.charAt(0);
        if (firstChar != (lastChar = text.charAt(text.length() - 1))) {
            return text;
        }
        if (firstChar == '`') {
            return text.substring(1, text.length() - 1);
        }
        if (firstChar != lastChar || firstChar != '\'' && firstChar != '\"') {
            return text;
        }
        enclosingQuote = firstChar;
        StringBuilder textSB = new StringBuilder();
        for (int chIndex = 1; chIndex < text.length() - 1; ++chIndex) {
            char currentChar = text.charAt(chIndex);
            char nextChar = text.charAt(chIndex + 1);
            if (currentChar == '\\' && (nextChar == '\"' || nextChar == '\\' || nextChar == '\'') || currentChar == nextChar && currentChar == enclosingQuote) {
                ++chIndex;
                currentChar = nextChar;
            }
            textSB.append(currentChar);
        }
        return textSB.toString();
    }

    public static String unquoteIdentifier(String identifier) {
        if (StringUtils.isQuoted(identifier, "`")) {
            return identifier.substring(1, identifier.length() - 1);
        }
        return identifier;
    }

    public static String format(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    private static boolean isQuoted(String text, String mark) {
        return !Strings.isNullOrEmpty((String)text) && text.startsWith(mark) && text.endsWith(mark);
    }
}

