/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.pagination.Cursor;
import org.opensearch.sql.lang.LangSpec;

public class QueryResult
implements Iterable<Object[]> {
    private final ExecutionEngine.Schema schema;
    private final Collection<ExprValue> exprValues;
    private final Cursor cursor;
    private final LangSpec langSpec;

    public QueryResult(ExecutionEngine.Schema schema, Collection<ExprValue> exprValues) {
        this(schema, exprValues, Cursor.None, LangSpec.SQL_SPEC);
    }

    public QueryResult(ExecutionEngine.Schema schema, Collection<ExprValue> exprValues, Cursor cursor) {
        this(schema, exprValues, cursor, LangSpec.SQL_SPEC);
    }

    public QueryResult(ExecutionEngine.Schema schema, Collection<ExprValue> exprValues, Cursor cursor, LangSpec langSpec) {
        this.schema = schema;
        this.exprValues = exprValues;
        this.cursor = cursor;
        this.langSpec = langSpec;
    }

    public int size() {
        return this.exprValues.size();
    }

    public Map<String, String> columnNameTypes() {
        LinkedHashMap<String, String> colNameTypes = new LinkedHashMap<String, String>();
        this.schema.getColumns().forEach(column -> colNameTypes.put(this.getColumnName((ExecutionEngine.Schema.Column)column), this.langSpec.typeName(column.getExprType()).toLowerCase(Locale.ROOT)));
        return colNameTypes;
    }

    @Override
    public Iterator<Object[]> iterator() {
        return this.exprValues.stream().map(ExprValueUtils::getTupleValue).map(Map::values).map(this::convertExprValuesToValues).iterator();
    }

    private String getColumnName(ExecutionEngine.Schema.Column column) {
        return column.getAlias() != null ? column.getAlias() : column.getName();
    }

    private Object[] convertExprValuesToValues(Collection<ExprValue> exprValues) {
        return exprValues.stream().map(ExprValue::value).toArray(Object[]::new);
    }

    @Generated
    public ExecutionEngine.Schema getSchema() {
        return this.schema;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }
}

