/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.planner.logical.rules;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import lombok.Generated;
import org.opensearch.sql.planner.logical.LogicalAggregation;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.optimizer.Rule;
import org.opensearch.sql.planner.optimizer.pattern.Patterns;
import org.opensearch.sql.prometheus.planner.logical.PrometheusLogicalMetricAgg;

public class MergeAggAndRelation
implements Rule<LogicalAggregation> {
    private final Capture<LogicalRelation> relationCapture = Capture.newCapture();
    private final Pattern<LogicalAggregation> pattern = Pattern.typeOf(LogicalAggregation.class).with(Patterns.source().matching(Pattern.typeOf(LogicalRelation.class).capturedAs(this.relationCapture)));

    @Override
    public LogicalPlan apply(LogicalAggregation aggregation, Captures captures) {
        LogicalRelation relation = captures.get(this.relationCapture);
        return PrometheusLogicalMetricAgg.builder().metricName(relation.getRelationName()).aggregatorList(aggregation.getAggregatorList()).groupByList(aggregation.getGroupByList()).build();
    }

    @Override
    @Generated
    public Pattern<LogicalAggregation> pattern() {
        return this.pattern;
    }
}

