/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.directquery.rest;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.client.exceptions.DataSourceClientException;
import org.opensearch.sql.datasources.exceptions.ErrorMessage;
import org.opensearch.sql.datasources.utils.Scheduler;
import org.opensearch.sql.directquery.rest.model.ExecuteDirectQueryRequest;
import org.opensearch.sql.directquery.transport.TransportExecuteDirectQueryRequestAction;
import org.opensearch.sql.directquery.transport.format.DirectQueryRequestConverter;
import org.opensearch.sql.directquery.transport.model.ExecuteDirectQueryActionRequest;
import org.opensearch.sql.directquery.transport.model.ExecuteDirectQueryActionResponse;
import org.opensearch.sql.directquery.validator.DirectQueryRequestValidator;
import org.opensearch.sql.opensearch.setting.OpenSearchSettings;
import org.opensearch.sql.opensearch.util.RestRequestUtil;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;
import org.opensearch.transport.client.node.NodeClient;
import shaded.com.google.common.collect.ImmutableList;

@ExperimentalApi
public class RestDirectQueryManagementAction
extends BaseRestHandler {
    public static final String DIRECT_QUERY_ACTIONS = "direct_query_actions";
    public static final String BASE_DIRECT_QUERY_ACTION_URL = "/_plugins/_directquery/_query/{dataSources}";
    private static final Logger LOG = LogManager.getLogger(RestDirectQueryManagementAction.class);
    private final OpenSearchSettings settings;

    public String getName() {
        return DIRECT_QUERY_ACTIONS;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of(new RestHandler.Route(RestRequest.Method.POST, BASE_DIRECT_QUERY_ACTION_URL));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient nodeClient) {
        String dataSources = restRequest.param("dataSources");
        RestRequestUtil.consumeAllRequestParameters(restRequest);
        if (!this.dataSourcesEnabled()) {
            return this.dataSourcesDisabledError(restRequest);
        }
        if (Objects.requireNonNull(restRequest.method()) == RestRequest.Method.POST) {
            return this.executeDirectQueryRequest(restRequest, nodeClient, dataSources);
        }
        return restChannel -> restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, String.valueOf(restRequest.method())));
    }

    private BaseRestHandler.RestChannelConsumer executeDirectQueryRequest(final RestRequest restRequest, NodeClient nodeClient, String dataSources) {
        return restChannel -> {
            try {
                ExecuteDirectQueryRequest directQueryRequest = DirectQueryRequestConverter.fromXContentParser(restRequest.contentParser());
                if (directQueryRequest.getDataSources() == null) {
                    directQueryRequest.setDataSources(dataSources);
                }
                if (directQueryRequest.getSessionId() == null) {
                    directQueryRequest.setSessionId(UUID.randomUUID().toString());
                }
                DirectQueryRequestValidator.validateRequest(directQueryRequest);
                Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportExecuteDirectQueryRequestAction.ACTION_TYPE, (ActionRequest)new ExecuteDirectQueryActionRequest(directQueryRequest), (ActionListener)new ActionListener<ExecuteDirectQueryActionResponse>(){

                    public void onResponse(ExecuteDirectQueryActionResponse response) {
                        String formattedResponse = RestDirectQueryManagementAction.this.formatDirectQueryResponse(response);
                        restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", formattedResponse));
                    }

                    public void onFailure(Exception e) {
                        RestDirectQueryManagementAction.this.handleException(e, restChannel, restRequest.method());
                    }
                }));
            }
            catch (Exception e) {
                this.handleException(e, (RestChannel)restChannel, restRequest.method());
            }
        };
    }

    private String formatDirectQueryResponse(ExecuteDirectQueryActionResponse response) {
        try {
            return new JsonResponseFormatter<ExecuteDirectQueryActionResponse>(this, JsonResponseFormatter.Style.PRETTY){

                @Override
                protected Object buildJsonObject(ExecuteDirectQueryActionResponse response) {
                    return new DirectQueryResult(response.getQueryId(), response.getResults(), response.getSessionId());
                }
            }.format(response);
        }
        catch (Exception e) {
            LOG.error("Error formatting direct query response", (Throwable)e);
            return "{\"error\": \"" + e.getMessage() + "\"}";
        }
    }

    private void handleException(Exception e, RestChannel restChannel, RestRequest.Method requestMethod) {
        if (e instanceof OpenSearchException) {
            OpenSearchException exception = (OpenSearchException)e;
            this.reportError(restChannel, (Exception)exception, exception.status());
        } else {
            LOG.error("Error happened during request handling", (Throwable)e);
            if (RestDirectQueryManagementAction.isClientError(e)) {
                this.reportError(restChannel, e, RestStatus.BAD_REQUEST);
            } else {
                this.reportError(restChannel, e, RestStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, new ErrorMessage(e, status.getStatus()).toString()));
    }

    private static boolean isClientError(Exception e) {
        return e instanceof IllegalArgumentException || e instanceof IllegalStateException || e instanceof DataSourceClientException || e instanceof IllegalAccessException;
    }

    private boolean dataSourcesEnabled() {
        return (Boolean)this.settings.getSettingValue(Settings.Key.DATASOURCES_ENABLED);
    }

    private BaseRestHandler.RestChannelConsumer dataSourcesDisabledError(RestRequest request) {
        RestRequestUtil.consumeAllRequestParameters(request);
        return channel -> this.reportError((RestChannel)channel, new IllegalAccessException(String.format("%s setting is false", Settings.Key.DATASOURCES_ENABLED.getKeyValue())), RestStatus.BAD_REQUEST);
    }

    @Generated
    public RestDirectQueryManagementAction(OpenSearchSettings settings) {
        this.settings = settings;
    }

    private static class DirectQueryResult {
        private final String queryId;
        private final Map<String, Object> results;
        private final String sessionId;

        public DirectQueryResult(String queryId, Map<String, ?> results, String sessionId) {
            this.queryId = queryId;
            this.results = results;
            this.sessionId = sessionId;
        }

        @Generated
        public String getQueryId() {
            return this.queryId;
        }

        @Generated
        public Map<String, Object> getResults() {
            return this.results;
        }

        @Generated
        public String getSessionId() {
            return this.sessionId;
        }
    }
}

