/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;

public class MLUpdateMemoryContainerInput
implements ToXContentObject,
Writeable {
    public static final String MEMORY_CONFIG_FIELD = "configuration";
    private String name;
    private String description;
    private List<String> backendRoles;
    private MemoryConfiguration configuration;

    public MLUpdateMemoryContainerInput(String name, String description2, List<String> backendRoles, MemoryConfiguration configuration) {
        this.name = name;
        this.description = description2;
        this.backendRoles = backendRoles;
        this.configuration = configuration;
    }

    public MLUpdateMemoryContainerInput(StreamInput in) throws IOException {
        this.name = in.readOptionalString();
        this.description = in.readOptionalString();
        if (in.readBoolean()) {
            this.backendRoles = in.readStringList();
        }
        if (in.readBoolean()) {
            this.configuration = new MemoryConfiguration(in);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.description);
        if (!CollectionUtils.isEmpty(this.backendRoles)) {
            out.writeBoolean(true);
            out.writeStringCollection(this.backendRoles);
        } else {
            out.writeBoolean(false);
        }
        if (this.configuration != null) {
            out.writeBoolean(true);
            this.configuration.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field("name", this.name);
        }
        if (this.description != null) {
            builder.field("description", this.description);
        }
        if (!CollectionUtils.isEmpty(this.backendRoles)) {
            builder.field("backend_roles", this.backendRoles);
        }
        if (this.configuration != null) {
            builder.field(MEMORY_CONFIG_FIELD, (ToXContent)this.configuration);
        }
        builder.endObject();
        return builder;
    }

    public static MLUpdateMemoryContainerInput parse(XContentParser parser) throws IOException {
        String name = null;
        String description2 = null;
        ArrayList<String> backendRoles = null;
        MemoryConfiguration configuration = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block12;
                }
                case "description": {
                    description2 = parser.text();
                    continue block12;
                }
                case "backend_roles": {
                    backendRoles = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block12;
                }
                case "configuration": {
                    configuration = MemoryConfiguration.parse(parser);
                    continue block12;
                }
            }
            parser.skipChildren();
        }
        return MLUpdateMemoryContainerInput.builder().name(name).description(description2).backendRoles(backendRoles).configuration(configuration).build();
    }

    @Generated
    public static MLUpdateMemoryContainerInputBuilder builder() {
        return new MLUpdateMemoryContainerInputBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Generated
    public MemoryConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public static class MLUpdateMemoryContainerInputBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private List<String> backendRoles;
        @Generated
        private MemoryConfiguration configuration;

        @Generated
        MLUpdateMemoryContainerInputBuilder() {
        }

        @Generated
        public MLUpdateMemoryContainerInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLUpdateMemoryContainerInputBuilder description(String description2) {
            this.description = description2;
            return this;
        }

        @Generated
        public MLUpdateMemoryContainerInputBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public MLUpdateMemoryContainerInputBuilder configuration(MemoryConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public MLUpdateMemoryContainerInput build() {
            return new MLUpdateMemoryContainerInput(this.name, this.description, this.backendRoles, this.configuration);
        }

        @Generated
        public String toString() {
            return "MLUpdateMemoryContainerInput.MLUpdateMemoryContainerInputBuilder(name=" + this.name + ", description=" + this.description + ", backendRoles=" + String.valueOf(this.backendRoles) + ", configuration=" + String.valueOf(this.configuration) + ")";
        }
    }
}

