/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.type;

import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import shaded.com.google.common.collect.ImmutableList;

public class RelCrossType
extends RelDataTypeImpl {
    private final ImmutableList<RelDataType> types;

    public RelCrossType(List<RelDataType> types, List<RelDataTypeField> fields2) {
        super(fields2);
        this.types = ImmutableList.copyOf(types);
        assert (types.size() >= 1);
        for (RelDataType type2 : types) {
            assert (!(type2 instanceof RelCrossType));
        }
        this.computeDigest();
    }

    @Override
    public boolean isStruct() {
        return false;
    }

    public List<RelDataType> getTypes() {
        return this.types;
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("CrossType(");
        for (Ord<RelDataType> type2 : Ord.zip(this.types)) {
            if (type2.i > 0) {
                sb.append(", ");
            }
            if (withDetail) {
                sb.append(((RelDataType)type2.e).getFullTypeString());
                continue;
            }
            sb.append(((RelDataType)type2.e).toString());
        }
        sb.append(")");
    }
}

