/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.CyclicMetadataException;
import org.apache.calcite.rel.metadata.MetadataHandlerProvider;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQueryBase;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Suppliers;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.Iterables;
import shaded.com.google.common.collect.Multimap;

public class RelMetadataQuery
extends RelMetadataQueryBase {
    private static final Supplier<RelMetadataQuery> EMPTY = Suppliers.memoize(() -> new RelMetadataQuery(false));
    private BuiltInMetadata.Collation.Handler collationHandler;
    private BuiltInMetadata.ColumnOrigin.Handler columnOriginHandler;
    private BuiltInMetadata.ExpressionLineage.Handler expressionLineageHandler;
    private BuiltInMetadata.TableReferences.Handler tableReferencesHandler;
    private BuiltInMetadata.ColumnUniqueness.Handler columnUniquenessHandler;
    private BuiltInMetadata.CumulativeCost.Handler cumulativeCostHandler;
    private BuiltInMetadata.DistinctRowCount.Handler distinctRowCountHandler;
    private BuiltInMetadata.Distribution.Handler distributionHandler;
    private BuiltInMetadata.ExplainVisibility.Handler explainVisibilityHandler;
    private BuiltInMetadata.MaxRowCount.Handler maxRowCountHandler;
    private BuiltInMetadata.MinRowCount.Handler minRowCountHandler;
    private BuiltInMetadata.Memory.Handler memoryHandler;
    private BuiltInMetadata.Measure.Handler measureHandler;
    private BuiltInMetadata.NonCumulativeCost.Handler nonCumulativeCostHandler;
    private BuiltInMetadata.Parallelism.Handler parallelismHandler;
    private BuiltInMetadata.PercentageOriginalRows.Handler percentageOriginalRowsHandler;
    private BuiltInMetadata.PopulationSize.Handler populationSizeHandler;
    private BuiltInMetadata.Predicates.Handler predicatesHandler;
    private BuiltInMetadata.AllPredicates.Handler allPredicatesHandler;
    private BuiltInMetadata.NodeTypes.Handler nodeTypesHandler;
    private BuiltInMetadata.RowCount.Handler rowCountHandler;
    private BuiltInMetadata.Selectivity.Handler selectivityHandler;
    private BuiltInMetadata.Size.Handler sizeHandler;
    private BuiltInMetadata.UniqueKeys.Handler uniqueKeysHandler;
    private BuiltInMetadata.LowerBoundCost.Handler lowerBoundCostHandler;

    protected RelMetadataQuery() {
        this((MetadataHandlerProvider)Nullness.castNonNull(THREAD_PROVIDERS.get()), EMPTY.get());
    }

    public RelMetadataQuery(MetadataHandlerProvider provider) {
        super(provider);
        this.collationHandler = provider.handler(BuiltInMetadata.Collation.Handler.class);
        this.columnOriginHandler = provider.handler(BuiltInMetadata.ColumnOrigin.Handler.class);
        this.expressionLineageHandler = provider.handler(BuiltInMetadata.ExpressionLineage.Handler.class);
        this.tableReferencesHandler = provider.handler(BuiltInMetadata.TableReferences.Handler.class);
        this.columnUniquenessHandler = provider.handler(BuiltInMetadata.ColumnUniqueness.Handler.class);
        this.cumulativeCostHandler = provider.handler(BuiltInMetadata.CumulativeCost.Handler.class);
        this.distinctRowCountHandler = provider.handler(BuiltInMetadata.DistinctRowCount.Handler.class);
        this.distributionHandler = provider.handler(BuiltInMetadata.Distribution.Handler.class);
        this.explainVisibilityHandler = provider.handler(BuiltInMetadata.ExplainVisibility.Handler.class);
        this.maxRowCountHandler = provider.handler(BuiltInMetadata.MaxRowCount.Handler.class);
        this.minRowCountHandler = provider.handler(BuiltInMetadata.MinRowCount.Handler.class);
        this.memoryHandler = provider.handler(BuiltInMetadata.Memory.Handler.class);
        this.measureHandler = provider.handler(BuiltInMetadata.Measure.Handler.class);
        this.nonCumulativeCostHandler = provider.handler(BuiltInMetadata.NonCumulativeCost.Handler.class);
        this.parallelismHandler = provider.handler(BuiltInMetadata.Parallelism.Handler.class);
        this.percentageOriginalRowsHandler = provider.handler(BuiltInMetadata.PercentageOriginalRows.Handler.class);
        this.populationSizeHandler = provider.handler(BuiltInMetadata.PopulationSize.Handler.class);
        this.predicatesHandler = provider.handler(BuiltInMetadata.Predicates.Handler.class);
        this.allPredicatesHandler = provider.handler(BuiltInMetadata.AllPredicates.Handler.class);
        this.nodeTypesHandler = provider.handler(BuiltInMetadata.NodeTypes.Handler.class);
        this.rowCountHandler = provider.handler(BuiltInMetadata.RowCount.Handler.class);
        this.selectivityHandler = provider.handler(BuiltInMetadata.Selectivity.Handler.class);
        this.sizeHandler = provider.handler(BuiltInMetadata.Size.Handler.class);
        this.uniqueKeysHandler = provider.handler(BuiltInMetadata.UniqueKeys.Handler.class);
        this.lowerBoundCostHandler = provider.handler(BuiltInMetadata.LowerBoundCost.Handler.class);
    }

    private RelMetadataQuery(boolean dummy) {
        super(null);
        this.collationHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Collation.Handler.class);
        this.columnOriginHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.ColumnOrigin.Handler.class);
        this.expressionLineageHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.ExpressionLineage.Handler.class);
        this.tableReferencesHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.TableReferences.Handler.class);
        this.columnUniquenessHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.ColumnUniqueness.Handler.class);
        this.cumulativeCostHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.CumulativeCost.Handler.class);
        this.distinctRowCountHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.DistinctRowCount.Handler.class);
        this.distributionHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Distribution.Handler.class);
        this.explainVisibilityHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.ExplainVisibility.Handler.class);
        this.maxRowCountHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.MaxRowCount.Handler.class);
        this.minRowCountHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.MinRowCount.Handler.class);
        this.memoryHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Memory.Handler.class);
        this.measureHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Measure.Handler.class);
        this.nonCumulativeCostHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.NonCumulativeCost.Handler.class);
        this.parallelismHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Parallelism.Handler.class);
        this.percentageOriginalRowsHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.PercentageOriginalRows.Handler.class);
        this.populationSizeHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.PopulationSize.Handler.class);
        this.predicatesHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Predicates.Handler.class);
        this.allPredicatesHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.AllPredicates.Handler.class);
        this.nodeTypesHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.NodeTypes.Handler.class);
        this.rowCountHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.RowCount.Handler.class);
        this.selectivityHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Selectivity.Handler.class);
        this.sizeHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.Size.Handler.class);
        this.uniqueKeysHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.UniqueKeys.Handler.class);
        this.lowerBoundCostHandler = RelMetadataQuery.initialHandler(BuiltInMetadata.LowerBoundCost.Handler.class);
    }

    private RelMetadataQuery(MetadataHandlerProvider metadataHandlerProvider, RelMetadataQuery prototype) {
        super(metadataHandlerProvider);
        this.collationHandler = prototype.collationHandler;
        this.columnOriginHandler = prototype.columnOriginHandler;
        this.expressionLineageHandler = prototype.expressionLineageHandler;
        this.tableReferencesHandler = prototype.tableReferencesHandler;
        this.columnUniquenessHandler = prototype.columnUniquenessHandler;
        this.cumulativeCostHandler = prototype.cumulativeCostHandler;
        this.distinctRowCountHandler = prototype.distinctRowCountHandler;
        this.distributionHandler = prototype.distributionHandler;
        this.explainVisibilityHandler = prototype.explainVisibilityHandler;
        this.maxRowCountHandler = prototype.maxRowCountHandler;
        this.minRowCountHandler = prototype.minRowCountHandler;
        this.memoryHandler = prototype.memoryHandler;
        this.measureHandler = prototype.measureHandler;
        this.nonCumulativeCostHandler = prototype.nonCumulativeCostHandler;
        this.parallelismHandler = prototype.parallelismHandler;
        this.percentageOriginalRowsHandler = prototype.percentageOriginalRowsHandler;
        this.populationSizeHandler = prototype.populationSizeHandler;
        this.predicatesHandler = prototype.predicatesHandler;
        this.allPredicatesHandler = prototype.allPredicatesHandler;
        this.nodeTypesHandler = prototype.nodeTypesHandler;
        this.rowCountHandler = prototype.rowCountHandler;
        this.selectivityHandler = prototype.selectivityHandler;
        this.sizeHandler = prototype.sizeHandler;
        this.uniqueKeysHandler = prototype.uniqueKeysHandler;
        this.lowerBoundCostHandler = prototype.lowerBoundCostHandler;
    }

    public static RelMetadataQuery instance() {
        return new RelMetadataQuery();
    }

    /*
     * Loose catch block
     */
    public @Nullable Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(RelNode rel) {
        while (true) {
            try {
                return this.nodeTypesHandler.getNodeTypes(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.nodeTypesHandler = this.revise(BuiltInMetadata.NodeTypes.Handler.class);
                continue;
            }
            break;
        }
        catch (CyclicMetadataException e) {
            return null;
        }
    }

    public Double getRowCount(RelNode rel) {
        while (true) {
            try {
                Double result2 = this.rowCountHandler.getRowCount(rel, this);
                return RelMdUtil.validateResult(Nullness.castNonNull(result2));
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.rowCountHandler = this.revise(BuiltInMetadata.RowCount.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Double getMaxRowCount(RelNode rel) {
        while (true) {
            try {
                return this.maxRowCountHandler.getMaxRowCount(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.maxRowCountHandler = this.revise(BuiltInMetadata.MaxRowCount.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Double getMinRowCount(RelNode rel) {
        while (true) {
            try {
                return this.minRowCountHandler.getMinRowCount(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.minRowCountHandler = this.revise(BuiltInMetadata.MinRowCount.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable RelOptCost getCumulativeCost(RelNode rel) {
        while (true) {
            try {
                return this.cumulativeCostHandler.getCumulativeCost(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.cumulativeCostHandler = this.revise(BuiltInMetadata.CumulativeCost.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable RelOptCost getNonCumulativeCost(RelNode rel) {
        while (true) {
            try {
                return this.nonCumulativeCostHandler.getNonCumulativeCost(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.nonCumulativeCostHandler = this.revise(BuiltInMetadata.NonCumulativeCost.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Double getPercentageOriginalRows(RelNode rel) {
        while (true) {
            try {
                Double result2 = this.percentageOriginalRowsHandler.getPercentageOriginalRows(rel, this);
                return RelMdUtil.validatePercentage(result2);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.percentageOriginalRowsHandler = this.revise(BuiltInMetadata.PercentageOriginalRows.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Set<RelColumnOrigin> getColumnOrigins(RelNode rel, int column) {
        while (true) {
            try {
                return this.columnOriginHandler.getColumnOrigins(rel, this, column);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.columnOriginHandler = this.revise(BuiltInMetadata.ColumnOrigin.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable RelColumnOrigin getColumnOrigin(RelNode rel, int column) {
        Set<RelColumnOrigin> origins = this.getColumnOrigins(rel, column);
        if (origins == null || origins.size() != 1) {
            return null;
        }
        RelColumnOrigin origin = Iterables.getOnlyElement(origins);
        return origin;
    }

    public @Nullable Set<RexNode> getExpressionLineage(RelNode rel, RexNode expression) {
        while (true) {
            try {
                return this.expressionLineageHandler.getExpressionLineage(rel, this, expression);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.expressionLineageHandler = this.revise(BuiltInMetadata.ExpressionLineage.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Set<RexTableInputRef.RelTableRef> getTableReferences(RelNode rel) {
        while (true) {
            try {
                return this.tableReferencesHandler.getTableReferences(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.tableReferencesHandler = this.revise(BuiltInMetadata.TableReferences.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable RelOptTable getTableOrigin(RelNode rel) {
        if (rel.getRowType().getFieldCount() == 0) {
            return null;
        }
        Set<RelColumnOrigin> colOrigins = this.getColumnOrigins(rel, 0);
        if (colOrigins == null || colOrigins.isEmpty()) {
            return null;
        }
        return colOrigins.iterator().next().getOriginTable();
    }

    public @Nullable Double getSelectivity(RelNode rel, @Nullable RexNode predicate) {
        while (true) {
            try {
                Double result2 = this.selectivityHandler.getSelectivity(rel, this, predicate);
                return RelMdUtil.validatePercentage(result2);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.selectivityHandler = this.revise(BuiltInMetadata.Selectivity.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(RelNode rel) {
        return this.getUniqueKeys(rel, false);
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(RelNode rel, boolean ignoreNulls) {
        while (true) {
            try {
                return this.uniqueKeysHandler.getUniqueKeys(rel, this, ignoreNulls);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.uniqueKeysHandler = this.revise(BuiltInMetadata.UniqueKeys.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Boolean areRowsUnique(RelNode rel, boolean ignoreNulls) {
        Double maxRowCount = this.getMaxRowCount(rel);
        if (maxRowCount != null && maxRowCount <= 1.0) {
            return true;
        }
        ImmutableBitSet columns = ImmutableBitSet.range(rel.getRowType().getFieldCount());
        return this.areColumnsUnique(rel, columns, ignoreNulls);
    }

    public @Nullable Boolean areRowsUnique(RelNode rel) {
        return this.areRowsUnique(rel, false);
    }

    public @Nullable Boolean areColumnsUnique(RelNode rel, ImmutableBitSet columns) {
        return this.areColumnsUnique(rel, columns, false);
    }

    public @Nullable Boolean areColumnsUnique(RelNode rel, ImmutableBitSet columns, boolean ignoreNulls) {
        while (true) {
            try {
                return this.columnUniquenessHandler.areColumnsUnique(rel, this, columns, ignoreNulls);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.columnUniquenessHandler = this.revise(BuiltInMetadata.ColumnUniqueness.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable ImmutableList<RelCollation> collations(RelNode rel) {
        while (true) {
            try {
                return this.collationHandler.collations(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.collationHandler = this.revise(BuiltInMetadata.Collation.Handler.class);
                continue;
            }
            break;
        }
    }

    public RelDistribution distribution(RelNode rel) {
        while (true) {
            try {
                RelDistribution distribution = this.distributionHandler.distribution(rel, this);
                if (distribution == null) {
                    return RelDistributions.ANY;
                }
                return distribution;
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.distributionHandler = this.revise(BuiltInMetadata.Distribution.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Double getPopulationSize(RelNode rel, ImmutableBitSet groupKey) {
        while (true) {
            try {
                Double result2 = this.populationSizeHandler.getPopulationSize(rel, this, groupKey);
                return RelMdUtil.validateResult(result2);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.populationSizeHandler = this.revise(BuiltInMetadata.PopulationSize.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Double getAverageRowSize(RelNode rel) {
        while (true) {
            try {
                return this.sizeHandler.averageRowSize(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.sizeHandler = this.revise(BuiltInMetadata.Size.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable List<@Nullable Double> getAverageColumnSizes(RelNode rel) {
        while (true) {
            try {
                return this.sizeHandler.averageColumnSizes(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.sizeHandler = this.revise(BuiltInMetadata.Size.Handler.class);
                continue;
            }
            break;
        }
    }

    public List<@Nullable Double> getAverageColumnSizesNotNull(RelNode rel) {
        @Nullable List<@Nullable Double> averageColumnSizes = this.getAverageColumnSizes(rel);
        return averageColumnSizes == null ? Collections.nCopies(rel.getRowType().getFieldCount(), null) : averageColumnSizes;
    }

    public @Nullable Boolean isPhaseTransition(RelNode rel) {
        while (true) {
            try {
                return this.parallelismHandler.isPhaseTransition(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.parallelismHandler = this.revise(BuiltInMetadata.Parallelism.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Integer splitCount(RelNode rel) {
        while (true) {
            try {
                return this.parallelismHandler.splitCount(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.parallelismHandler = this.revise(BuiltInMetadata.Parallelism.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Double memory(RelNode rel) {
        while (true) {
            try {
                return this.memoryHandler.memory(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.memoryHandler = this.revise(BuiltInMetadata.Memory.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Double cumulativeMemoryWithinPhase(RelNode rel) {
        while (true) {
            try {
                return this.memoryHandler.cumulativeMemoryWithinPhase(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.memoryHandler = this.revise(BuiltInMetadata.Memory.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Double cumulativeMemoryWithinPhaseSplit(RelNode rel) {
        while (true) {
            try {
                return this.memoryHandler.cumulativeMemoryWithinPhaseSplit(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.memoryHandler = this.revise(BuiltInMetadata.Memory.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Boolean isMeasure(RelNode rel, int column) {
        while (true) {
            try {
                return this.measureHandler.isMeasure(rel, this, column);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.measureHandler = this.revise(BuiltInMetadata.Measure.Handler.class);
                continue;
            }
            break;
        }
    }

    public RexNode expand(RelNode rel, int column, BuiltInMetadata.Measure.Context context) {
        while (true) {
            try {
                return this.measureHandler.expand(rel, this, column, context);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.measureHandler = this.revise(BuiltInMetadata.Measure.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable Double getDistinctRowCount(RelNode rel, ImmutableBitSet groupKey, @Nullable RexNode predicate) {
        while (true) {
            try {
                Double result2 = this.distinctRowCountHandler.getDistinctRowCount(rel, this, groupKey, predicate);
                return RelMdUtil.validateResult(result2);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.distinctRowCountHandler = this.revise(BuiltInMetadata.DistinctRowCount.Handler.class);
                continue;
            }
            break;
        }
    }

    public RelOptPredicateList getPulledUpPredicates(RelNode rel) {
        while (true) {
            try {
                RelOptPredicateList result2 = this.predicatesHandler.getPredicates(rel, this);
                return result2 != null ? result2 : RelOptPredicateList.EMPTY;
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.predicatesHandler = this.revise(BuiltInMetadata.Predicates.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable RelOptPredicateList getAllPredicates(RelNode rel) {
        while (true) {
            try {
                return this.allPredicatesHandler.getAllPredicates(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.allPredicatesHandler = this.revise(BuiltInMetadata.AllPredicates.Handler.class);
                continue;
            }
            break;
        }
    }

    public Boolean isVisibleInExplain(RelNode rel, SqlExplainLevel explainLevel) {
        while (true) {
            try {
                Boolean b = this.explainVisibilityHandler.isVisibleInExplain(rel, this, explainLevel);
                return b == null || b != false;
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.explainVisibilityHandler = this.revise(BuiltInMetadata.ExplainVisibility.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable RelDistribution getDistribution(RelNode rel) {
        while (true) {
            try {
                return this.distributionHandler.distribution(rel, this);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.distributionHandler = this.revise(BuiltInMetadata.Distribution.Handler.class);
                continue;
            }
            break;
        }
    }

    public @Nullable RelOptCost getLowerBoundCost(RelNode rel, VolcanoPlanner planner) {
        while (true) {
            try {
                return this.lowerBoundCostHandler.getLowerBoundCost(rel, this, planner);
            }
            catch (MetadataHandlerProvider.NoHandler e) {
                this.lowerBoundCostHandler = this.revise(BuiltInMetadata.LowerBoundCost.Handler.class);
                continue;
            }
            break;
        }
    }
}

