/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.dlsfls;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.rfksystems.blake2b.Blake2b;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.util.BytesRef;
import org.bouncycastle.util.encoders.Hex;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.configuration.Salt;
import org.opensearch.security.privileges.PrivilegesConfigurationValidationException;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluationException;
import org.opensearch.security.privileges.dlsfls.AbstractRuleBasedPrivileges;
import org.opensearch.security.privileges.dlsfls.FieldPrivileges;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.RoleV7;
import org.opensearch.security.support.WildcardMatcher;

public class FieldMasking
extends AbstractRuleBasedPrivileges<FieldMaskingRule.SimpleRule, FieldMaskingRule> {
    private final Config fieldMaskingConfig;

    public FieldMasking(SecurityDynamicConfiguration<RoleV7> roles, Map<String, IndexAbstraction> indexMetadata, Config fieldMaskingConfig, Settings settings) {
        super(roles, indexMetadata, (RoleV7.Index rolePermissions) -> FieldMasking.roleToRule(rolePermissions, fieldMaskingConfig), settings);
        this.fieldMaskingConfig = fieldMaskingConfig;
    }

    static FieldMaskingRule.SimpleRule roleToRule(RoleV7.Index rolePermissions, Config fieldMaskingConfig) throws PrivilegesConfigurationValidationException {
        List<String> fmExpressions = rolePermissions.getMasked_fields();
        if (fmExpressions != null && !fmExpressions.isEmpty()) {
            return new FieldMaskingRule.SimpleRule(rolePermissions, fieldMaskingConfig);
        }
        return null;
    }

    @Override
    protected FieldMaskingRule unrestricted() {
        return FieldMaskingRule.ALLOW_ALL;
    }

    @Override
    protected FieldMaskingRule fullyRestricted() {
        return new FieldMaskingRule.SimpleRule((ImmutableList<FieldMaskingRule.Field>)ImmutableList.of((Object)new FieldMaskingRule.Field(FieldMaskingExpression.MASK_ALL, this.fieldMaskingConfig)));
    }

    @Override
    protected FieldMaskingRule compile(PrivilegesEvaluationContext context, Collection<FieldMaskingRule.SimpleRule> rules) throws PrivilegesEvaluationException {
        return new FieldMaskingRule.MultiRole(rules);
    }

    public static class Config {
        public static final String BLAKE2B_LEGACY_DEFAULT = "BLAKE2B_LEGACY_DEFAULT";
        public static final Config DEFAULT = Config.fromSettings(Settings.EMPTY);
        private final String defaultHashAlgorithm;
        private final Salt salt;
        private final boolean useLegacyDefaultAlgorithm;

        public static Config fromSettings(Settings settings) {
            return new Config(settings.get("plugins.security.masked_fields.algorithm.default"), Salt.from(settings));
        }

        Config(String defaultHashAlgorithm, Salt salt) {
            this.defaultHashAlgorithm = defaultHashAlgorithm;
            this.salt = salt;
            this.useLegacyDefaultAlgorithm = BLAKE2B_LEGACY_DEFAULT.equalsIgnoreCase(defaultHashAlgorithm);
        }

        public String getDefaultHashAlgorithm() {
            return this.defaultHashAlgorithm;
        }

        public Salt getSalt() {
            return this.salt;
        }

        public boolean useLegacyDefaultAlgorithm() {
            return this.useLegacyDefaultAlgorithm;
        }
    }

    public static abstract class FieldMaskingRule
    extends AbstractRuleBasedPrivileges.Rule {
        public static final FieldMaskingRule ALLOW_ALL = new SimpleRule((ImmutableList<Field>)ImmutableList.of());

        public static FieldMaskingRule of(Config fieldMaskingConfig, String ... rules) throws PrivilegesConfigurationValidationException {
            ImmutableList.Builder patterns = new ImmutableList.Builder();
            for (String rule : rules) {
                patterns.add((Object)new Field(new FieldMaskingExpression(rule), fieldMaskingConfig));
            }
            return new SimpleRule((ImmutableList<Field>)patterns.build());
        }

        public abstract Field get(String var1);

        public abstract boolean isAllowAll();

        public boolean isMasked(String field) {
            return this.get(field) != null;
        }

        @Override
        public boolean isUnrestricted() {
            return this.isAllowAll();
        }

        public abstract List<String> getSource();

        public static class Field {
            private final FieldMaskingExpression expression;
            private final String hashAlgorithm;
            private final Salt salt;
            private final byte[] saltBytes;
            private final boolean useLegacyDefaultAlgorithm;

            Field(FieldMaskingExpression expression, Config fieldMaskingConfig) {
                this.expression = expression;
                this.hashAlgorithm = expression.getAlgoName() != null ? expression.getAlgoName() : (StringUtils.isNotEmpty((CharSequence)fieldMaskingConfig.getDefaultHashAlgorithm()) ? fieldMaskingConfig.getDefaultHashAlgorithm() : null);
                this.useLegacyDefaultAlgorithm = fieldMaskingConfig.useLegacyDefaultAlgorithm();
                this.salt = fieldMaskingConfig.getSalt();
                this.saltBytes = this.salt.getSalt16();
            }

            public WildcardMatcher getPattern() {
                return this.expression.getPattern();
            }

            public byte[] apply(byte[] value) {
                if (this.expression.getRegexReplacements() != null) {
                    return this.applyRegexReplacements(value, this.expression.getRegexReplacements());
                }
                if (this.useLegacyDefaultAlgorithm) {
                    return this.blake2bHash(value, true);
                }
                if (this.hashAlgorithm != null) {
                    return Field.customHash(value, this.hashAlgorithm);
                }
                return this.blake2bHash(value, false);
            }

            public String apply(String value) {
                return new String(this.apply(value.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            }

            public BytesRef apply(BytesRef value) {
                if (value == null) {
                    return null;
                }
                return new BytesRef(this.apply(BytesRef.deepCopyOf((BytesRef)value).bytes));
            }

            public String toString() {
                return this.expression.toString();
            }

            String getSource() {
                return this.expression.getSource();
            }

            FieldMaskingExpression getExpression() {
                return this.expression;
            }

            private static byte[] customHash(byte[] in, String algorithm) {
                try {
                    MessageDigest digest = MessageDigest.getInstance(algorithm);
                    return Hex.encode((byte[])digest.digest(in));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            private byte[] applyRegexReplacements(byte[] value, List<FieldMaskingExpression.RegexReplacement> regexReplacements) {
                String string = new String(value, StandardCharsets.UTF_8);
                for (FieldMaskingExpression.RegexReplacement rr : regexReplacements) {
                    string = rr.getRegex().matcher(string).replaceAll(rr.getReplacement());
                }
                return string.getBytes(StandardCharsets.UTF_8);
            }

            private byte[] blake2bHash(byte[] in, boolean useLegacyDefaultAlgorithm) {
                Blake2b hash = useLegacyDefaultAlgorithm ? new Blake2b(null, 32, null, this.saltBytes) : new Blake2b(null, 32, this.saltBytes, null);
                hash.update(in, 0, in.length);
                byte[] out = new byte[hash.getDigestSize()];
                hash.digest(out, 0);
                return Hex.encode((byte[])out);
            }
        }

        public static class SimpleRule
        extends FieldMaskingRule {
            final RoleV7.Index sourceIndex;
            final ImmutableList<Field> expressions;

            SimpleRule(RoleV7.Index sourceIndex, Config fieldMaskingConfig) throws PrivilegesConfigurationValidationException {
                this.sourceIndex = sourceIndex;
                this.expressions = SimpleRule.parseExpressions(sourceIndex, fieldMaskingConfig);
            }

            SimpleRule(ImmutableList<Field> expressions) {
                this.sourceIndex = null;
                this.expressions = expressions;
            }

            @Override
            public Field get(String field) {
                return this.internalGet(FieldPrivileges.normalizeFieldName(field));
            }

            private Field internalGet(String field) {
                for (Field expression : this.expressions) {
                    if (!expression.getPattern().test(field)) continue;
                    return expression;
                }
                return null;
            }

            @Override
            public boolean isAllowAll() {
                return this.expressions.isEmpty();
            }

            public String toString() {
                if (this.isAllowAll()) {
                    return "FM:[]";
                }
                return "FM:" + String.valueOf(this.expressions);
            }

            @Override
            public List<String> getSource() {
                return this.expressions.stream().map(Field::getSource).collect(Collectors.toList());
            }

            static ImmutableList<Field> parseExpressions(RoleV7.Index index, Config fieldMaskingConfig) throws PrivilegesConfigurationValidationException {
                ImmutableList.Builder result = ImmutableList.builder();
                for (String source : index.getMasked_fields()) {
                    result.add((Object)new Field(new FieldMaskingExpression(source), fieldMaskingConfig));
                }
                return result.build();
            }
        }

        public static class MultiRole
        extends FieldMaskingRule {
            final ImmutableList<SimpleRule> parts;
            final boolean allowAll;

            MultiRole(Collection<SimpleRule> parts) {
                this.parts = ImmutableList.copyOf(parts);
                this.allowAll = this.parts.stream().anyMatch(SimpleRule::isAllowAll);
            }

            @Override
            public Field get(String field) {
                field = FieldPrivileges.normalizeFieldName(field);
                for (SimpleRule part : this.parts) {
                    Field masking = part.get(field);
                    if (masking == null) continue;
                    return masking;
                }
                return null;
            }

            @Override
            public boolean isAllowAll() {
                return this.allowAll;
            }

            public String toString() {
                if (this.isAllowAll()) {
                    return "FM:[]";
                }
                return "FM:" + String.valueOf(this.parts.stream().map(p -> p.expressions).collect(Collectors.toList()));
            }

            @Override
            public List<String> getSource() {
                return this.parts.stream().flatMap(r -> r.getSource().stream()).collect(Collectors.toList());
            }
        }
    }

    public static class FieldMaskingExpression {
        public static final FieldMaskingExpression MASK_ALL = new FieldMaskingExpression(WildcardMatcher.ANY, "*");
        private final WildcardMatcher pattern;
        private final String algoName;
        private final List<RegexReplacement> regexReplacements;
        private final String source;

        public FieldMaskingExpression(String value) throws PrivilegesConfigurationValidationException {
            this.source = value;
            List tokens = Splitter.on((String)"::").splitToList((CharSequence)value);
            this.pattern = WildcardMatcher.from((String)tokens.get(0));
            if (tokens.size() == 1) {
                this.algoName = null;
                this.regexReplacements = null;
            } else if (tokens.size() == 2) {
                this.regexReplacements = null;
                try {
                    this.algoName = (String)tokens.get(1);
                    MessageDigest.getInstance((String)tokens.get(1));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new PrivilegesConfigurationValidationException("Invalid algorithm " + (String)tokens.get(1));
                }
            } else if (tokens.size() % 2 == 1) {
                this.algoName = null;
                this.regexReplacements = new ArrayList<RegexReplacement>((tokens.size() - 1) / 2);
                for (int i = 1; i < tokens.size() - 1; i += 2) {
                    this.regexReplacements.add(new RegexReplacement((String)tokens.get(i), (String)tokens.get(i + 1)));
                }
            } else {
                throw new PrivilegesConfigurationValidationException("A field masking expression must have the form 'field_name', 'field_name::algorithm', 'field_name::regex::replacement' or 'field_name::(regex::replacement)+'");
            }
        }

        private FieldMaskingExpression(WildcardMatcher pattern, String source) {
            this.pattern = pattern;
            this.source = source;
            this.algoName = null;
            this.regexReplacements = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldMaskingExpression)) {
                return false;
            }
            FieldMaskingExpression that = (FieldMaskingExpression)o;
            return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.algoName, that.algoName) && Objects.equals(this.regexReplacements, that.regexReplacements);
        }

        public int hashCode() {
            return Objects.hash(this.pattern, this.algoName, this.regexReplacements);
        }

        public String toString() {
            return this.source;
        }

        String getAlgoName() {
            return this.algoName;
        }

        List<RegexReplacement> getRegexReplacements() {
            return this.regexReplacements;
        }

        WildcardMatcher getPattern() {
            return this.pattern;
        }

        String getSource() {
            return this.source;
        }

        static class RegexReplacement {
            private final Pattern regex;
            private final String replacement;

            RegexReplacement(String regex, String replacement) throws PrivilegesConfigurationValidationException {
                if (!regex.startsWith("/") || !regex.endsWith("/")) {
                    throw new PrivilegesConfigurationValidationException("A regular expression needs to be wrapped in /.../");
                }
                try {
                    this.regex = Pattern.compile(regex.substring(1).substring(0, regex.length() - 2));
                }
                catch (PatternSyntaxException e) {
                    throw new PrivilegesConfigurationValidationException(e.getMessage(), e);
                }
                this.replacement = replacement;
            }

            Pattern getRegex() {
                return this.regex;
            }

            String getReplacement() {
                return this.replacement;
            }

            public String toString() {
                return "/" + String.valueOf(this.regex) + "/::" + this.replacement;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof RegexReplacement)) {
                    return false;
                }
                RegexReplacement that = (RegexReplacement)o;
                return Objects.equals(this.regex.pattern(), that.regex.pattern()) && Objects.equals(this.replacement, that.replacement);
            }

            public int hashCode() {
                return Objects.hash(this.regex.pattern(), this.replacement);
            }
        }
    }
}

