/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.security.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.LockableClassToInstanceMultiMap;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.InitializableComponent;
import net.shibboleth.shared.component.UninitializedComponentException;
import net.shibboleth.shared.component.UnmodifiableComponentException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.security.impl.SAMLMDCredentialContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialContextSet;
import org.opensaml.security.credential.MutableCredential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.impl.AbstractCriteriaFilteringCredentialResolver;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.slf4j.Logger;

public class MetadataCredentialResolver
extends AbstractCriteriaFilteringCredentialResolver
implements InitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MetadataCredentialResolver.class);
    @Nullable
    private RoleDescriptorResolver roleDescriptorResolver;
    @NonnullAfterInit
    private KeyInfoCredentialResolver keyInfoCredentialResolver;
    private boolean isInitialized;

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected void ifNotInitializedThrowUninitializedComponentException() {
        if (!this.isInitialized()) {
            throw new UninitializedComponentException("Unidentified Component has not yet been initialized and cannot be used.");
        }
    }

    protected void ifInitializedThrowUnmodifiabledComponentException() {
        if (this.isInitialized()) {
            throw new UnmodifiableComponentException("Unidentified Component has already been initialized and can no longer be modified");
        }
    }

    @Override
    public void initialize() throws ComponentInitializationException {
        if (this.getKeyInfoCredentialResolver() == null) {
            throw new ComponentInitializationException("A KeyInfoCredentialResolver instance is required");
        }
        if (this.getRoleDescriptorResolver() == null) {
            this.log.info("RoleDescriptorResolver was not supplied, credentials may only be resolved via RoleDescriptorCriterion");
        }
        this.isInitialized = true;
    }

    @Nullable
    public RoleDescriptorResolver getRoleDescriptorResolver() {
        return this.roleDescriptorResolver;
    }

    public void setRoleDescriptorResolver(@Nullable RoleDescriptorResolver resolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.roleDescriptorResolver = resolver;
    }

    @NonnullAfterInit
    public KeyInfoCredentialResolver getKeyInfoCredentialResolver() {
        return this.keyInfoCredentialResolver;
    }

    public void setKeyInfoCredentialResolver(@Nonnull KeyInfoCredentialResolver resolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.keyInfoCredentialResolver = Constraint.isNotNull(resolver, "KeyInfoCredentialResolver may not be null");
    }

    @Override
    @Nonnull
    protected Iterable<Credential> resolveFromSource(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        EntityRoleCriterion entityRoleCrit;
        RoleDescriptorCriterion roleCrit;
        this.ifNotInitializedThrowUninitializedComponentException();
        Constraint.isNotNull(criteriaSet, "CriteriaSet was null");
        UsageType usage = this.getEffectiveUsageInput(criteriaSet);
        RoleDescriptorCriterion roleDescriptorCriterion = roleCrit = criteriaSet != null ? criteriaSet.get(RoleDescriptorCriterion.class) : null;
        if (roleCrit != null) {
            return this.resolveFromRoleDescriptor(criteriaSet, roleCrit.getRole(), usage);
        }
        EntityIdCriterion entityIDCrit = criteriaSet != null ? criteriaSet.get(EntityIdCriterion.class) : null;
        EntityRoleCriterion entityRoleCriterion = entityRoleCrit = criteriaSet != null ? criteriaSet.get(EntityRoleCriterion.class) : null;
        if (entityIDCrit != null && entityRoleCrit != null) {
            ProtocolCriterion protocolCriteria;
            if (this.getRoleDescriptorResolver() == null) {
                throw new ResolverException("EntityID and role input were supplied but no RoleDescriptorResolver is configured");
            }
            String entityID = entityIDCrit.getEntityId();
            QName role = entityRoleCrit.getRole();
            String protocol = null;
            ProtocolCriterion protocolCriterion = protocolCriteria = criteriaSet != null ? criteriaSet.get(ProtocolCriterion.class) : null;
            if (protocolCriteria != null) {
                protocol = protocolCriteria.getProtocol();
            }
            return this.resolveFromMetadata(criteriaSet, entityID, role, protocol, usage);
        }
        throw new ResolverException("Criteria contained neither RoleDescriptorCriterion nor EntityIdCriterion + EntityRoleCriterion, could not perform resolution");
    }

    @Nonnull
    protected UsageType getEffectiveUsageInput(@Nullable CriteriaSet criteriaSet) {
        UsageCriterion usageCriteria;
        UsageCriterion usageCriterion = usageCriteria = criteriaSet != null ? criteriaSet.get(UsageCriterion.class) : null;
        if (usageCriteria != null) {
            return usageCriteria.getUsage();
        }
        return UsageType.UNSPECIFIED;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Collection<Credential> resolveFromRoleDescriptor(@Nullable CriteriaSet criteriaSet, @Nonnull RoleDescriptor roleDescriptor, @Nonnull UsageType usage) throws ResolverException {
        String entityID = null;
        XMLObject xMLObject = roleDescriptor.getParent();
        if (xMLObject instanceof EntityDescriptor) {
            EntityDescriptor entity = (EntityDescriptor)xMLObject;
            entityID = entity.getEntityID();
        }
        this.log.debug("Resolving credentials from supplied RoleDescriptor using usage: {}.  Effective entityID was: {}", (Object)usage, (Object)entityID);
        LinkedHashSet<Credential> credentials = new LinkedHashSet<Credential>(3);
        this.processRoleDescriptor(credentials, roleDescriptor, entityID, usage);
        return credentials;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Collection<Credential> resolveFromMetadata(@Nullable CriteriaSet criteriaSet, @Nonnull @NotEmpty String entityID, @Nonnull QName role, @Nullable String protocol, @Nonnull UsageType usage) throws ResolverException {
        this.log.debug("Resolving credentials from metadata using entityID: {}, role: {}, protocol: {}, usage: {}", new Object[]{entityID, role, protocol, usage});
        LinkedHashSet<Credential> credentials = new LinkedHashSet<Credential>(3);
        Iterable<RoleDescriptor> roleDescriptors = this.getRoleDescriptors(criteriaSet, entityID, role, protocol);
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            assert (roleDescriptor != null);
            this.processRoleDescriptor(credentials, roleDescriptor, entityID, usage);
        }
        return credentials;
    }

    protected void processRoleDescriptor(@Nonnull Collection<Credential> accumulator, @Nonnull RoleDescriptor roleDescriptor, @Nullable String entityID, @Nonnull UsageType usage) throws ResolverException {
        List<KeyDescriptor> keyDescriptors = roleDescriptor.getKeyDescriptors();
        for (KeyDescriptor keyDescriptor : keyDescriptors) {
            UsageType mdUsage = keyDescriptor.getUse();
            if (mdUsage == null) {
                mdUsage = UsageType.UNSPECIFIED;
            }
            if (!this.matchUsage(mdUsage, usage) || keyDescriptor.getKeyInfo() == null) continue;
            this.extractCredentials(accumulator, keyDescriptor, entityID, mdUsage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractCredentials(@Nonnull Collection<Credential> accumulator, @Nonnull KeyDescriptor keyDescriptor, @Nullable String entityID, @Nonnull UsageType mdUsage) throws ResolverException {
        List<Credential> cachedCreds;
        LockableClassToInstanceMultiMap<Object> keyDescriptorObjectMetadata = keyDescriptor.getObjectMetadata();
        ReadWriteLock rwlock = keyDescriptorObjectMetadata.getReadWriteLock();
        try {
            rwlock.readLock().lock();
            cachedCreds = keyDescriptorObjectMetadata.get(Credential.class);
            if (!cachedCreds.isEmpty()) {
                this.log.debug("Resolved cached credentials from KeyDescriptor object metadata");
                accumulator.addAll(cachedCreds);
                return;
            }
            this.log.debug("Found no cached credentials in KeyDescriptor object metadata, resolving from KeyInfo");
        }
        finally {
            rwlock.readLock().unlock();
        }
        try {
            rwlock.writeLock().lock();
            cachedCreds = keyDescriptorObjectMetadata.get(Credential.class);
            if (!cachedCreds.isEmpty()) {
                this.log.debug("Credentials were resolved and cached by another thread while this thread was waiting on the write lock");
                accumulator.addAll(cachedCreds);
                return;
            }
            ArrayList<Credential> newCreds = new ArrayList<Credential>();
            CriteriaSet critSet = new CriteriaSet();
            critSet.add(new KeyInfoCriterion(keyDescriptor.getKeyInfo()));
            Iterable resolvedCreds = this.getKeyInfoCredentialResolver().resolve(critSet);
            for (Credential cred : resolvedCreds) {
                CredentialContextSet contextSet;
                if (cred instanceof MutableCredential) {
                    MutableCredential mutableCred = (MutableCredential)cred;
                    mutableCred.setEntityId(entityID);
                    mutableCred.setUsageType(mdUsage);
                }
                if ((contextSet = cred.getCredentialContextSet()) != null) {
                    contextSet.add(new SAMLMDCredentialContext(keyDescriptor));
                }
                newCreds.add(cred);
            }
            keyDescriptorObjectMetadata.putAll(newCreds);
            accumulator.addAll(newCreds);
        }
        finally {
            rwlock.writeLock().unlock();
        }
    }

    protected boolean matchUsage(@Nonnull UsageType metadataUsage, @Nonnull UsageType criteriaUsage) {
        if (metadataUsage == UsageType.UNSPECIFIED || criteriaUsage == UsageType.UNSPECIFIED) {
            return true;
        }
        return metadataUsage == criteriaUsage;
    }

    @Nonnull
    protected Iterable<RoleDescriptor> getRoleDescriptors(@Nullable CriteriaSet criteriaSet, @Nonnull String entityID, @Nonnull QName role, @Nullable String protocol) throws ResolverException {
        RoleDescriptorResolver roleResolver = this.getRoleDescriptorResolver();
        if (roleResolver == null) {
            throw new ResolverException("No RoleDescriptorResolver is configured");
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Retrieving role descriptor metadata for entity '{}' in role '{}' for protocol '{}'", new Object[]{entityID, role, protocol});
            }
            CriteriaSet criteria = new CriteriaSet(new EntityIdCriterion(entityID), new EntityRoleCriterion(role));
            if (protocol != null) {
                criteria.add(new ProtocolCriterion(protocol));
            }
            return roleResolver.resolve(criteria);
        }
        catch (ResolverException e) {
            this.log.error("Unable to resolve information from metadata: {}", (Object)e.getMessage());
            throw new ResolverException("Unable to resolve information from metadata", e);
        }
    }
}

