/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import javax.annotation.Nonnull;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.metadata.Company;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.GivenName;
import org.opensaml.saml.saml2.metadata.SurName;
import org.opensaml.saml.saml2.metadata.TelephoneNumber;
import org.w3c.dom.Attr;

public class ContactPersonUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Override
    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        ContactPerson person = (ContactPerson)parentObject;
        if (childObject instanceof Extensions) {
            person.setExtensions((Extensions)childObject);
        } else if (childObject instanceof Company) {
            person.setCompany((Company)childObject);
        } else if (childObject instanceof GivenName) {
            person.setGivenName((GivenName)childObject);
        } else if (childObject instanceof SurName) {
            person.setSurName((SurName)childObject);
        } else if (childObject instanceof EmailAddress) {
            person.getEmailAddresses().add((EmailAddress)childObject);
        } else if (childObject instanceof TelephoneNumber) {
            person.getTelephoneNumbers().add((TelephoneNumber)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    @Override
    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        ContactPerson person = (ContactPerson)xmlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("contactType")) {
                try {
                    if (attribute.getValue() == null) {
                        throw new UnmarshallingException("Saw an empty value for contactType attribute");
                    }
                    person.setType(ContactPersonTypeEnumeration.valueOf(attribute.getValue().toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new UnmarshallingException("Saw an invalid value for contactType attribute: " + attribute.getValue());
                }
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        } else {
            this.processUnknownAttribute(person, attribute);
        }
    }
}

