/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.logging;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import org.jspecify.annotations.Nullable;
import reactor.netty.http.logging.HttpMessageType;
import reactor.netty.http.logging.LastHttpContentArgProvider;

final class FullHttpResponseArgProvider
extends LastHttpContentArgProvider {
    final HttpHeaders httpHeaders;
    final String protocol;
    final String status;

    FullHttpResponseArgProvider(FullHttpResponse fullHttpResponse, @Nullable HttpVersion actualVersion) {
        super((LastHttpContent)fullHttpResponse);
        this.httpHeaders = fullHttpResponse.headers();
        this.protocol = actualVersion != null ? actualVersion.text() : fullHttpResponse.protocolVersion().text();
        this.status = fullHttpResponse.status().toString();
    }

    @Override
    public HttpHeaders headers() {
        return this.httpHeaders;
    }

    @Override
    public HttpMessageType httpMessageType() {
        return HttpMessageType.FULL_RESPONSE;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String status() {
        return this.status;
    }
}

