/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterNetworkTypes
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterNetworkTypes> {
    @Nonnull
    private final Map<String, Integer> httpTypes;
    @Nonnull
    private final Map<String, Integer> transportTypes;
    public static final JsonpDeserializer<ClusterNetworkTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterNetworkTypes::setupClusterNetworkTypesDeserializer);

    private ClusterNetworkTypes(Builder builder) {
        this.httpTypes = ApiTypeHelper.unmodifiableRequired(builder.httpTypes, (Object)this, "httpTypes");
        this.transportTypes = ApiTypeHelper.unmodifiableRequired(builder.transportTypes, (Object)this, "transportTypes");
    }

    public static ClusterNetworkTypes of(Function<Builder, ObjectBuilder<ClusterNetworkTypes>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, Integer> httpTypes() {
        return this.httpTypes;
    }

    @Nonnull
    public final Map<String, Integer> transportTypes() {
        return this.transportTypes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("http_types");
        generator.writeStartObject();
        for (Map.Entry<String, Integer> item0 : this.httpTypes.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue().intValue());
        }
        generator.writeEnd();
        generator.writeKey("transport_types");
        generator.writeStartObject();
        for (Map.Entry<String, Integer> item0 : this.transportTypes.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue().intValue());
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterNetworkTypesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::httpTypes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "http_types");
        op.add(Builder::transportTypes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "transport_types");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.httpTypes.hashCode();
        result = 31 * result + this.transportTypes.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterNetworkTypes other = (ClusterNetworkTypes)o;
        return this.httpTypes.equals(other.httpTypes) && this.transportTypes.equals(other.transportTypes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterNetworkTypes> {
        private Map<String, Integer> httpTypes;
        private Map<String, Integer> transportTypes;

        public Builder() {
        }

        private Builder(ClusterNetworkTypes o) {
            this.httpTypes = Builder._mapCopy(o.httpTypes);
            this.transportTypes = Builder._mapCopy(o.transportTypes);
        }

        private Builder(Builder o) {
            this.httpTypes = Builder._mapCopy(o.httpTypes);
            this.transportTypes = Builder._mapCopy(o.transportTypes);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder httpTypes(Map<String, Integer> map) {
            this.httpTypes = Builder._mapPutAll(this.httpTypes, map);
            return this;
        }

        @Nonnull
        public final Builder httpTypes(String key, Integer value) {
            this.httpTypes = Builder._mapPut(this.httpTypes, key, value);
            return this;
        }

        @Nonnull
        public final Builder transportTypes(Map<String, Integer> map) {
            this.transportTypes = Builder._mapPutAll(this.transportTypes, map);
            return this;
        }

        @Nonnull
        public final Builder transportTypes(String key, Integer value) {
            this.transportTypes = Builder._mapPut(this.transportTypes, key, value);
            return this;
        }

        @Override
        @Nonnull
        public ClusterNetworkTypes build() {
            this._checkSingleUse();
            return new ClusterNetworkTypes(this);
        }
    }
}

