/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.core.DeleteByQueryRethrottleResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class DeleteByQueryRethrottleRequest
extends RequestBase
implements ToCopyableBuilder<Builder, DeleteByQueryRethrottleRequest> {
    @Nullable
    private final Float requestsPerSecond;
    @Nonnull
    private final String taskId;
    public static final Endpoint<DeleteByQueryRethrottleRequest, DeleteByQueryRethrottleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteByQueryRethrottleRequest, DeleteByQueryRethrottleResponse>(request -> "POST", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_delete_by_query/");
        SimpleEndpoint.pathEncode(request.taskId, buf);
        buf.append("/_rethrottle");
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteByQueryRethrottleResponse._DESERIALIZER);

    private DeleteByQueryRethrottleRequest(Builder builder) {
        super(builder);
        this.requestsPerSecond = builder.requestsPerSecond;
        this.taskId = ApiTypeHelper.requireNonNull(builder.taskId, this, "taskId");
    }

    public static DeleteByQueryRethrottleRequest of(Function<Builder, ObjectBuilder<DeleteByQueryRethrottleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Float requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nonnull
    public final String taskId() {
        return this.taskId;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.requestsPerSecond != null) {
            params.put("requests_per_second", String.valueOf(this.requestsPerSecond));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.requestsPerSecond);
        result = 31 * result + this.taskId.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteByQueryRethrottleRequest other = (DeleteByQueryRethrottleRequest)o;
        return Objects.equals(this.requestsPerSecond, other.requestsPerSecond) && this.taskId.equals(other.taskId);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, DeleteByQueryRethrottleRequest> {
        @Nullable
        private Float requestsPerSecond;
        private String taskId;

        public Builder() {
        }

        private Builder(DeleteByQueryRethrottleRequest o) {
            super(o);
            this.requestsPerSecond = o.requestsPerSecond;
            this.taskId = o.taskId;
        }

        private Builder(Builder o) {
            super(o);
            this.requestsPerSecond = o.requestsPerSecond;
            this.taskId = o.taskId;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder requestsPerSecond(@Nullable Float value) {
            this.requestsPerSecond = value;
            return this;
        }

        @Nonnull
        public final Builder taskId(String value) {
            this.taskId = value;
            return this;
        }

        @Override
        @Nonnull
        public DeleteByQueryRethrottleRequest build() {
            this._checkSingleUse();
            return new DeleteByQueryRethrottleRequest(this);
        }
    }
}

