"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BannerPlugin = void 0;
var _operators = require("rxjs/operators");
var _get_config = require("./routes/get_config");
var _ui_settings = require("./ui_settings");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                          * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                          * compatible open source license.
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          * Any modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                          * GitHub history for details.
                                                                                                                                                                                                                                                                                                                          */
class BannerPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "config$", void 0);
    _defineProperty(this, "pluginConfig", void 0);
    this.config$ = this.initializerContext.config.create();
  }
  async setup(core) {
    this.pluginConfig = await this.config$.pipe((0, _operators.first)()).toPromise();

    // Get the default UI settings
    const bannerSettings = (0, _ui_settings.getDefaultBannerSettings)();

    // Override the default values with values from YAML config
    if (bannerSettings['banner:content']) {
      bannerSettings['banner:content'].value = this.pluginConfig.content;
    }
    if (bannerSettings['banner:color']) {
      bannerSettings['banner:color'].value = this.pluginConfig.color;
    }
    if (bannerSettings['banner:iconType']) {
      bannerSettings['banner:iconType'].value = this.pluginConfig.iconType;
    }
    if (bannerSettings['banner:active']) {
      bannerSettings['banner:active'].value = this.pluginConfig.isVisible;
    }
    if (bannerSettings['banner:useMarkdown']) {
      bannerSettings['banner:useMarkdown'].value = this.pluginConfig.useMarkdown;
    }

    // Register UI settings with updated default values
    core.uiSettings.register(bannerSettings);
    const bannerSetup = {
      bannerEnabled: () => this.pluginConfig.enabled,
      getConfig: () => ({
        ...this.pluginConfig
      })
    };

    // Register server routes
    const router = core.http.createRouter();
    (0, _get_config.defineRoutes)(router, bannerSetup);
    return bannerSetup;
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.BannerPlugin = BannerPlugin;