/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.internal.hppc.IntHashSet;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.FSTReader;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;

public class SynonymMap {
    public static final char WORD_SEPARATOR = '\u0000';
    public final FST<BytesRef> fst;
    public final BytesRefHash words;
    public final int maxHorizontalContext;

    public SynonymMap(FST<BytesRef> fst, BytesRefHash words, int maxHorizontalContext) {
        this.fst = fst;
        this.words = words;
        this.maxHorizontalContext = maxHorizontalContext;
    }

    public static abstract class Parser
    extends Builder {
        private final Analyzer analyzer;

        public Parser(boolean dedup, Analyzer analyzer) {
            super(dedup);
            this.analyzer = analyzer;
        }

        public abstract void parse(Reader var1) throws IOException, ParseException;

        public CharsRef analyze(String text, CharsRefBuilder reuse) throws IOException {
            try (TokenStream ts = this.analyzer.tokenStream("", text);){
                CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
                PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)ts.addAttribute(PositionIncrementAttribute.class);
                ts.reset();
                reuse.clear();
                while (ts.incrementToken()) {
                    int length = termAtt.length();
                    if (length == 0) {
                        throw new IllegalArgumentException("term: " + text + " analyzed to a zero-length token");
                    }
                    if (posIncAtt.getPositionIncrement() != 1) {
                        throw new IllegalArgumentException("term: " + text + " analyzed to a token (" + String.valueOf(termAtt) + ") with position increment != 1 (got: " + posIncAtt.getPositionIncrement() + ")");
                    }
                    reuse.grow(reuse.length() + length + 1);
                    int end = reuse.length();
                    if (reuse.length() > 0) {
                        reuse.setCharAt(end++, '\u0000');
                        reuse.setLength(reuse.length() + 1);
                    }
                    System.arraycopy(termAtt.buffer(), 0, reuse.chars(), end, length);
                    reuse.setLength(reuse.length() + length);
                }
                ts.end();
            }
            if (reuse.length() == 0) {
                throw new IllegalArgumentException("term: " + text + " was completely eliminated by analyzer");
            }
            return reuse.get();
        }
    }

    public static class Builder {
        private final HashMap<CharsRef, MapEntry> workingSet = new HashMap();
        private final BytesRefHash words = new BytesRefHash();
        private final BytesRefBuilder utf8Scratch = new BytesRefBuilder();
        private int maxHorizontalContext;
        private final boolean dedup;

        public Builder() {
            this(true);
        }

        public Builder(boolean dedup) {
            this.dedup = dedup;
        }

        public static CharsRef join(String[] words, CharsRefBuilder reuse) {
            int upto = 0;
            char[] buffer = reuse.chars();
            for (String word : words) {
                int needed;
                int wordLen = word.length();
                int n = needed = 0 == upto ? wordLen : 1 + upto + wordLen;
                if (needed > buffer.length) {
                    reuse.grow(needed);
                    buffer = reuse.chars();
                }
                if (upto > 0) {
                    buffer[upto++] = '\u0000';
                }
                word.getChars(0, wordLen, buffer, upto);
                upto += wordLen;
            }
            reuse.setLength(upto);
            return reuse.get();
        }

        private boolean hasHoles(CharsRef chars) {
            int end = chars.offset + chars.length;
            for (int idx = chars.offset + 1; idx < end; ++idx) {
                if (chars.chars[idx] != '\u0000' || chars.chars[idx - 1] != '\u0000') continue;
                return true;
            }
            if (chars.chars[chars.offset] == '\u0000') {
                return true;
            }
            return chars.chars[chars.offset + chars.length - 1] == '\u0000';
        }

        private void add(CharsRef input, int numInputWords, CharsRef output, int numOutputWords, boolean includeOrig) {
            MapEntry e;
            if (numInputWords <= 0) {
                throw new IllegalArgumentException("numInputWords must be > 0 (got " + numInputWords + ")");
            }
            if (input.length <= 0) {
                throw new IllegalArgumentException("input.length must be > 0 (got " + input.length + ")");
            }
            if (numOutputWords <= 0) {
                throw new IllegalArgumentException("numOutputWords must be > 0 (got " + numOutputWords + ")");
            }
            if (output.length <= 0) {
                throw new IllegalArgumentException("output.length must be > 0 (got " + output.length + ")");
            }
            assert (!this.hasHoles(input)) : "input has holes: " + String.valueOf(input);
            assert (!this.hasHoles(output)) : "output has holes: " + String.valueOf(output);
            this.utf8Scratch.copyChars(output.chars, output.offset, output.length);
            int ord = this.words.add(this.utf8Scratch.get());
            if (ord < 0) {
                ord = -ord - 1;
            }
            if ((e = this.workingSet.get(input)) == null) {
                e = new MapEntry();
                this.workingSet.put(CharsRef.deepCopyOf((CharsRef)input), e);
            }
            e.ords.add(ord);
            e.includeOrig |= includeOrig;
            this.maxHorizontalContext = Math.max(this.maxHorizontalContext, numInputWords);
            this.maxHorizontalContext = Math.max(this.maxHorizontalContext, numOutputWords);
        }

        private int countWords(CharsRef chars) {
            int wordCount = 1;
            int upto = chars.offset;
            int limit = chars.offset + chars.length;
            while (upto < limit) {
                if (chars.chars[upto++] != '\u0000') continue;
                ++wordCount;
            }
            return wordCount;
        }

        public void add(CharsRef input, CharsRef output, boolean includeOrig) {
            this.add(input, this.countWords(input), output, this.countWords(output), includeOrig);
        }

        public SynonymMap build() throws IOException {
            ByteSequenceOutputs outputs = ByteSequenceOutputs.getSingleton();
            FSTCompiler fstCompiler = new FSTCompiler.Builder(FST.INPUT_TYPE.BYTE4, (Outputs)outputs).build();
            BytesRefBuilder scratch = new BytesRefBuilder();
            ByteArrayDataOutput scratchOutput = new ByteArrayDataOutput();
            IntHashSet dedupSet = this.dedup ? new IntHashSet() : null;
            byte[] spare = new byte[5];
            Set<CharsRef> keys = this.workingSet.keySet();
            CharsRef[] sortedKeys = keys.toArray(new CharsRef[keys.size()]);
            Arrays.sort(sortedKeys, CharsRef.getUTF16SortedAsUTF8Comparator());
            IntsRefBuilder scratchIntsRef = new IntsRefBuilder();
            for (int keyIdx = 0; keyIdx < sortedKeys.length; ++keyIdx) {
                CharsRef input = sortedKeys[keyIdx];
                MapEntry output = this.workingSet.get(input);
                int numEntries = output.ords.size();
                int estimatedSize = 5 + numEntries * 5;
                scratch.grow(estimatedSize);
                scratchOutput.reset(scratch.bytes());
                int count = 0;
                for (int i = 0; i < numEntries; ++i) {
                    if (dedupSet != null) {
                        int ent = output.ords.get(i);
                        if (dedupSet.contains(ent)) continue;
                        dedupSet.add(ent);
                    }
                    scratchOutput.writeVInt(output.ords.get(i));
                    ++count;
                }
                int pos = scratchOutput.getPosition();
                scratchOutput.writeVInt(count << 1 | (output.includeOrig ? 0 : 1));
                int pos2 = scratchOutput.getPosition();
                int vIntLen = pos2 - pos;
                System.arraycopy(scratch.bytes(), pos, spare, 0, vIntLen);
                System.arraycopy(scratch.bytes(), 0, scratch.bytes(), vIntLen, pos);
                System.arraycopy(spare, 0, scratch.bytes(), 0, vIntLen);
                if (dedupSet != null) {
                    dedupSet.clear();
                }
                scratch.setLength(scratchOutput.getPosition());
                fstCompiler.add(Util.toUTF32((CharSequence)input, (IntsRefBuilder)scratchIntsRef), (Object)scratch.toBytesRef());
            }
            FST fst = FST.fromFSTReader((FST.FSTMetadata)fstCompiler.compile(), (FSTReader)fstCompiler.getFSTReader());
            return new SynonymMap((FST<BytesRef>)fst, this.words, this.maxHorizontalContext);
        }

        private static class MapEntry {
            boolean includeOrig;
            IntArrayList ords = new IntArrayList();

            private MapEntry() {
            }
        }
    }
}

