/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProviderFactory;
import org.keycloak.services.clientpolicy.condition.AnyClientCondition;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;

public class AnyClientConditionFactory
extends AbstractClientPolicyConditionProviderFactory {
    public static final String PROVIDER_ID = "any-client";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public ClientPolicyConditionProvider create(KeycloakSession session) {
        return new AnyClientCondition(session);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "The condition is satisfied by any client on any event.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        AnyClientConditionFactory.addCommonConfigProperties(configProperties);
    }
}

