/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.holders;

import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;

public class IssuerInfoHolder {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private NameIDType issuer;
    private String statusCodeURI = JBossSAMLURIConstants.STATUS_SUCCESS.get();
    private String samlVersion = JBossSAMLConstants.VERSION_2_0.get();

    public IssuerInfoHolder(NameIDType issuer) {
        if (issuer == null) {
            throw logger.nullArgumentError("issuer");
        }
        this.issuer = issuer;
    }

    public IssuerInfoHolder(String issuerAsString) {
        if (issuerAsString == null) {
            throw logger.nullArgumentError("issuerAsString");
        }
        this.issuer = new NameIDType();
        this.issuer.setValue(issuerAsString);
    }

    public NameIDType getIssuer() {
        return this.issuer;
    }

    public void setIssuer(NameIDType issuer) {
        this.issuer = issuer;
    }

    public String getStatusCode() {
        return this.statusCodeURI;
    }

    public void setStatusCode(String statusCode) {
        this.statusCodeURI = statusCode;
    }

    public String getSamlVersion() {
        return this.samlVersion;
    }

    public void setSamlVersion(String samlVersion) {
        this.samlVersion = samlVersion;
    }
}

