/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.resource.Resource;
import io.smallrye.common.resource.ResourceLoader;
import io.smallrye.common.resource.ResourceUtils;
import io.smallrye.common.resource.URLResource;
import java.io.IOException;
import java.net.URL;

public final class URLResourceLoader
implements ResourceLoader {
    private final URL base;

    public URLResourceLoader(URL base) {
        this.base = (URL)Assert.checkNotNullParam((String)"base", (Object)base);
    }

    @Override
    public Resource findResource(String path) throws IOException {
        String canon = ResourceUtils.canonicalizeRelativePath(path);
        return new URLResource(canon, new URL(this.base, canon));
    }

    @Override
    public URL baseUrl() {
        return this.base;
    }
}

