/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Arrays;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.api.SymmetryInterface;
import org.jmol.script.SV;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.UnitCell;
import org.jmol.viewer.Viewer;

public final class CLEG {
    public static boolean allow300 = false;
    public static final String HEX_TO_RHOMB = "2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c";
    public static final String RHOMB_TO_HEX = "a-b,b-c,a+b+c";

    String transformSpaceGroup(Viewer vwr, BS bs, String cleg, Object paramsOrUC, SB sb) {
        AssignedSGParams asgParams;
        ClegData data;
        String ret;
        SymmetryInterface sym0 = vwr.getCurrentUnitCell();
        SymmetryInterface sym = vwr.getOperativeSymmetry();
        if (sym0 != null && sym != sym0) {
            sym.getUnitCell(sym0.getV0abc(null, null), false, "modelkit");
        }
        if (cleg == null) {
            return "!no CLEG id for this space group";
        }
        if (cleg.indexOf("<") >= 0) {
            cleg = PT.rep(cleg, "<<", ">super>").replace('<', '>');
        }
        if (cleg.length() == 0 || cleg.endsWith(">")) {
            cleg = cleg + ".";
        }
        if ((ret = CLEG.assignSpaceGroup(data = new ClegData(vwr.getSymTemp(), PT.split(cleg, ">")), asgParams = new AssignedSGParams(vwr, sym, bs, paramsOrUC, 0, false, sb, cleg.equals(".")))).endsWith("!")) {
            return ret;
        }
        if (asgParams.mkIsAssign) {
            sb.append(ret);
        }
        return ret;
    }

    private static String assignSpaceGroup(ClegData data, AssignedSGParams asgParams) {
        String calcNext;
        boolean isCalc;
        boolean nextTransformExplicit;
        boolean haveUCParams;
        boolean initializing;
        Viewer vwr = asgParams.vwr;
        int index = asgParams.mkIndex;
        String[] tokens = data.tokens;
        boolean bl = initializing = index < 0;
        if (initializing) {
            index = 0;
        }
        if (index >= tokens.length) {
            return "invalid CLEG expression!";
        }
        boolean bl2 = haveUCParams = asgParams.mkParamsOrUC != null;
        if (tokens.length > 1 && haveUCParams) {
            return "invalid syntax - can't mix transformations and UNITCELL option!";
        }
        if (index == 0 && !initializing) {
            CLEG.standardizeTokens(tokens, false);
        }
        boolean isFinal = index == tokens.length - 1;
        String token = tokens[index].trim();
        boolean isDot = token.equals(".");
        boolean bl3 = isFinal ? isDot : (nextTransformExplicit = CLEG.isTransformOnly(tokens[index + 1]) && tokens[index + 1].length() > 0);
        if (index == 0) {
            if (token.length() == 0 || isDot) {
                if (asgParams.mkSym00 == null) {
                    return "no starting space group for CLEG!";
                }
                if (!asgParams.mkIsAssign) {
                    tokens[0] = asgParams.mkSym00.getSpaceGroupClegId();
                    asgParams.mkIndex = isDot && isFinal ? 0 : 1;
                    asgParams.mkWasNode = asgParams.mkIndex == 1;
                    asgParams.mkIgnoreAllSettings = nextTransformExplicit;
                    return CLEG.assignSpaceGroup(data, asgParams);
                }
            }
            if (asgParams.mkIsAssign && asgParams.mkSym00 == null) {
                return "no starting space group for calculation!";
            }
        }
        if (((isCalc = CLEG.getCalcType(token) != null) || CLEG.isTransformOnly(token)) != asgParams.mkWasNode) {
            return "invalid CLEG expression, not node>transform>node>transform>....!";
        }
        asgParams.mkWasNode = !asgParams.mkWasNode;
        String string = calcNext = isCalc ? token : null;
        if (isCalc) {
            token = tokens[++index].trim();
            boolean bl4 = isFinal = index == tokens.length - 1;
        }
        if (isFinal && isDot && data.getPrevNode() != null) {
            token = data.getPrevNode().getCleanITAName();
        }
        int pt = token.lastIndexOf(":");
        boolean zapped = asgParams.mkSym00 == null;
        boolean isUnknown = false;
        boolean haveTransform = CLEG.isTransform(token, false);
        boolean isSetting = haveTransform && pt >= 0;
        boolean isTransformOnly = haveTransform && !isSetting;
        boolean restarted = false;
        boolean ignoreNodeTransform = false;
        boolean ignoreFirstSetting = false;
        SymmetryInterface sym = data.sym;
        ClegNode node = null;
        if (!isTransformOnly) {
            data.setSymmetry(sym);
            node = new ClegNode(data, index, token);
            if (data.errString != null) {
                return data.errString;
            }
        }
        if (data.getPrevNode() == null) {
            if (!CLEG.checkFullSyntax(tokens, sym, allow300)) {
                return "invalid CLEG expression!";
            }
            if (!asgParams.mkCalcOnly && !isTransformOnly && zapped && !node.isDefaultSetting()) {
                String ita = node.myIta;
                String[] cleg = new String[]{node.specialPrefix + ita};
                AssignedSGParams paramsInit = asgParams.mkCalcOnly ? new AssignedSGParams(vwr, false) : new AssignedSGParams(vwr, null, null, asgParams.mkParamsOrUC, -1, true, asgParams.mkSb, false);
                ClegData cdInit = new ClegData(vwr.getSymTemp(), cleg);
                String err = CLEG.assignSpaceGroup(cdInit, paramsInit);
                if (err.endsWith("!")) {
                    return err;
                }
                if (asgParams.mkCalcOnly) {
                    sym = asgParams.mkSym00 = cdInit.sym;
                    data.trMat = cdInit.trMat;
                } else {
                    asgParams.mkSym00 = vwr.getOperativeSymmetry();
                }
                if (asgParams.mkSym00 == null) {
                    return "CLEG spacegroup initialization error!";
                }
                zapped = false;
                restarted = true;
            }
            ignoreFirstSetting = index == 0 && (!asgParams.mkCalcOnly && !zapped && nextTransformExplicit || asgParams.mkIsAssign);
            String ita0 = zapped ? null : asgParams.mkSym00.getSpaceGroupClegId();
            String trm0 = null;
            if (!zapped && ita0 != null && !ita0.equals("0")) {
                int pt1 = ita0.indexOf(":");
                if (pt1 > 0) {
                    trm0 = ita0.substring(pt1 + 1);
                    ita0 = ita0.substring(0, pt1);
                    pt1 = -1;
                }
                if (ignoreFirstSetting) {
                    trm0 = (String)asgParams.mkSym00.getSpaceGroupInfoObj("itaTransform", null, false, false);
                }
            }
            if (data.trMat == null) {
                data.trMat = new M4();
                data.trMat.setIdentity();
            }
            if (!asgParams.mkIsAssign) {
                data.setSymmetry(sym);
                data.setPrevNode(new ClegNode(data, -1, ita0 == null ? null : ita0 + ":" + trm0));
                if (asgParams.mkIgnoreAllSettings) {
                    data.getPrevNode().disable();
                }
                if (!data.getPrevNode().update(data)) {
                    return data.errString;
                }
            }
        }
        if (isCalc && !data.getPrevNode().setCalcNext(data, calcNext)) {
            return data.errString;
        }
        if (isTransformOnly) {
            if (isFinal) {
                isUnknown = true;
            }
            if (token.length() > 0) {
                data.addTransform(index, token);
            }
            ++asgParams.mkIndex;
            if (!isUnknown) {
                return CLEG.assignSpaceGroup(data, asgParams);
            }
        }
        if (!ignoreFirstSetting) {
            data.setSymmetry(sym);
            if (ignoreNodeTransform) {
                node.disable();
            }
            if (!node.update(data)) {
                return data.errString;
            }
            if (isFinal && isDot) {
                data.setNodeTransform(node);
            }
            data.updateTokens(node);
        }
        if (!isFinal) {
            ++asgParams.mkIndex;
            data.setPrevNode(node);
            return CLEG.assignSpaceGroup(data, asgParams);
        }
        float[] params = null;
        T3[] oabc = null;
        T3 origin = null;
        float[] fArray = params = !haveUCParams || !AU.isAD(asgParams.mkParamsOrUC) ? null : (float[])asgParams.mkParamsOrUC;
        if (zapped) {
            float[] fArray2;
            if (params == null) {
                float[] fArray3 = new float[6];
                fArray3[0] = 10.0f;
                fArray3[1] = 10.0f;
                fArray3[2] = 10.0f;
                fArray3[3] = 90.0f;
                fArray3[4] = 90.0f;
                fArray2 = fArray3;
                fArray3[5] = 90.0f;
            } else {
                fArray2 = params;
            }
            sym.setUnitCellFromParams(fArray2, false, Float.NaN);
            asgParams.mkParamsOrUC = null;
            haveUCParams = false;
        }
        if (haveUCParams) {
            if (AU.isAD(asgParams.mkParamsOrUC)) {
                params = (float[])asgParams.mkParamsOrUC;
            } else {
                oabc = (T3[])asgParams.mkParamsOrUC;
                origin = oabc[0];
            }
        } else if (!zapped) {
            sym = asgParams.mkSym00;
            data.setSymmetry(sym);
            if (data.trMat == null) {
                data.trMat = new M4();
                data.trMat.setIdentity();
            }
            oabc = sym.getV0abc(new Object[]{data.trMat}, null);
            origin = oabc[0];
        }
        if (oabc != null) {
            params = sym.getUnitCell(oabc, false, "assign").getUnitCellParams();
            if (origin == null) {
                origin = oabc[0];
            }
        }
        boolean isP1 = token.equalsIgnoreCase("P1") || token.equals("ITA/1.1");
        try {
            Map sgInfo;
            boolean noAtoms;
            BS bsAtoms;
            int modelIndex = -1;
            if (asgParams.mkCalcOnly) {
                asgParams.mkBitset = bsAtoms = new BS();
                noAtoms = true;
            } else {
                BS bsCell;
                if (asgParams.mkBitset != null && asgParams.mkBitset.isEmpty()) {
                    return "no atoms specified!";
                }
                bsAtoms = vwr.getThisModelAtoms();
                BS bS = bsCell = isP1 ? bsAtoms : SV.getBitSet(vwr.evaluateExpressionAsVariable("{within(unitcell)}"), true);
                if (asgParams.mkBitset == null) {
                    asgParams.mkBitset = bsAtoms;
                }
                if (asgParams.mkBitset != null) {
                    bsAtoms.and(asgParams.mkBitset);
                    if (!isP1) {
                        bsAtoms.and(bsCell);
                    }
                }
                int n = (noAtoms = bsAtoms.isEmpty()) && vwr.am.cmi < 0 ? 0 : (modelIndex = noAtoms ? vwr.am.cmi : vwr.ms.at[bsAtoms.nextSetBit(0)].getModelIndex());
                if (!asgParams.mkIsAssign) {
                    vwr.ms.getModelAuxiliaryInfo(modelIndex).remove("spaceGroupInfo");
                }
            }
            if (!zapped && !asgParams.mkIsAssign) {
                sym.saveOrRetrieveTransformMatrix(data.trMat);
            }
            if (params == null) {
                params = sym.getUnitCellMultiplied().getUnitCellParams();
            }
            Map map = noAtoms && (isUnknown |= asgParams.mkIsAssign) ? null : (sgInfo = (Map)vwr.findSpaceGroup(sym, isUnknown ? bsAtoms : null, isUnknown ? null : node.getName(), params, origin, oabc, 2 | (asgParams.mkCalcOnly ? 16 : 0) | (!zapped || asgParams.mkIsAssign ? 0 : 4)));
            if (sgInfo == null) {
                return "Space group " + node.getName() + " is unknown or not compatible!";
            }
            if (oabc == null || zapped) {
                oabc = (P3[])sgInfo.get("unitcell");
            }
            token = (String)sgInfo.get("name");
            String jmolId = (String)sgInfo.get("jmolId");
            BS basis = (BS)sgInfo.get("basis");
            SpaceGroup sg = (SpaceGroup)sgInfo.remove("sg");
            sym.getUnitCell(oabc, false, null);
            sym.setSpaceGroupTo(sg == null ? jmolId : sg);
            sym.setSpaceGroupName(token);
            if (asgParams.mkCalcOnly) {
                data.setSymmetry(sym);
                return "OK";
            }
            if (basis == null) {
                basis = sym.removeDuplicates(vwr.ms, bsAtoms, true);
            }
            vwr.ms.setSpaceGroup(modelIndex, sym, basis);
            if (asgParams.mkIsAssign) {
                return token;
            }
            if (zapped || restarted) {
                vwr.runScript("unitcell on; center unitcell;axes unitcell; axes 0.1; axes on;set perspectivedepth false;moveto 0 axis c1;draw delete;show spacegroup");
            }
            String finalTransform = data.abcFor(data.trMat);
            tokens[index] = sg.getClegId();
            if (!initializing) {
                CLEG.standardizeTokens(tokens, true);
                String msg = PT.join(tokens, '>', 0) + (basis.isEmpty() ? "" : "\n basis=" + basis);
                System.out.println("CLEG=" + msg);
                asgParams.mkSb.append(msg).append("\n");
            }
            return finalTransform;
        }
        catch (Exception e) {
            if (!Viewer.isJS) {
                e.printStackTrace();
            }
            return e.getMessage() + "!";
        }
    }

    public static void standardizeTokens(String[] tokens, boolean isEnd) {
        int i = tokens.length;
        while (--i >= 0) {
            String t = tokens[i];
            if (t.length() == 0) continue;
            if ((t = CLEG.cleanCleg000(t)).endsWith(":h")) {
                if (!t.startsWith("R")) {
                    t = t.substring(0, t.length() - 2);
                }
            } else if (isEnd || !t.endsWith(":2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c")) {
                if (t.endsWith(":r")) {
                    if (!t.startsWith("R")) {
                        t = t.substring(0, t.length() - 1) + HEX_TO_RHOMB;
                    }
                } else if (t.equals("r")) {
                    t = HEX_TO_RHOMB;
                } else if (t.equals("h")) {
                    t = RHOMB_TO_HEX;
                }
            }
            tokens[i] = t;
        }
        System.out.println("MK StandardizeTokens " + Arrays.toString(tokens));
    }

    public static String cleanCleg000(String t) {
        return t.endsWith(";0,0,0") ? t.substring(0, t.length() - 6) : t;
    }

    public static int isProbableClegSetting(String name) {
        int p = name.indexOf(":");
        int type = SpaceGroup.getExplicitSpecialGroupType(name);
        return type >= 0 && p > 0 && SpaceGroup.getITNo(type == 0 ? name : name.substring(2), p) > 0 && name.indexOf(",") > p ? p : 0;
    }

    public static boolean checkFullSyntax(String[] tokens, SymmetryInterface sym, boolean allow300) {
        for (int i = 0; i < tokens.length; ++i) {
            String transform;
            float itno;
            boolean isHall;
            String s = tokens[i].trim();
            if (s == null || s.length() == 0 || s.startsWith("sub") || s.startsWith("super")) continue;
            int groupType = SpaceGroup.getExplicitSpecialGroupType(s);
            if (groupType > 0) {
                s = s.substring(2);
            }
            int ptColon = s.indexOf(":");
            int ptComma = s.indexOf(",", ptColon + 1);
            int ptDot = s.indexOf(".");
            boolean isQuest = s.indexOf("?:") == 0 || s.indexOf(".:") == 0 || s.indexOf("0:") == 0;
            boolean isClegSetting = ptColon > 0 && ptComma > ptColon;
            int ptHall = s.indexOf("]");
            boolean bl = isHall = ptHall > 0 && s.charAt(0) == '[' && (ptColon < 0 || ptColon == ptHall + 1);
            float f = isQuest ? 0.0f : (isHall ? 1.0f : (itno = PT.parseFloatStrict(ptColon > 0 ? s.substring(0, ptColon) : s)));
            if (Float.isNaN(itno) ? ptDot > 0 || isClegSetting : !isQuest && !SpaceGroup.isInRange(itno, groupType, !isClegSetting, allow300 && groupType == 0)) {
                return false;
            }
            if (ptComma < 0) continue;
            String string = transform = ptColon > 0 ? s.substring(ptColon + 1) : s;
            if (((M4)sym.convertTransform(transform, null)).determinant3() != 0.0f) continue;
            return false;
        }
        return true;
    }

    public static String getCalcType(String token) {
        return token.length() == 0 || token.equals("sub") ? "sub" : (token.charAt(0) != 's' ? null : (token.startsWith("sub(") ? "sub(" : (token.equals("super") ? "super" : (token.startsWith("super(") ? "super(" : null))));
    }

    public static boolean isTransformOnly(String token) {
        return CLEG.isTransform(token, false) && token.indexOf(":") < 0;
    }

    public static boolean isTransform(String token, boolean checkColonRH) {
        return token.length() == 0 || token.indexOf(44) > 0 || "!r!h".indexOf(token) >= 0 || checkColonRH && (token.endsWith(":r") || token.endsWith(":h"));
    }

    M4 getMatrixTransform(Viewer vwr, String cleg, Object retLstOrMap) {
        String[] tokens;
        if (cleg.length() == 0) {
            cleg = ".";
        }
        if (cleg.indexOf(">") < 0 && !cleg.equals(".")) {
            cleg = ">>" + cleg;
        }
        if ((tokens = PT.split(cleg, ">"))[0].length() == 0) {
            tokens[0] = "ref";
        }
        ClegData data = new ClegData(vwr.getSymTemp(), tokens);
        Map retMap = retLstOrMap instanceof Map ? (Map)retLstOrMap : null;
        Lst retLst = retMap == null && retLstOrMap instanceof Lst ? (Lst)retLstOrMap : null;
        data.setReturnMap(retMap);
        data.setReturnLst(retLst);
        String err = CLEG.assignSpaceGroup(data, new AssignedSGParams(vwr, cleg.equals(".")));
        if (err.indexOf("!") > 0) {
            System.err.println(err);
            if (retMap != null) {
                retMap.put("error", err);
            }
            return null;
        }
        if (retLst == null && retMap == null) {
            System.out.println("CLEG transform: " + PT.join(tokens, '>', 0));
            cleg = data.abcFor(data.trMat);
            System.out.println("CLEG transform: " + tokens[0] + ">" + cleg + ">" + tokens[tokens.length - 1]);
        }
        return data.trMat;
    }

    private static class AssignedSGParams {
        final Viewer vwr;
        final boolean mkCalcOnly;
        final boolean mkIsAssign;
        final SB mkSb;
        boolean mkIgnoreAllSettings;
        SymmetryInterface mkSym00;
        BS mkBitset;
        Object mkParamsOrUC;
        boolean mkWasNode;
        int mkIndex;

        AssignedSGParams(Viewer vwr, boolean isCurrentSG) {
            this.vwr = vwr;
            this.mkCalcOnly = true;
            this.mkIsAssign = false;
            this.mkSb = null;
            if (isCurrentSG) {
                this.mkSym00 = vwr.getOperativeSymmetry();
            }
        }

        AssignedSGParams(Viewer vwr, SymmetryInterface sym00, BS bs, Object paramsOrUC, int index, boolean ignoreAllSettings, SB sb, boolean isAssign) {
            this.vwr = vwr;
            this.mkCalcOnly = false;
            this.mkIndex = index;
            this.mkSym00 = sym00;
            this.mkBitset = bs;
            this.mkParamsOrUC = paramsOrUC;
            this.mkIgnoreAllSettings = ignoreAllSettings;
            this.mkSb = sb;
            this.mkIsAssign = isAssign;
        }
    }

    public static class ClegNode {
        public static final String TYPE_REFERENCE = "ref";
        public static final String CALC_SUB = "sub";
        public static final String CALC_SUBP = "sub(";
        public static final String CALC_SUPER = "super";
        public static final String CALC_SUPERP = "super(";
        public static final String CALC_SET = "set";
        String name;
        String myIta;
        String myTrm;
        int index;
        private String calcNext;
        private int calcI1;
        private int calcI2;
        private int calcDepthMin;
        private int calcDepthMax;
        private int calcIndexMin;
        private int calcIndexMax;
        String calculated;
        boolean disabled;
        private boolean isThisModelCalc;
        private String hallSymbol;
        private int specialType = 0;
        String specialPrefix = "";

        public ClegNode(ClegData data, int index, String name) {
            if (name == null) {
                return;
            }
            this.index = index;
            this.init(data, name);
        }

        public void disable() {
            this.disabled = true;
        }

        private String checkSpecial(String name) {
            this.specialType = SpaceGroup.getExplicitSpecialGroupType(name);
            switch (this.specialType) {
                case -1: {
                    return null;
                }
                case 0: {
                    if (!allow300) {
                        return name;
                    }
                    int ptDot = name.indexOf(".");
                    String sname = ptDot > 0 ? name.substring(0, ptDot) : name;
                    int itno = SpaceGroup.getITNo(sname, 0);
                    if (itno < 300) {
                        return name;
                    }
                    if (itno > 600) {
                        return null;
                    }
                    this.specialType = itno / 100 * 100;
                    this.specialPrefix = SpaceGroup.getGroupTypePrefix(itno);
                    return "" + (itno - this.specialType) + name.substring(sname.length());
                }
            }
            this.specialPrefix = name.substring(0, 2);
            return name.substring(2);
        }

        private void init(ClegData data, String name) {
            boolean isITAnDotm;
            boolean isPrimitive;
            int pt = CLEG.isProbableClegSetting(name);
            if (pt > 0) {
                this.myIta = name.substring(0, pt);
                this.myTrm = name.substring(pt + 1);
            }
            if (name.equals(TYPE_REFERENCE)) {
                this.isThisModelCalc = true;
            }
            if (isPrimitive = (name = this.checkSpecial(name)).endsWith(":p")) {
                name = name.substring(0, name.length() - 2);
            }
            if (isITAnDotm = name.startsWith("ITA/")) {
                name = this.checkSpecial(name.substring(4));
            }
            boolean isHM = false;
            this.hallSymbol = null;
            String hallTrm = null;
            if (this.specialType == 0 && name.charAt(0) == '[') {
                pt = name.indexOf(93);
                if (pt < 0) {
                    data.errString = "invalid Hall symbol: " + name + "!";
                    return;
                }
                this.hallSymbol = name.substring(1, pt);
                pt = this.hallSymbol.indexOf("(");
                if (pt > 0) {
                    hallTrm = this.hallSymbol.substring(pt + 1, this.hallSymbol.length() - 1) + " ";
                    this.hallSymbol = this.hallSymbol.substring(0, pt).trim();
                    hallTrm = PT.rep(hallTrm, " ", "/12,");
                    hallTrm = "a,b,c;" + hallTrm.substring(0, hallTrm.length() - 1);
                }
                if ((pt = name.indexOf(":")) > 0) {
                    this.myTrm = name.substring(pt + 1);
                }
                name = "Hall:" + this.hallSymbol;
            } else if (name.startsWith("HM:")) {
                isHM = true;
            } else if (name.length() <= 3) {
                boolean bl = isITAnDotm = SpaceGroup.getITNo(name, 0) > 0;
                if (isITAnDotm) {
                    name = this.checkSpecial(name) + ".1";
                }
            }
            if (!isITAnDotm && this.hallSymbol == null && !isHM) {
                int n = pt = PT.isDigit(name.charAt(0)) ? name.indexOf(" ") : -1;
                if (pt > 0) {
                    name = name.substring(0, pt);
                }
                if (name.indexOf(46) > 0 && !Float.isNaN(PT.parseFloat(name))) {
                    isITAnDotm = true;
                }
            }
            if (isITAnDotm) {
                String string = this.myTrm = name.endsWith(".1") ? "a,b,c" : (String)data.sym.getSpaceGroupInfoObj("itaTransform", this.specialPrefix + name, false, false);
                if (this.myTrm == null) {
                    data.errString = "Unknown ITA setting: " + this.specialPrefix + name + "!";
                    return;
                }
                String[] parts = PT.split(name, ".");
                this.myIta = parts[0];
            } else {
                if (this.myIta == null) {
                    this.myIta = (String)data.sym.getSpaceGroupInfoObj("itaNumber", this.specialPrefix + name, false, false);
                }
                if (this.myTrm == null) {
                    this.myTrm = (String)data.sym.getSpaceGroupInfoObj("itaTransform", this.specialPrefix + name, false, false);
                }
                if (this.hallSymbol != null && hallTrm != null) {
                    this.myTrm = hallTrm + (this.myTrm.equals("a,b,c") ? "" : ">" + this.myTrm);
                }
            }
            if ("0".equals(this.myIta)) {
                data.errString = "Could not get ITA space group for " + name + "!";
                return;
            }
            if (isPrimitive) {
                this.myTrm = data.addPrimitiveTransform(this.myIta, this.myTrm);
            }
            this.setITAName(name);
        }

        public String setITAName(String name) {
            this.name = (".".equals(name) || this.myIta == null ? "." : "ITA/" + this.specialPrefix + this.myIta) + (this.myTrm == null ? "" : ":" + this.myTrm);
            return this.name;
        }

        public boolean update(ClegData data) {
            boolean haveReferenceCell;
            if (data.errString != null) {
                return false;
            }
            if (this.name == null) {
                return true;
            }
            ClegNode prev = data.prevNode;
            if (prev.isThisModelCalc) {
                prev.myIta = this.myIta;
            }
            boolean bl = haveReferenceCell = data.trLink == null && this.myIta != null && (this.myIta.equals(prev.myIta) || prev.calcNext != null);
            if (!haveReferenceCell) {
                return true;
            }
            M4 trm0 = M4.newM4(data.trMat);
            data.removePrevNodeTrm();
            String trCalc = null;
            if (prev.calcNext != null) {
                boolean unspecifiedSettingChangeOnly;
                boolean isSub = true;
                boolean isImplicit = false;
                boolean isCalcFunction = false;
                switch (prev.calcNext) {
                    case "super(": 
                    case "sub(": {
                        isCalcFunction = true;
                        break;
                    }
                    case "super": {
                        isSub = false;
                        break;
                    }
                    case "sub": {
                        break;
                    }
                    case "": 
                    case "set": {
                        prev.calcNext = CALC_SET;
                        isImplicit = true;
                    }
                }
                int ita1 = PT.parseInt(prev.myIta);
                int ita2 = PT.parseInt(this.myIta);
                boolean bl2 = unspecifiedSettingChangeOnly = !isCalcFunction && data.retLst == null && (data.retMap == null || data.asM4) && isImplicit && ita1 == ita2;
                if (!unspecifiedSettingChangeOnly) {
                    boolean haveCalc;
                    int flags = prev.calcIndexMax << 24 | prev.calcIndexMin << 16 | prev.calcDepthMax << 8 | prev.calcDepthMin;
                    trCalc = (String)data.sym.getSubgroupJSON(isSub ? prev.name : this.name, isSub ? this.name : prev.name, prev.calcI1, prev.calcI2, flags, data.retMap, data.retLst);
                    boolean bl3 = haveCalc = trCalc != null;
                    if (haveCalc) {
                        if (trCalc.endsWith("!")) {
                            data.errString = trCalc;
                            return false;
                        }
                        if (!isSub) {
                            trCalc = "!" + trCalc;
                        }
                    }
                    String calc = prev.myIta + ">" + (haveCalc ? trCalc : "?") + ">" + this.myIta;
                    if (!haveCalc) {
                        data.errString = calc + "!";
                        return false;
                    }
                    data.addSGTransform(trCalc, CALC_SUB);
                }
            }
            if (!this.disabled) {
                data.addSGTransform(this.myTrm, "myTrm");
            }
            this.calculated = data.calculate(trm0);
            System.out.println("calculated is " + this.calculated + (data.retMap == null ? "" : " for the path " + data.retMap.get("indexPath")));
            return true;
        }

        public String getName() {
            return this.name;
        }

        public String getCleanITAName() {
            String s;
            if (this.name == null) {
                this.name = ".";
                return ".";
            }
            String string = s = this.name.startsWith("ITA/") ? this.name.substring(4) : this.name;
            if (this.specialType != 0 && !s.startsWith(this.specialPrefix)) {
                s = this.specialPrefix + s;
            }
            return s;
        }

        public boolean isDefaultSetting() {
            return this.myTrm == null || CLEG.cleanCleg000(this.myTrm).equals("a,b,c");
        }

        public boolean setCalcNext(ClegData data, String token) {
            int pt = token.length();
            switch (pt == 0 ? token : CLEG.getCalcType(token)) {
                case "sub": {
                    if (data.retLst != null || data.retMap != null) {
                        pt = 0;
                        break;
                    }
                }
                case "super": {
                    this.calcI1 = 1;
                    this.calcI2 = 1;
                    pt = 3;
                    break;
                }
                case "sub(": {
                    pt = -3;
                    break;
                }
                case "super(": {
                    pt = -5;
                }
            }
            boolean isErr = true;
            if (pt == 0) {
                this.calcIndexMin = 2;
                this.calcIndexMax = 255;
                this.calcDepthMin = 1;
                this.calcDepthMax = 255;
                isErr = false;
            } else if (pt > 0) {
                this.calcIndexMin = 2;
                this.calcIndexMax = 255;
                this.calcDepthMin = 1;
                this.calcDepthMax = 1;
                isErr = false;
            } else if (token.indexOf(")") == token.length() - 1) {
                String[] params = PT.split(PT.trim(token.toLowerCase().substring(-pt + 1), ")"), ",");
                try {
                    if (token.length() == 5 || token.indexOf(61) >= 0) {
                        this.calcIndexMin = 2;
                        this.calcIndexMax = 255;
                        this.calcDepthMin = 1;
                        this.calcDepthMax = 255;
                        token = token.substring(0, -pt);
                        int i = params.length;
                        while (--i >= 0) {
                            String p = params[i];
                            int val = Math.min(255, Integer.parseInt(p.substring(p.indexOf(61) + 1)));
                            if (p.startsWith("indexmax=")) {
                                this.calcIndexMax = Math.max(2, val);
                            } else if (p.startsWith("indexmin=")) {
                                this.calcIndexMin = Math.max(2, val);
                            } else if (p.startsWith("index=")) {
                                this.calcIndexMin = this.calcIndexMax = Math.max(2, val);
                            }
                            if (p.startsWith("depthmax=")) {
                                this.calcDepthMax = Math.max(1, val);
                                continue;
                            }
                            if (p.startsWith("depthmin=")) {
                                this.calcDepthMin = Math.max(1, val);
                                continue;
                            }
                            if (!p.startsWith("depth=")) continue;
                            this.calcDepthMin = this.calcDepthMax = Math.max(1, val);
                        }
                    } else {
                        switch (params.length) {
                            case 2: {
                                this.calcI2 = Math.max(0, Integer.parseInt(params[1])) & 0xFF;
                            }
                            case 1: {
                                this.calcI1 = Math.max(1, Integer.parseInt(params[0])) & 0xFF;
                            }
                        }
                    }
                    token = token.substring(0, -pt);
                    isErr = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isErr) {
                data.errString = "Error parsing CLEG " + token + "!";
                return false;
            }
            this.calcNext = token;
            return true;
        }

        public String toString() {
            return "[ClegNode #" + this.index + " " + this.name + "   " + this.myIta + ":" + this.myTrm + (this.disabled ? " disabled" : "") + "]";
        }
    }

    public static class ClegData {
        public final String[] tokens;
        public Symmetry sym;
        public M4 trMat;
        public String errString;
        M4 trLink;
        private M4 trTemp = new M4();
        ClegNode prevNode;
        Map<String, Object> retMap;
        Lst<Object> retLst;
        boolean asM4;

        public ClegData(SymmetryInterface sym, String[] tokens) {
            this.tokens = tokens;
            this.sym = (Symmetry)sym;
        }

        public void setSymmetry(SymmetryInterface sym) {
            this.sym = (Symmetry)sym;
        }

        public M4 addSGTransform(String tr, String what) {
            if (this.trMat == null) {
                System.out.println("ClegData reset");
                this.trMat = new M4();
                this.trMat.setIdentity();
            }
            if (tr != null) {
                this.trMat.mul(this.matFor(tr));
            }
            if (what != null) {
                System.out.println("ClegData adding " + what + " " + tr + " now " + this.abcFor(this.trMat));
            }
            return this.trMat;
        }

        public String abcFor(M4 trm) {
            return this.sym.staticGetTransformABC(trm, false);
        }

        public M4 matFor(String trm) {
            return (M4)this.sym.convertTransform(trm, trm.indexOf(">") > 0 ? null : this.trTemp);
        }

        public void removePrevNodeTrm() {
            if (this.prevNode != null && this.prevNode.myTrm != null && !this.prevNode.disabled) {
                this.addSGTransform("!" + this.prevNode.myTrm, "!prevNode.myTrm");
            }
        }

        public String calculate(M4 trm0) {
            trm0.invert();
            M4 trm1 = M4.newM4(this.trMat);
            trm1.mul(trm0);
            return (String)this.sym.convertTransform(null, trm1);
        }

        public void updateTokens(ClegNode node) {
            int index = node.index;
            String s = node.name;
            s = s.startsWith("ITA/") ? s.substring(4) : (node.myIta == null ? "." : node.myIta) + ":" + node.myTrm;
            this.setToken(index, s);
            if (node.calculated != null && index > 0) {
                this.setToken(index - 1, node.calculated);
            }
        }

        private void setToken(int index, String s) {
            this.tokens[index] = s;
        }

        public void addTransformLink() {
            if (this.trLink == null) {
                this.trLink = new M4();
                this.trLink.setIdentity();
            }
            this.trLink.mul(this.trTemp);
        }

        public void setNodeTransform(ClegNode node) {
            node.myTrm = this.abcFor(this.trMat);
            node.setITAName(node.name);
        }

        public void addTransform(int index, String transform) {
            this.addSGTransform(transform, ">t>");
            this.addTransformLink();
            System.out.println("CLEG.addTransform index=" + index + " trm=" + this.trMat);
        }

        public ClegNode getPrevNode() {
            return this.prevNode;
        }

        public ClegNode setPrevNode(ClegNode node) {
            this.prevNode = node;
            return this.prevNode;
        }

        public String addPrimitiveTransform(String myIta, String myTrm) {
            String hmName = (String)this.sym.getSpaceGroupInfoObj("hmName", myIta + ":" + myTrm, false, false);
            if (hmName == null) {
                return myTrm;
            }
            char c = hmName.charAt(0);
            if ("ABCFI".indexOf(c) < 0) {
                return myTrm;
            }
            M4 t = M4.newMV(UnitCell.getPrimitiveTransform(c), P3.new3(0.0f, 0.0f, 0.0f));
            t.mul(this.matFor(myTrm));
            return this.abcFor(t);
        }

        public void setReturnMap(Map<String, Object> ret) {
            if (ret != null) {
                this.asM4 = ret.get("ASM4") == Boolean.TRUE;
                ret.clear();
            }
            this.retMap = ret;
        }

        public void setReturnLst(Lst<Object> ret) {
            if (ret != null) {
                ret.clear();
            }
            this.retLst = ret;
        }
    }
}

