/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import jetbrains.coverage.report.ClassInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleInfo {
    private final String myName;

    public ModuleInfo(String name) {
        this.myName = name;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public boolean isEmpty() {
        return this.myName == null || this.myName.length() == 0;
    }

    public boolean isNullModule() {
        return this.myName == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleInfo that = (ModuleInfo)o;
        return !(this.myName == null ? that.myName != null : !this.myName.equals(that.myName));
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    public String toString() {
        return "ModuleInfo{myName='" + this.myName + '\'' + '}';
    }

    @NotNull
    public static ModuleInfo fromClassInfo(@NotNull ClassInfo ci) {
        return new ModuleInfo(ci.getModule());
    }

    public static ModuleInfo newEmpty() {
        return new ModuleInfo(null);
    }

    @NotNull
    public String getPathNamePrefix() {
        return this.myName == null ? "" : this.myName;
    }
}

