/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.pattern;

import com.intellij.codeInsight.intention.AddAnnotationModCommandAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import java.util.Objects;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;

public class PatternOverriddenByNonAnnotatedMethod
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PatternOverriddenByNonAnnotatedMethod.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){
            final Pair<String, ? extends Set<String>> annotationName;
            {
                this.annotationName = Configuration.getProjectInstance((Project)holder.getProject()).getAdvancedConfiguration().getPatternAnnotationPair();
            }

            public void visitMethod(@NotNull PsiMethod method) {
                PsiAnnotation[] annotationFromHierarchy;
                PsiIdentifier psiIdentifier;
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((psiIdentifier = method.getNameIdentifier()) == null || !PsiUtilEx.isLanguageAnnotationTarget((PsiModifierListOwner)method)) {
                    return;
                }
                PsiAnnotation[] annotationFrom = AnnotationUtilEx.getAnnotationFrom((PsiModifierListOwner)method, this.annotationName, true, false);
                if (annotationFrom.length == 0 && (annotationFromHierarchy = AnnotationUtilEx.getAnnotationFrom((PsiModifierListOwner)method, this.annotationName, true, true)).length > 0) {
                    PsiAnnotation annotation = annotationFromHierarchy[annotationFromHierarchy.length - 1];
                    String annotationClassname = annotation.getQualifiedName();
                    PsiNameValuePair[] argList = annotation.getParameterList().getAttributes();
                    holder.problem((PsiElement)psiIdentifier, IntelliLangBundle.message((String)"inspection.pattern.overridden.by.non.annotated.method.description", (Object[])new Object[0])).fix((ModCommandAction)new AddAnnotationModCommandAction(Objects.requireNonNull(annotationClassname), (PsiModifierListOwner)method, argList, new String[0])).register();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/intellij/plugins/intelliLang/pattern/PatternOverriddenByNonAnnotatedMethod$1", "visitMethod"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/intelliLang/pattern/PatternOverriddenByNonAnnotatedMethod", "buildVisitor"));
    }
}

