#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-iadd
version:              1.3.22
visibility:           public
id:                   hledger-iadd-1.3.22-4fe32noxb7AJ9gnPcCBdCE
key:                  hledger-iadd-1.3.22-4fe32noxb7AJ9gnPcCBdCE
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  1d02f7009af5cf6f3b99ddcb8247b7f2
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-iadd-1.3.22
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-iadd-1.3.22
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-iadd-1.3.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.22-4fe32noxb7AJ9gnPcCBdCE
depends:
    base-4.18.2.1 brick-2.5-E9WJJEpGT4U4snfAVS8gtj containers-0.6.7
    directory-1.3.8.5 free-5.2-EBunlMu5kTDAA7fY5q6wdt
    hledger-lib-1.50.2-4ekRkFuTMHa3jBreHk6XTU
    megaparsec-9.7.0-I0qZdfD2x7QA5TPaNUjmTK
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-mtl-0.2.1.0-Ewo8HmKpWhTASatFX3KZGS
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw
    optparse-applicative-0.18.1.0-3S7fKkQk1IxEovxwORLzkN text-2.0.2
    text-zipper-0.13-A8svStPSesC1Y64LYH7qre time-1.12.2
    transformers-0.6.1.0
    unordered-containers-0.2.20.1-8SON4238u8N3rDHPceHjHx
    vector-0.13.2.0-JoP5POFPMLsLn1of7TvjGI
    vty-6.2-INuzoHGEuLa5SMM40Z8Lln
    xdg-basedir-0.2.2-DLaKUfv1JJAFBfkP0BUklH

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

