# :nodoc:
class Thread::WaitGroup
  def initialize(@count : Int32)
    @mutex = Thread::Mutex.new
    @condition = Thread::ConditionVariable.new
  end

  def done : Nil
    @mutex.synchronize do
      @count -= 1
      @condition.broadcast if @count == 0
    end
  end

  def wait : Nil
    @mutex.synchronize do
      @condition.wait(@mutex) unless @count == 0
    end
  end

  def wait(time : Time::Span, &) : Nil
    @mutex.synchronize do
      unless @count == 0
        @condition.wait(@mutex, time) { yield }
      end
    end
  end
end
