/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenamePyFileProcessor
extends RenamePsiFileProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof PyFile;
    }

    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor2) {
        PyFile file;
        if (element == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(1);
        }
        if ((file = (PyFile)element).getName().equals("__init__.py") && editor2 != null) {
            return file.getParent();
        }
        return element;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(3);
        }
        ArrayList<PsiReference> results = new ArrayList<PsiReference>();
        for (PsiReference reference : super.findReferences(element, searchScope, searchInCommentsAndStrings)) {
            if (!RenamePyFileProcessor.isNotAliasedInImportElement(reference)) continue;
            results.add(reference);
        }
        ArrayList<PsiReference> arrayList = results;
        if (arrayList == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        String newFileName;
        if (element == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(6);
        }
        if (allRenames == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(8);
        }
        if (!PyNames.isIdentifier(newFileName = FileUtilRt.getNameWithoutExtension((String)newName))) {
            ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>(result2);
            for (UsageInfo usageInfo : usages) {
                final PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)usageInfo.getElement(), PyImportStatementBase.class);
                if (importStatement == null) continue;
                result2.add((UsageInfo)new UnresolvableCollisionUsageInfo((PsiElement)importStatement, element){

                    public String getDescription() {
                        return PyBundle.message("refactoring.rename.not.valid.identifier", newFileName, importStatement.getContainingFile().getName());
                    }
                });
            }
        }
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        PsiElement stubElement;
        PsiFile file;
        if (element == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(9);
        }
        if (newName == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(10);
        }
        if (allRenames == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(11);
        }
        if ((file = (PsiFile)element) instanceof PyiFile) {
            PsiElement originalElement = PyiUtil.getOriginalElement((PyiFile)file);
            if (originalElement != null) {
                allRenames.put(originalElement, newName.substring(0, newName.length() - 1));
            }
        } else if (file instanceof PyFile && (stubElement = PyiUtil.getPythonStub((PyFile)file)) != null) {
            allRenames.put(stubElement, newName + "i");
        }
        super.prepareRenaming(element, newName, allRenames);
    }

    private static boolean isNotAliasedInImportElement(@NotNull PsiReference reference) {
        if (reference == null) {
            RenamePyFileProcessor.$$$reportNull$$$0(12);
        }
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                PsiElement resolved = result2.getElement();
                if (!(resolved instanceof PyImportElement) || ((PyImportElement)resolved).getAsName() == null) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public String getHelpID(PsiElement element) {
        return "procedures.refactoring.renameRefactorings";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/rename/RenamePyFileProcessor";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/rename/RenamePyFileProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCollisions";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNotAliasedInImportElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

