/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.RootFileReferenceSet;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringLiteralFileReferenceSet
extends RootFileReferenceSet {
    public static final Pattern DELIMITERS = Pattern.compile("\\\\|/");
    private final PyStringLiteralExpression myStringLiteralExpression;

    public PyStringLiteralFileReferenceSet(@NotNull PyStringLiteralExpression element) {
        if (element == null) {
            PyStringLiteralFileReferenceSet.$$$reportNull$$$0(0);
        }
        this(element, element.getContainingFile().getViewProvider().getVirtualFile().isCaseSensitive());
    }

    public PyStringLiteralFileReferenceSet(@NotNull PyStringLiteralExpression element, boolean caseSensitive) {
        if (element == null) {
            PyStringLiteralFileReferenceSet.$$$reportNull$$$0(1);
        }
        this(element.getStringValue(), element, element.getStringValueTextRange().getStartOffset(), (PsiReferenceProvider)null, caseSensitive, true, FileType.EMPTY_ARRAY);
    }

    public PyStringLiteralFileReferenceSet(@NotNull String str, @NotNull PyStringLiteralExpression element, int startInElement, PsiReferenceProvider provider, boolean caseSensitive, boolean endingSlashNotAllowed, FileType @Nullable [] suitableFileTypes) {
        if (str == null) {
            PyStringLiteralFileReferenceSet.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PyStringLiteralFileReferenceSet.$$$reportNull$$$0(3);
        }
        super(str, element, startInElement, provider, caseSensitive, endingSlashNotAllowed, suitableFileTypes);
        this.myStringLiteralExpression = element;
        this.reparse();
    }

    protected void reparse() {
        if (this.myStringLiteralExpression != null) {
            List<FileReference> references2 = this.getFileReferences(this.myStringLiteralExpression);
            this.myReferences = references2.toArray(FileReference.EMPTY);
        }
    }

    @NotNull
    private List<FileReference> getFileReferences(@NotNull PyStringLiteralExpression expression) {
        TextRange range;
        String s;
        if (expression == null) {
            PyStringLiteralFileReferenceSet.$$$reportNull$$$0(4);
        }
        String value = expression.getStringValue();
        Matcher matcher = DELIMITERS.matcher(value);
        int start = 0;
        int index = 0;
        ArrayList<FileReference> results = new ArrayList<FileReference>();
        while (matcher.find()) {
            s = value.substring(start, matcher.start());
            if (!s.isEmpty()) {
                range = TextRange.create((int)expression.valueOffsetToTextOffset(start), (int)expression.valueOffsetToTextOffset(matcher.start()));
                results.add(this.createFileReference(range, index++, s));
            }
            start = matcher.end();
        }
        s = value.substring(start);
        if (!s.isEmpty()) {
            range = TextRange.create((int)expression.valueOffsetToTextOffset(start), (int)expression.valueOffsetToTextOffset(value.length()));
            results.add(this.createFileReference(range, index, s));
        }
        ArrayList<FileReference> arrayList = results;
        if (arrayList == null) {
            PyStringLiteralFileReferenceSet.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyStringLiteralFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyStringLiteralFileReferenceSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileReferences";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

