/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.internal.AbstractCollectionSerializer;
import kotlinx.serialization.internal.ElementMarker;
import kotlinx.serialization.internal.MapLikeSerializer;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoBuf;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.internal.HelpersKt;
import kotlinx.serialization.protobuf.internal.MapEntryReader;
import kotlinx.serialization.protobuf.internal.OneOfPolymorphicReader;
import kotlinx.serialization.protobuf.internal.PackedArrayDecoder;
import kotlinx.serialization.protobuf.internal.ProtoWireType;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingException;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingKt;
import kotlinx.serialization.protobuf.internal.ProtobufReader;
import kotlinx.serialization.protobuf.internal.ProtobufTaggedDecoder;
import kotlinx.serialization.protobuf.internal.RepeatedDecoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J(\u0010\u001c\u001a\u00020\u0019*\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012H\u0002J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0012H\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0012H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010)\u001a\u00020\u00152\n\u0010*\u001a\u00060+j\u0002`,H\u0014J\u0014\u0010-\u001a\u00020.2\n\u0010*\u001a\u00060+j\u0002`,H\u0014J\u0014\u0010/\u001a\u0002002\n\u0010*\u001a\u00060+j\u0002`,H\u0014J\u0014\u00101\u001a\u00020\u00122\n\u0010*\u001a\u00060+j\u0002`,H\u0014J\u0014\u00102\u001a\u00020+2\n\u0010*\u001a\u00060+j\u0002`,H\u0014J\u0014\u00103\u001a\u0002042\n\u0010*\u001a\u00060+j\u0002`,H\u0014J\u0014\u00105\u001a\u0002062\n\u0010*\u001a\u00060+j\u0002`,H\u0014J\u0014\u00107\u001a\u0002082\n\u0010*\u001a\u00060+j\u0002`,H\u0014J\u0014\u00109\u001a\u00020:2\n\u0010*\u001a\u00060+j\u0002`,H\u0014J\u001c\u0010;\u001a\u00020\u00122\n\u0010*\u001a\u00060+j\u0002`,2\u0006\u0010<\u001a\u00020\u0007H\u0014J!\u0010=\u001a\u0002H>\"\u0004\b\u0000\u0010>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0@H\u0016\u00a2\u0006\u0002\u0010AJ+\u0010=\u001a\u0002H>\"\u0004\b\u0000\u0010>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0@2\b\u0010B\u001a\u0004\u0018\u0001H>H\u0014\u00a2\u0006\u0002\u0010CJ\u0012\u0010D\u001a\u00020E2\b\u0010B\u001a\u0004\u0018\u00010EH\u0002J+\u0010F\u001a\u0002H>\"\u0004\b\u0000\u0010>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0@2\b\u0010B\u001a\u0004\u0018\u0001H>H\u0002\u00a2\u0006\u0002\u0010CJ\u0018\u0010G\u001a\u00060+j\u0002`,*\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0012H\u0014J\u0010\u0010H\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010I\u001a\u00020\u0015H\u0016J\u0018\u0010J\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0012H\u0002JG\u0010K\u001a\u0002H>\"\u0004\b\u0000\u0010>2\n\u0010*\u001a\u00060+j\u0002`,2%\u0010L\u001a!\u0012\u0017\u0012\u00150+j\u0002`,\u00a2\u0006\f\bN\u0012\b\bO\u0012\u0004\b\b(*\u0012\u0004\u0012\u0002H>0MH\u0082\b\u00a2\u0006\u0002\u0010PJ\u001d\u0010Q\u001a\u00020R2\n\u0010*\u001a\u00060+j\u0002`,2\u0006\u0010S\u001a\u00020TH\u0082\bR\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufDecoder;", "Lkotlinx/serialization/protobuf/internal/ProtobufTaggedDecoder;", "proto", "Lkotlinx/serialization/protobuf/ProtoBuf;", "reader", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "<init>", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufReader;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "indexCache", "", "sparseIndexCache", "", "", "index2IdMap", "nullValue", "", "elementMarker", "Lkotlinx/serialization/internal/ElementMarker;", "populateCache", "", "populateCacheMap", "elements", "putProtoId", "protoId", "index", "getIndexByNum", "protoNum", "getIndexByNumSlowPath", "protoTag", "findIndexByTag", "findIndexByTagSlowPath", "desc", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "endStructure", "decodeTaggedBoolean", "tag", "", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "decodeTaggedByte", "", "decodeTaggedShort", "", "decodeTaggedInt", "decodeTaggedLong", "decodeTaggedFloat", "", "decodeTaggedDouble", "", "decodeTaggedChar", "", "decodeTaggedString", "", "decodeTaggedEnum", "enumDescription", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "previousValue", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "deserializeByteArray", "", "deserializeMap", "getTag", "decodeElementIndex", "decodeNotNullMark", "readIfAbsent", "decodeOrThrow", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "(JLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "rethrowException", "", "e", "Lkotlinx/serialization/protobuf/internal/ProtobufDecodingException;", "kotlinx-serialization-protobuf"})
@SourceDebugExtension(value={"SMAP\nProtobufDecoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufDecoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufDecoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,551:1\n360#1,10:567\n360#1,10:578\n360#1,10:589\n360#1,10:600\n360#1,10:611\n360#1,10:626\n369#1:643\n1563#2:552\n1634#2,2:553\n1636#2:556\n1869#2,2:557\n1222#2,2:637\n1252#2,4:639\n61#3:555\n54#3,5:560\n61#3:565\n61#3:566\n61#3:577\n61#3:588\n61#3:599\n61#3:610\n61#3:621\n61#3:622\n61#3:623\n61#3:624\n61#3:625\n61#3:636\n61#3:644\n61#3:645\n1#4:559\n*S KotlinDebug\n*F\n+ 1 ProtobufDecoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufDecoder\n*L\n191#1:567,10\n200#1:578,10\n210#1:589,10\n219#1:600,10\n230#1:611,10\n283#1:626,10\n363#1:643\n78#1:552\n78#1:553,2\n78#1:556\n79#1:557,2\n301#1:637,2\n301#1:639,4\n78#1:555\n137#1:560,5\n157#1:565\n174#1:566\n191#1:577\n200#1:588\n210#1:599\n219#1:610\n230#1:621\n264#1:622\n267#1:623\n268#1:624\n272#1:625\n283#1:636\n363#1:644\n369#1:645\n*E\n"})
public class ProtobufDecoder
extends ProtobufTaggedDecoder {
    @JvmField
    @NotNull
    protected final ProtoBuf proto;
    @JvmField
    @NotNull
    protected final ProtobufReader reader;
    @JvmField
    @NotNull
    protected final SerialDescriptor descriptor;
    @Nullable
    private int[] indexCache;
    @Nullable
    private Map<Integer, Integer> sparseIndexCache;
    @Nullable
    private Map<Integer, Integer> index2IdMap;
    private boolean nullValue;
    @NotNull
    private final ElementMarker elementMarker;

    public ProtobufDecoder(@NotNull ProtoBuf proto, @NotNull ProtobufReader reader, @NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.proto = proto;
        this.reader = reader;
        this.descriptor = descriptor2;
        this.elementMarker = new ElementMarker(this.descriptor, (Function2<? super SerialDescriptor, ? super Integer, Boolean>)new Function2<SerialDescriptor, Integer, Boolean>((Object)this){

            public final Boolean invoke(SerialDescriptor p0, int p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ProtobufDecoder.access$readIfAbsent((ProtobufDecoder)this.receiver, p0, p1);
            }
        });
        this.populateCache(this.descriptor);
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.proto.getSerializersModule();
    }

    public final void populateCache(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        int elements = descriptor2.getElementsCount();
        if (elements < 32) {
            int n = 0;
            int n2 = elements + 1;
            int[] nArray = new int[n2];
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = -1;
            }
            int[] cache2 = nArray;
            int i = 0;
            while (i < elements) {
                int protoId = HelpersKt.extractProtoId(descriptor2, i, false);
                if (protoId > elements || protoId == -2) {
                    this.populateCacheMap(descriptor2, elements);
                    return;
                }
                cache2[protoId] = i++;
            }
            this.indexCache = cache2;
        } else {
            this.populateCacheMap(descriptor2, elements);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void populateCacheMap(SerialDescriptor descriptor2, int elements) {
        HashMap map2 = new HashMap(elements, 1.0f);
        int oneOfCount = 0;
        for (int i = 0; i < elements; ++i) {
            int id = HelpersKt.extractProtoId(descriptor2, i, false);
            if (id == -2) {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = HelpersKt.getAllOneOfSerializerOfField(descriptor2.getElementDescriptor(i), this.getSerializersModule());
                boolean $i$f$map = false;
                Iterator iterator2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SerialDescriptor serialDescriptor = (SerialDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    long $this$protoId$iv = HelpersKt.extractParameters((SerialDescriptor)it, 0);
                    boolean $i$f$getProtoId = false;
                    collection.add((int)($this$protoId$iv & Integer.MAX_VALUE));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    this.putProtoId(map2, it, i);
                }
                ++oneOfCount;
                continue;
            }
            this.putProtoId(map2, HelpersKt.extractProtoId(descriptor2, i, false), i);
        }
        if (oneOfCount > 0) {
            this.index2IdMap = new HashMap(oneOfCount, 1.0f);
        }
        this.sparseIndexCache = map2;
    }

    private final void putProtoId(Map<Integer, Integer> $this$putProtoId, int protoId, int index) {
        $this$putProtoId.put(protoId, index);
    }

    private final int getIndexByNum(int protoNum) {
        int[] array = this.indexCache;
        if (array != null) {
            int n;
            int[] nArray = array;
            boolean bl = 0 <= protoNum ? protoNum < nArray.length : false;
            if (bl) {
                n = nArray[protoNum];
            } else {
                int it = protoNum;
                boolean bl2 = false;
                n = -1;
            }
            return n;
        }
        return this.getIndexByNumSlowPath(protoNum);
    }

    private final int getIndexByNumSlowPath(int protoTag) {
        Map<Integer, Integer> map2 = this.sparseIndexCache;
        Intrinsics.checkNotNull(map2);
        Map<Integer, Integer> map3 = map2;
        Integer n = map3.get(protoTag);
        if (n == null) {
            boolean bl = false;
            n = -1;
        }
        return ((Number)n).intValue();
    }

    private final int findIndexByTag(SerialDescriptor descriptor2, int protoTag) {
        int protoId;
        if (protoTag < descriptor2.getElementsCount() && protoTag >= 0 && (protoId = HelpersKt.extractProtoId(descriptor2, protoTag, true)) == protoTag) {
            return protoTag;
        }
        return this.findIndexByTagSlowPath(descriptor2, protoTag);
    }

    private final int findIndexByTagSlowPath(SerialDescriptor desc, int protoTag) {
        int n = desc.getElementsCount();
        for (int i = 0; i < n; ++i) {
            int protoId = HelpersKt.extractProtoId(desc, i, true);
            if (protoId != protoTag) continue;
            return i;
        }
        throw new ProtobufDecodingException(protoTag + " is not among valid " + this.descriptor.getSerialName() + " enum proto numbers", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Object object;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        try {
            object = descriptor2.getKind();
            if (Intrinsics.areEqual(object, StructureKind.LIST.INSTANCE)) {
                CompositeDecoder compositeDecoder;
                long tag = this.getCurrentTagOrDefault();
                if (Intrinsics.areEqual(this.descriptor.getKind(), StructureKind.LIST.INSTANCE) && tag != 19500L && !Intrinsics.areEqual(this.descriptor, descriptor2)) {
                    void protoId$iv;
                    ProtobufReader reader = ProtobufDecodingKt.access$makeDelimited(this.reader, tag);
                    reader.readTag();
                    boolean bl = true;
                    ProtoIntegerType type$iv = ProtoIntegerType.DEFAULT;
                    boolean packed$iv = false;
                    boolean oneOf$iv = false;
                    boolean $i$f$ProtoDesc = false;
                    long packedBits$iv = 0L;
                    long oneOfBits$iv = 0L;
                    compositeDecoder = new RepeatedDecoder(this.proto, reader, packedBits$iv | oneOfBits$iv | type$iv.getSignature$kotlinx_serialization_protobuf() | (long)protoId$iv, descriptor2);
                } else if (this.reader.currentType == ProtoWireType.SIZE_DELIMITED && HelpersKt.isPackable(descriptor2.getElementDescriptor(0))) {
                    ProtobufReader sliceReader = new ProtobufReader(this.reader.objectInput());
                    compositeDecoder = new PackedArrayDecoder(this.proto, sliceReader, descriptor2);
                } else {
                    compositeDecoder = new RepeatedDecoder(this.proto, this.reader, tag, descriptor2);
                }
                return compositeDecoder;
            }
            if (Intrinsics.areEqual(object, StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual(object, StructureKind.OBJECT.INSTANCE) || object instanceof PolymorphicKind) {
                long tag = this.getCurrentTagOrDefault();
                if (tag == 19500L && Intrinsics.areEqual(this.descriptor, descriptor2)) {
                    return this;
                }
                if (HelpersKt.isOneOf(tag)) {
                    long l;
                    long $this$protoId$iv = tag;
                    boolean $i$f$getProtoId = false;
                    int rawIndex = (int)($this$protoId$iv & Integer.MAX_VALUE) - 1;
                    Map<Integer, Integer> map2 = this.index2IdMap;
                    if (map2 != null && (map2 = map2.get(rawIndex)) != null) {
                        int it = ((Number)((Object)map2)).intValue();
                        boolean bl = false;
                        l = HelpersKt.overrideId(tag, it);
                    } else {
                        l = tag;
                    }
                    long restoredTag = l;
                    return new OneOfPolymorphicReader(this.proto, this.reader, restoredTag, descriptor2);
                }
                return new ProtobufDecoder(this.proto, ProtobufDecodingKt.access$makeDelimited(this.reader, tag), descriptor2);
            }
            if (!Intrinsics.areEqual(object, StructureKind.MAP.INSTANCE)) {
                throw new SerializationException("Primitives are not supported at top-level");
            }
            object = new MapEntryReader(this.proto, ProtobufDecodingKt.access$makeDelimitedForced(this.reader, this.getCurrentTagOrDefault()), this.getCurrentTagOrDefault(), descriptor2);
        }
        catch (ProtobufDecodingException e) {
            long $this$protoId$iv = this.getCurrentTagOrDefault();
            boolean $i$f$getProtoId = false;
            throw new ProtobufDecodingException("Fail to begin structure for " + descriptor2.getSerialName() + " in " + this.descriptor.getSerialName() + " at proto number " + (int)($this$protoId$iv & Integer.MAX_VALUE), e);
        }
        return object;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
    }

    @Override
    protected boolean decodeTaggedBoolean(long tag) {
        boolean bl;
        int value = this.decodeTaggedInt(tag);
        switch (value) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            default: {
                throw new SerializationException("Unexpected boolean value: " + value);
            }
        }
        return bl;
    }

    @Override
    protected byte decodeTaggedByte(long tag) {
        return (byte)this.decodeTaggedInt(tag);
    }

    @Override
    protected short decodeTaggedShort(long tag) {
        return (short)this.decodeTaggedInt(tag);
    }

    @Override
    protected int decodeTaggedInt(long tag) {
        int n;
        ProtobufDecoder this_$iv = this;
        boolean $i$f$decodeOrThrow = false;
        try {
            long it = tag;
            boolean bl = false;
            n = tag == 19500L ? this.reader.readInt32NoTag() : this.reader.readInt(HelpersKt.getIntegerType(tag));
        }
        catch (ProtobufDecodingException e$iv) {
            ProtobufDecoder this_$iv$iv = this_$iv;
            boolean $i$f$rethrowException = false;
            long $this$protoId$iv$iv$iv = tag;
            boolean $i$f$getProtoId = false;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)($this$protoId$iv$iv$iv & Integer.MAX_VALUE) + " of " + this_$iv$iv.descriptor.getSerialName(), e$iv);
        }
        return n;
    }

    @Override
    protected long decodeTaggedLong(long tag) {
        long l;
        ProtobufDecoder this_$iv = this;
        boolean $i$f$decodeOrThrow = false;
        try {
            long it = tag;
            boolean bl = false;
            l = tag == 19500L ? this.reader.readLongNoTag() : this.reader.readLong(HelpersKt.getIntegerType(tag));
        }
        catch (ProtobufDecodingException e$iv) {
            ProtobufDecoder this_$iv$iv = this_$iv;
            boolean $i$f$rethrowException = false;
            long $this$protoId$iv$iv$iv = tag;
            boolean $i$f$getProtoId = false;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)($this$protoId$iv$iv$iv & Integer.MAX_VALUE) + " of " + this_$iv$iv.descriptor.getSerialName(), e$iv);
        }
        return l;
    }

    @Override
    protected float decodeTaggedFloat(long tag) {
        float f;
        ProtobufDecoder this_$iv = this;
        boolean $i$f$decodeOrThrow = false;
        try {
            long it = tag;
            boolean bl = false;
            f = tag == 19500L ? this.reader.readFloatNoTag() : this.reader.readFloat();
        }
        catch (ProtobufDecodingException e$iv) {
            ProtobufDecoder this_$iv$iv = this_$iv;
            boolean $i$f$rethrowException = false;
            long $this$protoId$iv$iv$iv = tag;
            boolean $i$f$getProtoId = false;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)($this$protoId$iv$iv$iv & Integer.MAX_VALUE) + " of " + this_$iv$iv.descriptor.getSerialName(), e$iv);
        }
        return f;
    }

    @Override
    protected double decodeTaggedDouble(long tag) {
        double d;
        ProtobufDecoder this_$iv = this;
        boolean $i$f$decodeOrThrow = false;
        try {
            long it = tag;
            boolean bl = false;
            d = tag == 19500L ? this.reader.readDoubleNoTag() : this.reader.readDouble();
        }
        catch (ProtobufDecodingException e$iv) {
            ProtobufDecoder this_$iv$iv = this_$iv;
            boolean $i$f$rethrowException = false;
            long $this$protoId$iv$iv$iv = tag;
            boolean $i$f$getProtoId = false;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)($this$protoId$iv$iv$iv & Integer.MAX_VALUE) + " of " + this_$iv$iv.descriptor.getSerialName(), e$iv);
        }
        return d;
    }

    @Override
    protected char decodeTaggedChar(long tag) {
        return (char)this.decodeTaggedInt(tag);
    }

    @Override
    @NotNull
    protected String decodeTaggedString(long tag) {
        String string;
        ProtobufDecoder this_$iv = this;
        boolean $i$f$decodeOrThrow = false;
        try {
            long it = tag;
            boolean bl = false;
            string = tag == 19500L ? this.reader.readStringNoTag() : this.reader.readString();
        }
        catch (ProtobufDecodingException e$iv) {
            ProtobufDecoder this_$iv$iv = this_$iv;
            boolean $i$f$rethrowException = false;
            long $this$protoId$iv$iv$iv = tag;
            boolean $i$f$getProtoId = false;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)($this$protoId$iv$iv$iv & Integer.MAX_VALUE) + " of " + this_$iv$iv.descriptor.getSerialName(), e$iv);
        }
        return string;
    }

    @Override
    protected int decodeTaggedEnum(long tag, @NotNull SerialDescriptor enumDescription) {
        Intrinsics.checkNotNullParameter(enumDescription, "enumDescription");
        return this.findIndexByTag(enumDescription, this.decodeTaggedInt(tag));
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return this.decodeSerializableValue(deserializer, null);
    }

    @Override
    protected <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer, @Nullable T previousValue) {
        T t;
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        try {
            t = deserializer instanceof MapLikeSerializer ? this.deserializeMap(deserializer, previousValue) : (Intrinsics.areEqual(deserializer.getDescriptor(), BuiltinSerializersKt.ByteArraySerializer().getDescriptor()) ? (Object)this.deserializeByteArray((byte[])previousValue) : (deserializer instanceof AbstractCollectionSerializer ? ((AbstractCollectionSerializer)deserializer).merge(this, previousValue) : deserializer.deserialize(this)));
        }
        catch (ProtobufDecodingException e) {
            String string;
            long currentTag = this.getCurrentTagOrDefault();
            if (!Intrinsics.areEqual(this.descriptor, deserializer.getDescriptor())) {
                if (Intrinsics.areEqual(this.descriptor.getKind(), StructureKind.LIST.INSTANCE) && !Intrinsics.areEqual(deserializer.getDescriptor().getKind(), StructureKind.MAP.INSTANCE)) {
                    long $this$protoId$iv = currentTag;
                    boolean $i$f$getProtoId = false;
                    string = "Error while decoding index " + ((int)($this$protoId$iv & Integer.MAX_VALUE) - 1) + " in repeated field of " + deserializer.getDescriptor().getSerialName();
                } else if (Intrinsics.areEqual(this.descriptor.getKind(), StructureKind.MAP.INSTANCE)) {
                    long $this$protoId$iv = currentTag;
                    boolean $i$f$getProtoId = false;
                    int index = ((int)($this$protoId$iv & Integer.MAX_VALUE) - 1) / 2;
                    long $this$protoId$iv2 = currentTag;
                    boolean $i$f$getProtoId2 = false;
                    String field = ((int)($this$protoId$iv2 & Integer.MAX_VALUE) - 1) % 2 == 0 ? "key" : "value";
                    string = "Error while decoding " + field + " of index " + index + " in map field of " + deserializer.getDescriptor().getSerialName();
                } else {
                    long $this$protoId$iv = currentTag;
                    boolean $i$f$getProtoId = false;
                    string = "Error while decoding " + deserializer.getDescriptor().getSerialName() + " at proto number " + (int)($this$protoId$iv & Integer.MAX_VALUE) + " of " + this.descriptor.getSerialName();
                }
            } else {
                string = "Error while decoding " + this.descriptor.getSerialName();
            }
            String msg = string;
            throw new ProtobufDecodingException(msg, e);
        }
        return t;
    }

    private final byte[] deserializeByteArray(byte[] previousValue) {
        byte[] byArray;
        long tag = this.getCurrentTagOrDefault();
        ProtobufDecoder this_$iv = this;
        boolean $i$f$decodeOrThrow = false;
        try {
            long it = tag;
            boolean bl = false;
            byArray = tag == 19500L ? this.reader.readByteArrayNoTag() : this.reader.readByteArray();
        }
        catch (ProtobufDecodingException e$iv) {
            ProtobufDecoder this_$iv$iv = this_$iv;
            boolean $i$f$rethrowException = false;
            long $this$protoId$iv$iv$iv = tag;
            boolean $i$f$getProtoId = false;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)($this$protoId$iv$iv$iv & Integer.MAX_VALUE) + " of " + this_$iv$iv.descriptor.getSerialName(), e$iv);
        }
        byte[] array = byArray;
        return previousValue == null ? array : ArraysKt.plus(previousValue, array);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T deserializeMap(DeserializationStrategy<? extends T> deserializer, T previousValue) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNull(deserializer, "null cannot be cast to non-null type kotlinx.serialization.internal.MapLikeSerializer<kotlin.Any?, kotlin.Any?, T of kotlinx.serialization.protobuf.internal.ProtobufDecoder.deserializeMap, *>");
        MapLikeSerializer serializer2 = (MapLikeSerializer)deserializer;
        KSerializer mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer(serializer2.getKeySerializer(), serializer2.getValueSerializer());
        Map map2 = previousValue instanceof Map ? (Map)previousValue : null;
        Set oldSet = map2 != null ? map2.entrySet() : null;
        KSerializer kSerializer = BuiltinSerializersKt.SetSerializer(mapEntrySerial);
        Intrinsics.checkNotNull(kSerializer, "null cannot be cast to non-null type kotlinx.serialization.internal.AbstractCollectionSerializer<kotlin.collections.Map.Entry<kotlin.Any?, kotlin.Any?>, kotlin.collections.Set<kotlin.collections.Map.Entry<kotlin.Any?, kotlin.Any?>>, *>");
        Set setOfEntries = ((AbstractCollectionSerializer)kSerializer).merge(this, oldSet);
        Iterable $this$associateBy$iv = setOfEntries;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            Object k = it.getKey();
            boolean bl2 = false;
            Object v = it.getValue();
            map3.put(k, v);
        }
        return (T)destination$iv$iv;
    }

    @Override
    protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
        Intrinsics.checkNotNullParameter($this$getTag, "<this>");
        return HelpersKt.extractParameters($this$getTag, index);
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        try {
            int index;
            int protoId;
            while (true) {
                if ((protoId = this.reader.readTag()) == -1) {
                    return this.elementMarker.nextUnmarkedIndex();
                }
                if (protoId == 0) {
                    throw new SerializationException("0 is not allowed as the protobuf field number in " + descriptor2.getSerialName() + ", the input bytes may have been corrupted");
                }
                index = this.getIndexByNum(protoId);
                if (index != -1) break;
                this.reader.skipElement();
            }
            if (HelpersKt.isOneOf(HelpersKt.extractParameters(descriptor2, index))) {
                Map<Integer, Integer> map2 = this.index2IdMap;
                if (map2 != null) {
                    map2.put(index, protoId);
                }
            }
            this.elementMarker.mark(index);
            return index;
        }
        catch (ProtobufDecodingException e) {
            throw new ProtobufDecodingException("Fail to get element index for " + descriptor2.getSerialName() + " in " + this.descriptor.getSerialName(), e);
        }
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.nullValue;
    }

    private final boolean readIfAbsent(SerialDescriptor descriptor2, int index) {
        if (!descriptor2.isElementOptional(index)) {
            SerialDescriptor elementDescriptor = descriptor2.getElementDescriptor(index);
            SerialKind kind2 = elementDescriptor.getKind();
            if (Intrinsics.areEqual(kind2, StructureKind.MAP.INSTANCE) || Intrinsics.areEqual(kind2, StructureKind.LIST.INSTANCE)) {
                this.nullValue = false;
                return true;
            }
            if (elementDescriptor.isNullable()) {
                this.nullValue = true;
                return true;
            }
        }
        return false;
    }

    private final <T> T decodeOrThrow(long tag, Function1<? super Long, ? extends T> action) {
        boolean $i$f$decodeOrThrow = false;
        try {
            return action.invoke(tag);
        }
        catch (ProtobufDecodingException e) {
            ProtobufDecoder this_$iv = this;
            boolean $i$f$rethrowException = false;
            long $this$protoId$iv$iv = tag;
            boolean $i$f$getProtoId = false;
            throw new ProtobufDecodingException("Error while decoding proto number " + (int)($this$protoId$iv$iv & Integer.MAX_VALUE) + " of " + this_$iv.descriptor.getSerialName(), e);
        }
    }

    private final Void rethrowException(long tag, ProtobufDecodingException e) {
        boolean $i$f$rethrowException = false;
        long $this$protoId$iv = tag;
        boolean $i$f$getProtoId = false;
        throw new ProtobufDecodingException("Error while decoding proto number " + (int)($this$protoId$iv & Integer.MAX_VALUE) + " of " + this.descriptor.getSerialName(), e);
    }

    public static final /* synthetic */ boolean access$readIfAbsent(ProtobufDecoder $this, SerialDescriptor descriptor2, int index) {
        return $this.readIfAbsent(descriptor2, index);
    }
}

