// SPDX-License-Identifier: LGPL-2.1-or-later
/*
 * Copyright © 2009 Christian Persch
 */

#pragma once

/**
 * SECTION:pps-version
 * @short_description: Library version checks
 *
 * These macros enable compile time checks of the library version.
 */

/**
 * PPS_MAJOR_VERSION:
 *
 * The major version number of the EV library
 * (e.g. in version 3.1.4 this is 3).
 */

#define PPS_MAJOR_VERSION (49)

/**
 * PPS_MINOR_VERSION:
 *
 * The minor version number of the EV library
 * (e.g. in version 3.1.4 this is 1).
 */
#define PPS_MINOR_VERSION (4)

/**
 * PPS_CHECK_VERSION:
 * @major: required major version
 * @minor: required minor version
 *
 * Macro to check the library version at compile time.
 * It returns <literal>1</literal> if the version of EV is greater or
 * equal to the required one, and <literal>0</literal> otherwise.
 */
#define PPS_CHECK_VERSION(major,minor) \
  (PPS_MAJOR_VERSION > (major) || \
   (PPS_MAJOR_VERSION == (major) && PPS_MINOR_VERSION > (minor))
