/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ano;

import java.io.IOException;
import java.util.ArrayList;
import oracle.net.ano.Service;
import oracle.net.aso.EncryptionAlgorithm;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class EncryptionService
extends Service
implements SQLnetDef {
    static final String[] ENCRYPTION_JAVA_ANO_ID = new String[]{"", "AES128", "AES192", "AES256"};
    private final byte[] ENCRYPTION_ORACLE_ID = new byte[]{0, 15, 16, 17};
    private boolean encryptionActivated = false;
    static final int NUM_ENCRYPTION_SUBPACKETS = 2;

    @Override
    int init(SessionAtts sAtts) throws NetException {
        int i;
        super.init(sAtts);
        this.service = 2;
        this.level = sAtts.profile.getEncryptionLevelNum();
        String[] userChoiceDrivers = sAtts.profile.getEncryptionServices();
        userChoiceDrivers = this.removeWeakEncryptionDrivers(userChoiceDrivers);
        userChoiceDrivers = this.getValidUserChoices(userChoiceDrivers, ENCRYPTION_JAVA_ANO_ID);
        this.userChoiceDriversId = new int[userChoiceDrivers.length];
        for (i = 0; i < this.userChoiceDriversId.length; ++i) {
            this.userChoiceDriversId[i] = this.getDriverID(ENCRYPTION_JAVA_ANO_ID, userChoiceDrivers[i]);
        }
        this.userChoiceDriversId = this.createDriversListWithLevel(this.userChoiceDriversId, this.level);
        this.selectedDrivers = new byte[this.userChoiceDriversId.length];
        for (i = 0; i < this.selectedDrivers.length; ++i) {
            this.selectedDrivers[i] = this.ENCRYPTION_ORACLE_ID[this.userChoiceDriversId[i]];
        }
        int flags = 1;
        if (this.userChoiceDriversId.length == 0) {
            if (this.level == 3) {
                throw new NetException(18915);
            }
            flags |= 8;
        } else if (this.level == 3) {
            flags |= 0x10;
        }
        return flags;
    }

    @Override
    public boolean isActive() {
        return this.encryptionActivated;
    }

    @Override
    void receiveServiceData(int numSubPackets) throws NetException, IOException {
        if (numSubPackets != 2) {
            throw new NetException(18905);
        }
        this.version = this.comm.receiveVersion();
        this.sAtts.profile.setANOVersion(this.version);
        short receiveDriverId = this.comm.receiveUB1();
        this.algID = (short)-1;
        for (int i = 0; i < ENCRYPTION_JAVA_ANO_ID.length; ++i) {
            if (this.ENCRYPTION_ORACLE_ID[i] != receiveDriverId) continue;
            this.algID = (short)i;
        }
        this.encryptionActivated = this.algID > 0;
    }

    @Override
    void validateResponse() throws NetException, IOException {
        if (this.algID < 0) {
            throw new NetException(18916);
        }
        if (this.encryptionActivated) {
            if (this.sAtts.profile.isServerUsingWeakCrypto() && !this.sAtts.profile.isWeakCryptoEnabled()) {
                throw new NetException(12268);
            }
        } else if (this.level == 3) {
            throw new NetException(18921, "Encryption is REQUIRED but activation failed.");
        }
        for (int i = 0; i < this.userChoiceDriversId.length; ++i) {
            if (this.userChoiceDriversId[i] != this.algID) continue;
            return;
        }
        throw new NetException(18916);
    }

    @Override
    void activateAlgorithm() throws NetException, IOException {
        if (this.encryptionActivated) {
            this.ano.encryptionAlg = EncryptionAlgorithm.newInstance(ENCRYPTION_JAVA_ANO_ID[this.algID], this.ano.getSessionKey(), this.ano.getInitializationVector(), this.sAtts.profile.useWeakCrypto());
            this.sAtts.isEncryptionActive = true;
        }
    }

    private String[] removeWeakEncryptionDrivers(String[] userChoiceDrivers) throws NetException {
        if (userChoiceDrivers == null || userChoiceDrivers.length == 0) {
            return userChoiceDrivers;
        }
        ArrayList<String> strongCryptoDrivers = new ArrayList<String>();
        for (String driver : userChoiceDrivers) {
            if (this.isWeakEncryptionDriver(driver)) continue;
            strongCryptoDrivers.add(driver);
        }
        if (this.level != 1 && strongCryptoDrivers.size() == 0) {
            throw new NetException(18903, (String)this.sAtts.profile.get("oracle.net.encryption_types_client"));
        }
        return strongCryptoDrivers.toArray(new String[strongCryptoDrivers.size()]);
    }

    private boolean isWeakEncryptionDriver(String driver) {
        return !"AES128".equalsIgnoreCase(driver) && !"AES192".equalsIgnoreCase(driver) && !"AES256".equalsIgnoreCase(driver);
    }
}

