/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.durationpicker_underconstruction;

import com.github.lgooddatepicker.durationpicker_underconstruction.DurationConverterSettings;
import com.github.lgooddatepicker.durationpicker_underconstruction.DurationUnit;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class DurationConverter {
    public static Duration convertStringToDuration(String text, DurationConverterSettings settings) {
        BigDecimal value;
        String[] parts;
        if (text == null) {
            return null;
        }
        if ((text = text.trim().toLowerCase()).isEmpty()) {
            return null;
        }
        if (!text.contains(" ")) {
            for (int i = 0; i < text.length(); ++i) {
                char currentChar = text.charAt(i);
                if (Character.isDigit(currentChar) || currentChar == '.') continue;
                text = InternalUtilities.safeSubstring(text, 0, i) + " " + InternalUtilities.safeSubstring(text, i, text.length());
                break;
            }
        }
        if ((parts = text.split(" ")).length != 2) {
            return null;
        }
        String valueText = parts[0];
        String unitsText = parts[1];
        try {
            value = new BigDecimal(valueText);
        }
        catch (Exception e) {
            return null;
        }
        HashMap<DurationUnit, ArrayList<String>> parsingPrefixes = settings.translationsParsingPrefixes;
        for (String prefix : parsingPrefixes.get((Object)DurationUnit.Year)) {
            if (!unitsText.startsWith(prefix)) continue;
            value = value.multiply(new BigDecimal(DurationUnit.Year.inSeconds));
            return Duration.ofSeconds(value.longValue());
        }
        for (String prefix : parsingPrefixes.get((Object)DurationUnit.Month)) {
            if (!unitsText.startsWith(prefix)) continue;
            value = value.multiply(new BigDecimal(DurationUnit.Month.inSeconds));
            return Duration.ofSeconds(value.longValue());
        }
        for (String prefix : parsingPrefixes.get((Object)DurationUnit.Week)) {
            if (!unitsText.startsWith(prefix)) continue;
            value = value.multiply(new BigDecimal(DurationUnit.Week.inSeconds));
            return Duration.ofSeconds(value.longValue());
        }
        for (String prefix : parsingPrefixes.get((Object)DurationUnit.Day)) {
            if (!unitsText.startsWith(prefix)) continue;
            value = value.multiply(new BigDecimal(DurationUnit.Day.inSeconds));
            return Duration.ofSeconds(value.longValue());
        }
        for (String prefix : parsingPrefixes.get((Object)DurationUnit.Hour)) {
            if (!unitsText.startsWith(prefix)) continue;
            value = value.multiply(new BigDecimal(DurationUnit.Hour.inSeconds));
            return Duration.ofSeconds(value.longValue());
        }
        for (String prefix : parsingPrefixes.get((Object)DurationUnit.Minute)) {
            if (!unitsText.startsWith(prefix)) continue;
            value = value.multiply(new BigDecimal(DurationUnit.Minute.inSeconds));
            return Duration.ofSeconds(value.longValue());
        }
        for (String prefix : parsingPrefixes.get((Object)DurationUnit.Second)) {
            if (!unitsText.startsWith(prefix)) continue;
            value = value.multiply(new BigDecimal(DurationUnit.Second.inSeconds));
            BigDecimal fractionalPartInNanos = value.remainder(BigDecimal.ONE);
            fractionalPartInNanos = fractionalPartInNanos.multiply(new BigDecimal(1000000000));
            Duration result = Duration.ofSeconds(value.longValue());
            result = result.plusNanos(fractionalPartInNanos.longValue());
            return result;
        }
        return null;
    }

    public static String convertStringFromDuration(Duration duration, DurationConverterSettings settings) {
        boolean minuteIsBestChoice;
        boolean hourIntegerIsBestChoice;
        boolean hourDecimalIsBestChoice;
        boolean dayIsBestChoice;
        boolean weekIsBestChoice;
        boolean monthIsBestChoice;
        boolean yearIsBestChoice;
        if (duration == null || duration.isNegative()) {
            return "";
        }
        long seconds = duration.getSeconds();
        HashSet<DurationUnit> usedUnits = DurationConverter.getUsedDurationUnitSet(settings.smallestUsedUnit, settings.largestUsedUnit);
        if (usedUnits.isEmpty()) {
            throw new RuntimeException("convertStringFromDuration(), The \"used duration unit\" variables do not allow any units to be used.");
        }
        boolean hasNoNanos = duration.getNano() == 0;
        DurationUnit smallestUnit = settings.smallestUsedUnit;
        HashMap<DurationUnit, String> unitsSingular = settings.translationsUnitsSingular;
        HashMap<DurationUnit, String> unitsPlural = settings.translationsUnitsPlural;
        HashMap<DurationUnit, Boolean> pluralRules = settings.pluralUnitsMap;
        int oneYear = DurationUnit.Year.inSeconds;
        int oneMonth = DurationUnit.Month.inSeconds;
        int oneWeek = DurationUnit.Week.inSeconds;
        int oneDay = DurationUnit.Day.inSeconds;
        int oneHour = DurationUnit.Hour.inSeconds;
        int oneMinute = DurationUnit.Minute.inSeconds;
        int thirtyMinutes = DurationUnit.Second.thirtyMinutesInSeconds;
        String result = "";
        boolean bl = yearIsBestChoice = usedUnits.contains((Object)DurationUnit.Year) && hasNoNanos && seconds >= (long)oneYear && seconds % (long)oneYear == 0L;
        if (yearIsBestChoice || DurationUnit.Year == smallestUnit) {
            long value = seconds / (long)oneYear;
            result = result + value + " ";
            result = result + (pluralRules.get((Object)DurationUnit.Year) != false && value != 1L ? unitsPlural.get((Object)DurationUnit.Year) : unitsSingular.get((Object)DurationUnit.Year));
            return result;
        }
        boolean bl2 = monthIsBestChoice = usedUnits.contains((Object)DurationUnit.Month) && hasNoNanos && seconds >= (long)oneMonth && seconds % (long)oneMonth == 0L;
        if (monthIsBestChoice || DurationUnit.Month == smallestUnit) {
            long value = seconds / (long)oneMonth;
            result = result + value + " ";
            result = result + (pluralRules.get((Object)DurationUnit.Month) != false && value != 1L ? unitsPlural.get((Object)DurationUnit.Month) : unitsSingular.get((Object)DurationUnit.Month));
            return result;
        }
        boolean bl3 = weekIsBestChoice = usedUnits.contains((Object)DurationUnit.Week) && hasNoNanos && seconds >= (long)oneWeek && seconds % (long)oneWeek == 0L;
        if (weekIsBestChoice || DurationUnit.Week == smallestUnit) {
            long value = seconds / (long)oneWeek;
            result = result + value + " ";
            result = result + (pluralRules.get((Object)DurationUnit.Week) != false && value != 1L ? unitsPlural.get((Object)DurationUnit.Week) : unitsSingular.get((Object)DurationUnit.Week));
            return result;
        }
        boolean bl4 = dayIsBestChoice = usedUnits.contains((Object)DurationUnit.Day) && hasNoNanos && seconds >= (long)oneDay && seconds % (long)oneDay == 0L;
        if (dayIsBestChoice || DurationUnit.Day == smallestUnit) {
            long value = seconds / (long)oneDay;
            result = result + value + " ";
            result = result + (pluralRules.get((Object)DurationUnit.Day) != false && value != 1L ? unitsPlural.get((Object)DurationUnit.Day) : unitsSingular.get((Object)DurationUnit.Day));
            return result;
        }
        boolean bl5 = hourDecimalIsBestChoice = settings.hoursCanUseThirtyMinuteDecimals && usedUnits.contains((Object)DurationUnit.Hour) && hasNoNanos && seconds >= (long)oneHour && seconds <= (long)settings.hoursMaximumValueForDecimalsInSeconds && seconds % (long)thirtyMinutes == 0L && seconds % (long)oneHour != 0L;
        if (hourDecimalIsBestChoice) {
            long value = seconds / (long)oneHour;
            String decimalString = ".5";
            result = result + value + decimalString + " ";
            result = result + (pluralRules.get((Object)DurationUnit.Hour) != false ? unitsPlural.get((Object)DurationUnit.Hour) : unitsSingular.get((Object)DurationUnit.Hour));
            return result;
        }
        boolean bl6 = hourIntegerIsBestChoice = usedUnits.contains((Object)DurationUnit.Hour) && hasNoNanos && seconds >= (long)oneHour && seconds % (long)oneHour == 0L;
        if (hourIntegerIsBestChoice || DurationUnit.Hour == smallestUnit) {
            long value = seconds / (long)oneHour;
            result = result + value + " ";
            result = result + (pluralRules.get((Object)DurationUnit.Hour) != false && value != 1L ? unitsPlural.get((Object)DurationUnit.Hour) : unitsSingular.get((Object)DurationUnit.Hour));
            return result;
        }
        boolean bl7 = minuteIsBestChoice = usedUnits.contains((Object)DurationUnit.Minute) && hasNoNanos && seconds >= (long)oneMinute && seconds % (long)oneMinute == 0L;
        if (minuteIsBestChoice || DurationUnit.Minute == smallestUnit) {
            long value = seconds / (long)oneMinute;
            result = result + value + " ";
            result = result + (pluralRules.get((Object)DurationUnit.Minute) != false && value != 1L ? unitsPlural.get((Object)DurationUnit.Minute) : unitsSingular.get((Object)DurationUnit.Minute));
            return result;
        }
        boolean secondIsBestChoice = usedUnits.contains((Object)DurationUnit.Second);
        if (secondIsBestChoice || DurationUnit.Second == smallestUnit) {
            long value = seconds;
            int nanosecondsFromDuration = duration.getNano();
            boolean includeNanoseconds = nanosecondsFromDuration != 0;
            BigDecimal nanosecondsInSeconds = BigDecimal.valueOf(nanosecondsFromDuration, 9);
            BigDecimal secondsWithNanosAdded = nanosecondsInSeconds.add(new BigDecimal(value));
            secondsWithNanosAdded = secondsWithNanosAdded.stripTrailingZeros();
            result = result + (includeNanoseconds ? secondsWithNanosAdded.toPlainString() : Long.valueOf(value));
            result = result + " ";
            result = result + (pluralRules.get((Object)DurationUnit.Second) != false && (value != 1L || includeNanoseconds) ? unitsPlural.get((Object)DurationUnit.Second) : unitsSingular.get((Object)DurationUnit.Second));
            return result;
        }
        throw new RuntimeException("convertStringFromDuration(), The duration unit could not be chosen. (This should not happen.)");
    }

    private static HashSet<DurationUnit> getUsedDurationUnitSet(DurationUnit smallestUnit, DurationUnit largestUnit) {
        HashSet<DurationUnit> result = new HashSet<DurationUnit>();
        for (DurationUnit unit : DurationUnit.values()) {
            if (unit.compareTo(smallestUnit) < 0 || unit.compareTo(largestUnit) > 0) continue;
            result.add(unit);
        }
        return result;
    }

    public static void main(String[] args) {
        DurationConverterSettings settings = new DurationConverterSettings();
        settings.smallestUsedUnit = DurationUnit.Second;
        settings.largestUsedUnit = DurationUnit.Year;
        settings.pluralUnitsMap = settings.getSimplePluralUnitsMap(true);
        String s1 = DurationConverter.convertStringFromDuration(null, settings);
        String s2 = DurationConverter.convertStringFromDuration(Duration.ofSeconds(-1L), settings);
        String s3 = DurationConverter.convertStringFromDuration(Duration.ofSeconds(0L), settings);
        String s4 = DurationConverter.convertStringFromDuration(Duration.ofSeconds(1L), settings);
        String s5 = DurationConverter.convertStringFromDuration(Duration.ofSeconds(1L).plusNanos(2L), settings);
        Duration m1 = DurationConverter.convertStringToDuration("", settings);
        Duration m2 = DurationConverter.convertStringToDuration(" ", settings);
        Duration m3 = DurationConverter.convertStringToDuration("gobbldy gook", settings);
        Duration m4 = DurationConverter.convertStringToDuration("gobbldy gook 55", settings);
        Duration m5 = DurationConverter.convertStringToDuration("5.5g", settings);
        Duration m6 = DurationConverter.convertStringToDuration("5.5m", settings);
        Duration m7 = DurationConverter.convertStringToDuration("3.62h", settings);
        String ss7 = DurationConverter.convertStringFromDuration(m7, settings);
        Duration m8 = DurationConverter.convertStringToDuration("5.5d", settings);
        Duration m9 = DurationConverter.convertStringToDuration("5.5w", settings);
        Duration duration = Duration.ofSeconds(0L).plusNanos(0L);
        while (duration.compareTo(Duration.ofDays(1000L)) <= 0) {
            String textDuration = DurationConverter.convertStringFromDuration(duration, settings);
            Duration durationParsed = DurationConverter.convertStringToDuration(textDuration, settings);
            System.out.println("Duration: " + duration.toString() + ", Text: " + textDuration + ", DurationParsed: " + (durationParsed == null ? "null" : durationParsed.toString()));
            if (durationParsed == null || !durationParsed.equals(duration)) {
                throw new RuntimeException("");
            }
            duration = duration.plusHours(1L);
        }
    }
}

