/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import mediathek.config.Daten;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.daten.blacklist.ListeBlacklist;
import org.jetbrains.annotations.NotNull;

public class BlacklistRuleTableModel
extends AbstractTableModel {
    private static final int BLACKLIST_SENDER = 0;
    private static final int BLACKLIST_THEMA = 1;
    private static final int BLACKLIST_TITEL = 2;
    private static final int BLACKLIST_THEMA_TITEL = 3;
    private final ListeBlacklist blacklist = Daten.getInstance().getListeBlacklist();

    @Override
    public int getRowCount() {
        return this.blacklist.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        BlacklistRule rule = this.blacklist.get(rowIndex);
        return switch (columnIndex) {
            case 0 -> rule.getSender();
            case 1 -> rule.getThema();
            case 2 -> rule.getTitel();
            case 3 -> rule.getThema_titel();
            default -> throw new IllegalStateException("Unexpected value: " + columnIndex);
        };
    }

    @Override
    public String getColumnName(int column) {
        return switch (column) {
            case 0 -> "Sender";
            case 1 -> "Thema";
            case 2 -> "Titel";
            case 3 -> "Thema-Titel";
            default -> throw new IllegalStateException("Unexpected value: " + column);
        };
    }

    public void removeRow(int modelIndex) {
        this.blacklist.remove(modelIndex);
        this.fireTableRowsDeleted(modelIndex, modelIndex);
    }

    public void removeRules(@NotNull List<BlacklistRule> list) {
        this.blacklist.remove(list);
        this.fireTableDataChanged();
    }

    public void removeAll() {
        this.blacklist.clear();
        this.fireTableDataChanged();
    }

    public void addRule(@NotNull BlacklistRule rule) {
        this.blacklist.add(rule);
        this.fireTableDataChanged();
    }

    public boolean contains(@NotNull BlacklistRule rule) {
        return this.blacklist.contains(rule);
    }

    public BlacklistRule get(int fromModelIndex) {
        return this.blacklist.get(fromModelIndex);
    }
}

