/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.checkers.CheckerUtilsKt;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionChecker;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrCallTypeChecker;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrExpressionChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "ir.backend.common"})
public final class IrCallTypeChecker
implements IrExpressionChecker<IrCall> {
    @NotNull
    public static final IrCallTypeChecker INSTANCE = new IrCallTypeChecker();

    private IrCallTypeChecker() {
    }

    @Override
    public void check(@NotNull IrCall expression2, @NotNull CheckerContext context2) {
        IrSimpleFunction actualCallee;
        IrType returnType;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract((IrOverridableDeclaration)callee, IrCallTypeChecker::check$lambda$0);
        if (irSimpleFunction == null) {
            irSimpleFunction = callee;
        }
        if ((returnType = (actualCallee = irSimpleFunction).getReturnType()) instanceof IrSimpleType && ((IrSimpleType)returnType).getClassifier() instanceof IrClassSymbol && ((IrSimpleType)returnType).getArguments().isEmpty()) {
            CheckerUtilsKt.ensureTypeIs(expression2, callee.getReturnType(), context2);
        }
    }

    private static final boolean check$lambda$0(IrSimpleFunction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isFakeOverride() || !(IrTypesKt.getClassifierOrNull(it.getReturnType()) instanceof IrTypeParameterSymbol);
    }
}

