/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.JavaStringCodec;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeCodec;

class JavaMediaTypeCodec
implements MediaTypeCodec {
    JavaMediaTypeCodec() {
    }

    @Override
    public Object decodeContent(Object content, MediaType contentType) {
        String strContent;
        String type = contentType.getClassType();
        if (!contentType.match(MediaType.APPLICATION_OBJECT) || type == null) {
            return content;
        }
        if (content instanceof byte[]) {
            strContent = new String((byte[])content, contentType.getCharset());
        } else if (content instanceof String) {
            strContent = content.toString();
        } else {
            return content;
        }
        if (content.getClass().getName().equals(type)) {
            return content;
        }
        JavaStringCodec codec = JavaStringCodec.forType(type);
        if (codec == null) {
            throw new EncodingException("Type " + type + " is unsupported");
        }
        return codec.decode(strContent);
    }

    @Override
    public Object encodeContent(Object content, MediaType destinationType) {
        String type = destinationType.getClassType();
        if (!destinationType.match(MediaType.APPLICATION_OBJECT) || type == null) {
            return content;
        }
        if (content.getClass().getName().equals(type)) {
            return content;
        }
        JavaStringCodec codec = JavaStringCodec.forType(type);
        return codec.encode(content, destinationType);
    }
}

