/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.common.utils.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.WildcardPropertyMapper;

public class KcEnvConfigSource
extends PropertiesConfigSource {
    public static final String NAME = "KcEnvVarConfigSource";
    public static final String KCKEY_PREFIX = "KCKEY_";
    static final Map<String, String> ENV_OVERRIDE = new HashMap<String, String>();

    public KcEnvConfigSource(Map<String, String> env) {
        super(KcEnvConfigSource.buildProperties(env), NAME, 500);
    }

    private static Map<String, String> buildProperties(Map<String, String> env) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String kcPrefix = StringUtil.replaceNonAlphanumericByUnderscores((String)"kc.".toUpperCase());
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Object transformedKey = null;
            if (!key.startsWith(kcPrefix)) continue;
            String baseKey = key.substring(kcPrefix.length());
            String actualKey = env.get(KCKEY_PREFIX + baseKey);
            if (actualKey != null) {
                transformedKey = "kc." + actualKey;
            } else {
                transformedKey = "kc." + baseKey.toLowerCase().replace("_", "-");
                PropertyMapper<?> mapper = PropertyMappers.getMapper((String)transformedKey);
                if (mapper != null && mapper.hasWildcard()) {
                    WildcardPropertyMapper wildcardPropertyMapper = (WildcardPropertyMapper)mapper;
                    transformedKey = wildcardPropertyMapper.getKcKeyForEnvKey(key, (String)transformedKey).orElseThrow();
                }
            }
            properties.put((String)transformedKey, value);
        }
        return properties;
    }

    public static Collection<ConfigSource> getConfigSources() {
        Map<String, String> env = System.getenv();
        if (ENV_OVERRIDE.isEmpty()) {
            return List.of(new KcEnvConfigSource(env));
        }
        env = new HashMap<String, String>(env);
        env.putAll(ENV_OVERRIDE);
        return List.of(new KcEnvConfigSource(env), new EnvConfigSource(ENV_OVERRIDE, 301));
    }
}

