/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

abstract class BaseResourceEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    @ProtoField(value=2)
    final String name;
    @ProtoField(value=3)
    final String owner;
    @ProtoField(value=4)
    final String serverId;
    @ProtoField(value=5)
    final String type;
    @ProtoField(value=6, collectionImplementation=HashSet.class)
    final Set<String> uris;
    @ProtoField(value=7, collectionImplementation=HashSet.class)
    final Set<String> scopes;

    BaseResourceEvent(String id, String name, String owner, String serverId, String type, Set<String> uris, Set<String> scopes) {
        super(id);
        this.name = Objects.requireNonNull(name);
        this.owner = Objects.requireNonNull(owner);
        this.serverId = Objects.requireNonNull(serverId);
        this.type = type;
        this.uris = uris;
        this.scopes = scopes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseResourceEvent that = (BaseResourceEvent)o;
        return this.name.equals(that.name) && this.owner.equals(that.owner) && this.serverId.equals(that.serverId) && Objects.equals(this.type, that.type) && Objects.equals(this.uris, that.uris) && Objects.equals(this.scopes, that.scopes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.owner.hashCode();
        result = 31 * result + this.serverId.hashCode();
        result = 31 * result + Objects.hashCode(this.type);
        result = 31 * result + Objects.hashCode(this.uris);
        result = 31 * result + Objects.hashCode(this.scopes);
        return result;
    }

    public String toString() {
        return String.format("%s [ id=%s, name=%s]", this.getClass().getSimpleName(), this.getId(), this.name);
    }
}

