/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.dialect.temptable.TemporaryTableHelper;
import org.hibernate.dialect.temptable.TemporaryTableSessionUidColumn;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.internal.CacheableSqmInterpretation;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.BeforeUseAction;
import org.hibernate.resource.transaction.spi.IsolationDelegate;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.type.descriptor.WrapperOptions;

public final class ExecuteWithTemporaryTableHelper {
    private ExecuteWithTemporaryTableHelper() {
    }

    public static CacheableSqmInterpretation<InsertSelectStatement, JdbcOperationQueryMutation> createMatchingIdsIntoIdTableInsert(MultiTableSqmMutationConverter sqmConverter, Predicate suppliedPredicate, TemporaryTable idTable, JdbcParameter sessionUidParameter, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        TableGroup mutatingTableGroup = sqmConverter.getMutatingTableGroup();
        EntityMappingType mutatingEntityDescriptor = (EntityMappingType)mutatingTableGroup.getModelPart();
        NamedTableReference idTableReference = new NamedTableReference(idTable.getTableExpression(), "to_insert_");
        InsertSelectStatement idTableInsert = new InsertSelectStatement(idTableReference);
        for (int i = 0; i < idTable.getColumns().size(); ++i) {
            TemporaryTableColumn column = idTable.getColumns().get(i);
            idTableInsert.addTargetColumnReferences(new ColumnReference(idTableReference, column.getColumnName(), false, null, column.getJdbcMapping()));
        }
        QuerySpec matchingIdSelection = new QuerySpec(true, 1);
        idTableInsert.setSourceSelectStatement(matchingIdSelection);
        matchingIdSelection.getFromClause().addRoot(mutatingTableGroup);
        mutatingEntityDescriptor.getIdentifierMapping().forEachSelectable((selectionIndex, selection) -> matchingIdSelection.getSelectClause().addSqlSelection(new SqlSelectionImpl(selectionIndex, sqmConverter.getSqlExpressionResolver().resolveSqlExpression(mutatingTableGroup.resolveTableReference(mutatingTableGroup.getNavigablePath(), selection.getContainingTableExpression()), selection))));
        SharedSessionContractImplementor session = executionContext.getSession();
        if (idTable.getSessionUidColumn() != null) {
            int jdbcPosition = matchingIdSelection.getSelectClause().getSqlSelections().size();
            matchingIdSelection.getSelectClause().addSqlSelection(new SqlSelectionImpl(jdbcPosition, sessionUidParameter));
        }
        matchingIdSelection.applyPredicate(suppliedPredicate);
        SessionFactoryImplementor factory = session.getFactory();
        JdbcEnvironment jdbcEnvironment = factory.getJdbcServices().getJdbcEnvironment();
        LockOptions lockOptions = executionContext.getQueryOptions().getLockOptions();
        LockMode lockMode = lockOptions.getLockMode();
        lockOptions.setLockMode(LockMode.WRITE);
        QueryPart sourceSelectStatement = idTableInsert.getSourceSelectStatement();
        if (sourceSelectStatement != null && !jdbcEnvironment.getDialect().supportsOuterJoinForUpdate()) {
            sourceSelectStatement.visitQuerySpecs(querySpec -> querySpec.getFromClause().visitTableJoins(tableJoin -> {
                if (tableJoin.isInitialized() && tableJoin.getJoinType() != SqlAstJoinType.INNER) {
                    lockOptions.setLockMode(lockMode);
                }
            }));
        }
        JdbcOperationQueryMutation jdbcInsert = jdbcEnvironment.getSqlAstTranslatorFactory().buildMutationTranslator(factory, idTableInsert).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        lockOptions.setLockMode(lockMode);
        return new CacheableSqmInterpretation<InsertSelectStatement, JdbcOperationQueryMutation>(idTableInsert, jdbcInsert, Map.of(), Map.of());
    }

    public static CacheableSqmInterpretation<InsertSelectStatement, JdbcOperationQueryMutation> createTemporaryTableInsert(InsertSelectStatement temporaryTableInsert, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        LockOptions lockOptions = executionContext.getQueryOptions().getLockOptions();
        LockMode lockMode = lockOptions.getLockMode();
        lockOptions.setLockMode(LockMode.WRITE);
        QueryPart sourceSelectStatement = temporaryTableInsert.getSourceSelectStatement();
        if (sourceSelectStatement != null && !jdbcEnvironment.getDialect().supportsOuterJoinForUpdate()) {
            sourceSelectStatement.visitQuerySpecs(querySpec -> querySpec.getFromClause().visitTableJoins(tableJoin -> {
                if (tableJoin.isInitialized() && tableJoin.getJoinType() != SqlAstJoinType.INNER) {
                    lockOptions.setLockMode(lockMode);
                }
            }));
        }
        JdbcOperationQueryMutation jdbcInsert = jdbcEnvironment.getSqlAstTranslatorFactory().buildMutationTranslator(factory, temporaryTableInsert).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        lockOptions.setLockMode(lockMode);
        return new CacheableSqmInterpretation<InsertSelectStatement, JdbcOperationQueryMutation>(temporaryTableInsert, jdbcInsert, Map.of(), Map.of());
    }

    public static int saveIntoTemporaryTable(InsertSelectStatement temporaryTableInsert, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        LockOptions lockOptions = executionContext.getQueryOptions().getLockOptions();
        LockMode lockMode = lockOptions.getLockMode();
        lockOptions.setLockMode(LockMode.WRITE);
        QueryPart sourceSelectStatement = temporaryTableInsert.getSourceSelectStatement();
        if (sourceSelectStatement != null && !jdbcEnvironment.getDialect().supportsOuterJoinForUpdate()) {
            sourceSelectStatement.visitQuerySpecs(querySpec -> querySpec.getFromClause().visitTableJoins(tableJoin -> {
                if (tableJoin.isInitialized() && tableJoin.getJoinType() != SqlAstJoinType.INNER) {
                    lockOptions.setLockMode(lockMode);
                }
            }));
        }
        JdbcOperationQueryMutation jdbcInsert = jdbcEnvironment.getSqlAstTranslatorFactory().buildMutationTranslator(factory, temporaryTableInsert).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        lockOptions.setLockMode(lockMode);
        return ExecuteWithTemporaryTableHelper.saveIntoTemporaryTable(jdbcInsert, jdbcParameterBindings, executionContext);
    }

    public static int saveIntoTemporaryTable(JdbcOperationQueryMutation jdbcInsert, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        return executionContext.getSession().getFactory().getJdbcServices().getJdbcMutationExecutor().execute(jdbcInsert, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }

    public static QuerySpec createIdTableSelectQuerySpec(TemporaryTable idTable, JdbcParameter sessionUidParameter, EntityMappingType entityDescriptor, ExecutionContext executionContext) {
        return ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(idTable, null, sessionUidParameter, entityDescriptor, executionContext);
    }

    public static QuerySpec createIdTableSelectQuerySpec(TemporaryTable idTable, ModelPart fkModelPart, JdbcParameter sessionUidParameter, EntityMappingType entityDescriptor, ExecutionContext executionContext) {
        QuerySpec querySpec = new QuerySpec(false);
        NamedTableReference idTableReference = new NamedTableReference(idTable.getTableExpression(), "temptable_", true);
        StandardTableGroup idTableGroup = new StandardTableGroup(true, new NavigablePath(idTableReference.getTableExpression()), entityDescriptor, null, idTableReference, null, executionContext.getSession().getFactory());
        querySpec.getFromClause().addRoot(idTableGroup);
        ExecuteWithTemporaryTableHelper.applyIdTableSelections(querySpec, idTableReference, idTable, fkModelPart, entityDescriptor);
        ExecuteWithTemporaryTableHelper.applyIdTableRestrictions(querySpec, idTableReference, idTable, sessionUidParameter, executionContext);
        return querySpec;
    }

    private static void applyIdTableSelections(QuerySpec querySpec, TableReference tableReference, TemporaryTable idTable, ModelPart fkModelPart, EntityMappingType entityDescriptor) {
        if (fkModelPart == null) {
            int size = entityDescriptor.getIdentifierMapping().getJdbcTypeCount();
            for (int i2 = 0; i2 < size; ++i2) {
                TemporaryTableColumn temporaryTableColumn = idTable.getColumns().get(i2);
                if (temporaryTableColumn == idTable.getSessionUidColumn()) continue;
                querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(i2, new ColumnReference(tableReference, temporaryTableColumn.getColumnName(), false, null, temporaryTableColumn.getJdbcMapping())));
            }
        } else {
            fkModelPart.forEachSelectable((i, selectableMapping) -> querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(i, new ColumnReference(tableReference, selectableMapping.getSelectionExpression(), false, null, selectableMapping.getJdbcMapping()))));
        }
    }

    private static void applyIdTableRestrictions(QuerySpec querySpec, TableReference idTableReference, TemporaryTable idTable, JdbcParameter sessionUidParameter, ExecutionContext executionContext) {
        if (idTable.getSessionUidColumn() != null) {
            querySpec.applyPredicate(new ComparisonPredicate(new ColumnReference(idTableReference, idTable.getSessionUidColumn().getColumnName(), false, null, idTable.getSessionUidColumn().getJdbcMapping()), ComparisonOperator.EQUAL, sessionUidParameter));
        }
    }

    @Deprecated(forRemoval=true, since="7.1")
    public static void performBeforeTemporaryTableUseActions(TemporaryTable temporaryTable, ExecutionContext executionContext) {
        ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(temporaryTable, executionContext.getSession().getDialect().getTemporaryTableBeforeUseAction(), executionContext);
    }

    public static boolean performBeforeTemporaryTableUseActions(TemporaryTable temporaryTable, TemporaryTableStrategy temporaryTableStrategy, ExecutionContext executionContext) {
        return ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(temporaryTable, temporaryTableStrategy.getTemporaryTableBeforeUseAction(), executionContext);
    }

    private static boolean performBeforeTemporaryTableUseActions(TemporaryTable temporaryTable, BeforeUseAction beforeUseAction, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        if (beforeUseAction == BeforeUseAction.CREATE) {
            TemporaryTableHelper.TemporaryTableCreationWork temporaryTableCreationWork = new TemporaryTableHelper.TemporaryTableCreationWork(temporaryTable, factory);
            TempTableDdlTransactionHandling ddlTransactionHandling = dialect.getTemporaryTableDdlTransactionHandling();
            if (ddlTransactionHandling == TempTableDdlTransactionHandling.NONE) {
                return executionContext.getSession().doReturningWork(temporaryTableCreationWork);
            }
            IsolationDelegate isolationDelegate = executionContext.getSession().getJdbcCoordinator().getJdbcSessionOwner().getTransactionCoordinator().createIsolationDelegate();
            return isolationDelegate.delegateWork(temporaryTableCreationWork, ddlTransactionHandling == TempTableDdlTransactionHandling.ISOLATE_AND_TRANSACT);
        }
        return false;
    }

    public static int[] loadInsertedRowNumbers(TemporaryTable temporaryTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, int rows, ExecutionContext executionContext) {
        String sqlSelect = ExecuteWithTemporaryTableHelper.createInsertedRowNumbersSelectSql(temporaryTable, sessionUidAccess, executionContext);
        return ExecuteWithTemporaryTableHelper.loadInsertedRowNumbers(sqlSelect, temporaryTable, sessionUidAccess, rows, executionContext);
    }

    public static int[] loadInsertedRowNumbers(String sqlSelect, TemporaryTable temporaryTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, int rows, ExecutionContext executionContext) {
        TemporaryTableSessionUidColumn sessionUidColumn = temporaryTable.getSessionUidColumn();
        SharedSessionContractImplementor session = executionContext.getSession();
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = jdbcCoordinator.getStatementPreparer().prepareStatement(sqlSelect);
            if (sessionUidColumn != null) {
                sessionUidColumn.getJdbcMapping().getJdbcValueBinder().bind(preparedStatement, UUID.fromString(sessionUidAccess.apply(session)), 1, (WrapperOptions)session);
            }
            ResultSet resultSet = jdbcCoordinator.getResultSetReturn().execute(preparedStatement, sqlSelect);
            int[] rowNumbers = new int[rows];
            try {
                int rowIndex = 0;
                while (resultSet.next()) {
                    rowNumbers[rowIndex++] = resultSet.getInt(1);
                }
                int[] nArray = rowNumbers;
                return nArray;
            }
            catch (IndexOutOfBoundsException e) {
                try {
                    throw new IllegalArgumentException("Expected " + rows + " to be inserted but found more", e);
                }
                catch (SQLException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        finally {
            if (preparedStatement != null) {
                try {
                    jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(preparedStatement);
                }
                catch (Throwable throwable) {}
                jdbcCoordinator.afterStatementExecution();
            }
        }
    }

    public static String createInsertedRowNumbersSelectSql(TemporaryTable temporaryTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, ExecutionContext executionContext) {
        TemporaryTableSessionUidColumn sessionUidColumn = temporaryTable.getSessionUidColumn();
        TemporaryTableColumn rowNumberColumn = temporaryTable.getColumns().get(temporaryTable.getColumns().size() - (sessionUidColumn == null ? 1 : 2));
        assert (rowNumberColumn != null);
        SharedSessionContractImplementor session = executionContext.getSession();
        SimpleSelect simpleSelect = new SimpleSelect(session.getFactory()).setTableName(temporaryTable.getQualifiedTableName()).addColumn(rowNumberColumn.getColumnName());
        if (sessionUidColumn != null) {
            simpleSelect.addRestriction(sessionUidColumn.getColumnName());
        }
        return simpleSelect.toStatementString();
    }

    public static void performAfterTemporaryTableUseActions(TemporaryTable temporaryTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, AfterUseAction afterUseAction, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        switch (afterUseAction) {
            case CLEAN: {
                TemporaryTableHelper.cleanTemporaryTableRows(temporaryTable, dialect.getTemporaryTableExporter(), sessionUidAccess, executionContext.getSession());
                break;
            }
            case DROP: {
                TemporaryTableHelper.TemporaryTableDropWork temporaryTableDropWork = new TemporaryTableHelper.TemporaryTableDropWork(temporaryTable, factory);
                TempTableDdlTransactionHandling ddlTransactionHandling = dialect.getTemporaryTableDdlTransactionHandling();
                if (ddlTransactionHandling == TempTableDdlTransactionHandling.NONE) {
                    executionContext.getSession().doWork(temporaryTableDropWork);
                    break;
                }
                IsolationDelegate isolationDelegate = executionContext.getSession().getJdbcCoordinator().getJdbcSessionOwner().getTransactionCoordinator().createIsolationDelegate();
                isolationDelegate.delegateWork(temporaryTableDropWork, ddlTransactionHandling == TempTableDdlTransactionHandling.ISOLATE_AND_TRANSACT);
            }
        }
    }
}

