---
stage: Software Supply Chain Security
group: Authorization
info: "To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments"
title: Custom permissions
description: Configure granular permissions with specific abilities for fine-grained access controls.
---

<!--
  This documentation is auto generated by a Rake task.

  Please do not edit this file directly. To update this file, run:
  `bundle exec rake gitlab:custom_roles:compile_docs`

  To make changes to the output of the Rake task,
  edit `tooling/custom_roles/docs/templates/custom_abilities.md.erb`.
-->

{{< history >}}

- Custom admin roles [introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/181346) in GitLab 17.9 [with a flag](../../administration/feature_flags/_index.md) named `custom_admin_roles`. Disabled by default.
- Custom admin roles [generally available](https://gitlab.com/groups/gitlab-org/-/epics/15957) in GitLab 18.3. Feature flag `custom_admin_roles` enabled by default.

{{< /history >}}

You can create a [custom role](_index.md) by adding one or more custom permissions to a base role.

> [!note]
> Some permissions depend on other permissions.
> For example, the `admin_vulnerability` permission requires you to also include the `read_vulnerability` permission.
> Any dependencies are noted in the `Description` column for each permission.

## Admin

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| View CI/CD | Read CI/CD details for runners and jobs in the Admin Area. | [`read_admin_cicd`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177233) | Instance | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/507960) |
| View Groups | Read group details in the Admin Area. | [`read_admin_groups`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197777) | Instance | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/534449) |
| View Projects | Read project details in the Admin Area. | [`read_admin_projects`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197777) | Instance | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/534449) |
| View subscription details | Read subscription details in the Admin area. | [`read_admin_subscription`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178230) | Instance | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/507961) |
| View system monitoring | Read system information such as background migrations, health checks, and Gitaly in the Admin Area. | [`read_admin_monitoring`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179439) | Instance | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/507959) |
| View users | Read the user list and user details in the Admin area. | [`read_admin_users`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177514) | Instance | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/508782) |

## Code review workflow

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Manage merge request approvals and settings | Configure merge request settings at the group or project level. Group actions include managing merge checks and approval settings. Project actions include managing MR configurations, approval rules and settings, and branch targets. In order to enable Suggested reviewers, the "Manage project access tokens" custom permission needs to be enabled. | [`manage_merge_request_settings`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151586) | Group,<br> Project | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/443235) |

## Compliance management

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Manage and assign compliance frameworks | Create, read, update, and delete compliance frameworks. Users with this permission can also assign a compliance framework label to a project, and set the default framework of a group. | [`admin_compliance_framework`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/144183) | Group,<br> Project | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/411502) |
| Read compliance dashboard | Read compliance capabilities including adherence, violations, and frameworks for groups and projects. | [`read_compliance_dashboard`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175066) | Group,<br> Project | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/465324) |

## Continuous delivery

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Manage deploy tokens | Manage deploy tokens at the group or project level. | [`manage_deploy_tokens`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151677) | Group,<br> Project | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/448843) |
| Manage Protected Environments | Create, read, update, and delete protected environments | [`admin_protected_environments`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178283) | Group,<br> Project | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/471385) |

## Groups and projects

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Archive project | Allows archiving of projects. | [`archive_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134998) | Project | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/425957) |
| Delete group | Ability to delete or restore a group. This ability does not allow deleting top-level groups. Review the Retention period settings to prevent accidental deletion. | [`remove_group`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145166) | Group | GitLab [16.10](https://gitlab.com/gitlab-org/gitlab/-/issues/425962) |
| Delete project | Allows deletion of projects. | [`remove_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139696) | Project | GitLab [16.8](https://gitlab.com/gitlab-org/gitlab/-/issues/425959) |
| Manage group members | Add or remove users in a group, and assign roles to users. When assigning a role, users with this custom permission must select a role that has the same or fewer permissions as the default role used as the base for their custom role. | [`admin_group_member`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131914) | Group | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/17364) |

## Infrastructure as code

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Manage Terraform state | Execute terraform commands, lock/unlock terraform state files, and remove file versions. | [`admin_terraform_state`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/140759) | Project | GitLab [16.8](https://gitlab.com/gitlab-org/gitlab/-/issues/421789) |

## Integrations

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Manage integrations | Create, read, update, and delete integrations with external applications. | [`admin_integrations`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154601) | Group,<br> Project | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/460522) |

## Runner

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Manage runners | Create, view, edit, and delete group or project Runners. Includes configuring Runner settings. | [`admin_runners`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151825) | Group,<br> Project | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/442851) |
| View runners | Allows read-only access to group or project runners, including the runner fleet dashboard. | [`read_runners`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156798) | Group,<br> Project | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/468202) |

## Secrets management

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Manage CI/CD variables | Create, read, update, and delete CI/CD variables. | [`admin_cicd_variables`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/143369) | Group,<br> Project | GitLab [16.10](https://gitlab.com/gitlab-org/gitlab/-/issues/437947) |

## Security asset inventories

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Read security scan profiles | Read security scan profiles. | [`read_security_scan_profiles`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/213203) | Group,<br> Project | GitLab [18.7](https://gitlab.com/groups/gitlab-org/-/epics/19802) |

## Security policy management

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Link to a security policy project | Allows linking security policy projects. | [`manage_security_policy_link`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148371) | Group,<br> Project | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/440226) |

## Source code management

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Approve merge request | Allows approval of merge requests. | [`admin_merge_request`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/128302) | Project | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/412708) |
| Manage Protected Branches | Create, read, update, and delete protected branches for a project. | [`admin_protected_branch`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/162208) | Project | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/448823) |
| Manage push rules | Configure push rules for repositories at the group or project level. | [`admin_push_rules`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147872) | Group,<br> Project | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/421786) |
| View repository code | Allows read-only access to the source code in the user interface. Does not allow users to edit or download repository archives, clone or pull repositories, view source code in an IDE, or view merge requests for private projects. You can download individual files because read-only access inherently grants the ability to make a local copy of the file. | [`read_code`](https://gitlab.com/gitlab-org/gitlab/-/issues/376180) | Group,<br> Project | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/20277) |

## System access

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Manage group access tokens | Create, read, update, and delete group access tokens. When creating a token, users with this custom permission must select a role for that token that has the same or fewer permissions as the default role used as the base for the custom role. | [`manage_group_access_tokens`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/140115) | Group | GitLab [16.8](https://gitlab.com/gitlab-org/gitlab/-/issues/428353) |
| Manage project access tokens | Create, read, update, and delete project access tokens. When creating a token, users with this custom permission must select a role for that token that has the same or fewer permissions as the default role used as the base for the custom role. | [`manage_project_access_tokens`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132342) | Project | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/421778) |

## Team planning

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| View CRM contact | Read CRM contact. | [`read_crm_contact`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154017) | Group | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/443268) |

## Vulnerability management

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Manage vulnerabilities | Edit the status, linked issue, and severity of a vulnerability object. Also requires the `read_vulnerability` permission. | [`admin_vulnerability`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121534) | Group,<br> Project | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/412536) |
| View dependency list | Allows read-only access to the dependencies and licenses. | [`read_dependency`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/126247) | Group,<br> Project | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/415255) |
| View vulnerability reports and dashboards | Read vulnerability reports and security dashboards. | [`read_vulnerability`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120704) | Group,<br> Project | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/399119) |

## Webhooks

| Permission | Description | API Attribute | Scope | Introduced |
|:-----------|:------------|:--------------|:------|:-----------|
| Manage web hooks | Manage webhooks | [`admin_web_hook`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/151551) | Group,<br> Project | GitLab [17.0](https://gitlab.com/gitlab-org/quality/triage-ops/-/issues/1373) |
