---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: イシュー
---

{{< details >}}

- プラン:Free、Premium、Ultimate
- 提供形態:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

イシューを使用すると、チームと連携して、GitLabで作業をプラン、追跡、および提供できます。イシュー：

- 機能の提案、タスク、サポートリクエスト、バグレポートを追跡します。
- 担当者、期限、ヘルスステータスを使用して、作業を整理し、優先順位を付けます。
- コメントとスレッド形式のディスカッションを通じて、チームのディスカッションと意思決定を促進します。
- テンプレート、ラベル、エピック、ボードを通じて、カスタムワークフローをサポートします。
- Zoom、Jira、メールサービスなどの外部ツールと統合します。

イシューの詳細については、GitLabのブログ投稿を参照してください。[常にイシューからディスカッションを開始する](https://about.gitlab.com/blog/2016/03/03/start-with-an-issue/)。

イシューは常に特定のプロジェクトに関連付けられています。グループ内に複数のプロジェクトがある場合は、すべてのプロジェクトイシューを一度に表示できます。

<div class="video-fallback">
  動画をご覧ください。<a href="https://www.youtube.com/watch?v=Mt1EzlKToig">イシュー - GitLabで組織をセットアップする</a>。
</div>
<figure class="video-container">
  <iframe src="https://www.youtube-nocookie.com/embed/Mt1EzlKToig" frameborder="0" allowfullscreen> </iframe>
</figure>
<!-- Video published on 2023-10-30 -->

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i> GitLabの戦略的マーケティング部署が[ラベル](../labels.md)と[イシューボード](../issue_board.md)でGitLabイシューをどのように使用するかについては、[イシューによるコミットメントの管理](https://www.youtube.com/watch?v=cuIHNintg1o&t=3)に関する動画をご覧ください。
<!-- Video published on 2020-04-10 -->

## 関連トピック

- [イシューを作成](create_issues.md)
- [テンプレートからイシューを作成する](../description_templates.md#use-the-templates)
- [イシューを編集](managing_issues.md#edit-an-issue)
- [イシューを移動](managing_issues.md#move-an-issue)
- [イシューを完了にする](managing_issues.md#close-an-issue)
- [イシューを削除](managing_issues.md#delete-an-issue)
- [イシューをプロモート](managing_issues.md#promote-an-issue-to-an-epic)
- [期限を設定する](due_dates.md)
- [イシューをインポート](csv_import.md)
- [イシューをエクスポート](csv_export.md)
- [デザインをイシューにアップロード](design_management.md)
- [リンクされたイシュー](related_issues.md)
- [類似イシュー](managing_issues.md#similar-issues)
- [ヘルスステータス](managing_issues.md#health-status)
- [クロスリンクイシュー](crosslinking_issues.md)
- [イシューリストをソート](sorting_issue_lists.md)
- [イシューを検索](managing_issues.md#filter-the-list-of-issues)
- [エピック](../../group/epics/_index.md)
- [イシューボード](../issue_board.md)
- [イシュー API](../../../api/issues.md)
- [外部イシュートラッカーをConfigureする](../../../integration/external-issue-tracker.md)
- [タスク](../../tasks.md)
- [外部参加者](../service_desk/external_participants.md)
