/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.format.tokenized;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.sql.format.SQLFormatter;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.model.sql.format.tokenized.FormatterToken;
import org.jkiss.dbeaver.model.sql.format.tokenized.IndentFormatter;
import org.jkiss.dbeaver.model.sql.format.tokenized.SQLTokensParser;
import org.jkiss.dbeaver.model.sql.format.tokenized.TokenType;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLFormatterTokenized
implements SQLFormatter {
    public static final String FORMATTER_ID = "DEFAULT";
    private static final String[] DML_KEYWORD = new String[]{"SELECT", "UPDATE", "INSERT", "DELETE"};
    private SQLFormatterConfiguration formatterCfg;
    private List<String> statementDelimiters = new ArrayList<String>(2);
    private boolean isCompact;

    @Override
    public String format(String argSql, SQLFormatterConfiguration configuration) {
        this.formatterCfg = configuration;
        for (String delim : this.formatterCfg.getSyntaxManager().getStatementDelimiters()) {
            if (CommonUtils.isEmptyTrimmed((String)delim)) continue;
            this.statementDelimiters.add(delim.toUpperCase(Locale.ENGLISH));
        }
        SQLTokensParser fParser = new SQLTokensParser(this.formatterCfg);
        boolean isSqlEndsWithNewLine = false;
        if (argSql.endsWith("\n")) {
            isSqlEndsWithNewLine = true;
        }
        List<FormatterToken> list = fParser.parse(argSql);
        list = this.format(list);
        StringBuilder after = new StringBuilder(argSql.length() + 20);
        for (FormatterToken token : list) {
            after.append(token.getString());
        }
        if (isSqlEndsWithNewLine) {
            after.append(GeneralUtils.getDefaultLineSeparator());
        }
        return after.toString();
    }

    public boolean isCompact() {
        return this.isCompact;
    }

    public void setCompact(boolean compact) {
        this.isCompact = compact;
    }

    private List<FormatterToken> format(@NotNull List<FormatterToken> argList) {
        if (argList.isEmpty()) {
            return argList;
        }
        if (this.isEmptyAfterSpaceRemoving(argList, 0) || this.isEmptyAfterSpaceRemoving(argList, argList.size() - 1)) {
            return argList;
        }
        this.transformCase(argList);
        if (this.formatterCfg.getPreferenceStore().getBoolean("sql.format.insert.delimiters.in.empty_lines")) {
            this.convertEmptyLinesIntoDelimiters(argList);
        }
        SQLFormatterTokenized.removeSpacesAroundCommentToken(argList);
        this.concatenateDoublewordedKeywords(argList);
        IndentFormatter indentFormatter = new IndentFormatter(this.formatterCfg, this.isCompact);
        indentFormatter.format(argList);
        this.trimSpacesBetweenBraces(argList);
        this.insertSpaces(argList);
        return argList;
    }

    private void insertSpaces(List<FormatterToken> argList) {
        for (int index = 1; index < argList.size(); ++index) {
            FormatterToken prev = argList.get(index - 1);
            FormatterToken token = argList.get(index);
            String prevString = prev.getString();
            String curString = token.getString();
            if (prev.getType() == TokenType.SPACE || token.getType() == TokenType.SPACE || prevString.equals("(") || curString.startsWith("(") || prevString.equals(")") || curString.equals(")") || curString.equals(",") || this.statementDelimiters.contains(curString) || this.formatterCfg.isFunction(prevString) && curString.equals("(") || token.getType() == TokenType.VALUE && prev.getType() == TokenType.NAME || token.getType() == TokenType.SYMBOL && SQLFormatterTokenized.isEmbeddedToken(token) || prev.getType() == TokenType.SYMBOL && SQLFormatterTokenized.isEmbeddedToken(prev) || token.getType() == TokenType.SYMBOL && prev.getType() == TokenType.SYMBOL) continue;
            if ("+".equals(curString) && prevString.length() > 1 && Character.isDigit(prevString.charAt(0)) && (prevString.charAt(prevString.length() - 1) == 'E' || prevString.charAt(prevString.length() - 1) == 'e')) {
                ++index;
                continue;
            }
            argList.add(index, new FormatterToken(TokenType.SPACE, " "));
        }
    }

    private void trimSpacesBetweenBraces(List<FormatterToken> argList) {
        for (int index = argList.size() - 1; index >= 4; --index) {
            if (index >= argList.size()) continue;
            FormatterToken t0 = argList.get(index);
            FormatterToken t1 = argList.get(index - 1);
            FormatterToken t2 = argList.get(index - 2);
            FormatterToken t3 = argList.get(index - 3);
            FormatterToken t4 = argList.get(index - 4);
            if (t4.getString().equals("(") && t3.getString().trim().isEmpty() && t1.getString().trim().isEmpty() && t0.getString().equalsIgnoreCase(")")) {
                t4.setString(t4.getString() + t2.getString() + t0.getString());
                argList.remove(index);
                argList.remove(index - 1);
                argList.remove(index - 2);
                argList.remove(index - 3);
                continue;
            }
            if (t3.getString().equals("(") && t2.getString().trim().isEmpty() && t0.getString().equalsIgnoreCase(")")) {
                t3.setString(t3.getString() + t1.getString() + t0.getString());
                argList.remove(index);
                argList.remove(index - 1);
                argList.remove(index - 2);
                continue;
            }
            if (!t3.getString().equals("(") || !t1.getString().trim().isEmpty() || !t0.getString().equalsIgnoreCase(")")) continue;
            t3.setString(t3.getString() + t2.getString() + t0.getString());
            argList.remove(index);
            argList.remove(index - 1);
            argList.remove(index - 2);
        }
    }

    private void transformCase(List<FormatterToken> argList) {
        DBPIdentifierCase keywordCase = this.formatterCfg.getKeywordCase();
        for (FormatterToken token : argList) {
            if (token.getType() != TokenType.KEYWORD) continue;
            token.setString(keywordCase.transform(token.getString()));
        }
    }

    private boolean isEmptyAfterSpaceRemoving(List<FormatterToken> argList, int tokenPosition) {
        FormatterToken token = argList.get(tokenPosition);
        if (token.getType() == TokenType.SPACE) {
            argList.remove(tokenPosition);
            return argList.isEmpty();
        }
        return false;
    }

    private static void removeSpacesAroundCommentToken(List<? extends FormatterToken> argList) {
        String separator = "\n";
        for (int index = argList.size() - 1; index >= 1; --index) {
            boolean isTokenNotContainsSeparator;
            FormatterToken token = argList.get(index);
            FormatterToken prevToken = argList.get(index - 1);
            boolean bl = isTokenNotContainsSeparator = !token.getString().contains(separator);
            if (prevToken.getType() == TokenType.COMMENT && token.getType() == TokenType.SPACE && isTokenNotContainsSeparator) {
                argList.remove(index);
                continue;
            }
            if (prevToken.getType() == TokenType.SPACE && !prevToken.getString().contains(separator) && token.getType() == TokenType.COMMENT) {
                argList.remove(index - 1);
                continue;
            }
            if (token.getType() != TokenType.SPACE || !isTokenNotContainsSeparator) continue;
            token.setString(" ");
        }
    }

    private void convertEmptyLinesIntoDelimiters(List<FormatterToken> argList) {
        for (int i = 0; i < argList.size(); ++i) {
            FormatterToken token = argList.get(i);
            if (token.getType() != TokenType.SPACE) continue;
            int lfCount = 0;
            for (int k = 0; k < token.getString().length(); ++k) {
                if (token.getString().charAt(k) != '\n') continue;
                ++lfCount;
            }
            if (lfCount <= 1 || i > 0 && this.statementDelimiters.contains(argList.get(i - 1).getString())) continue;
            argList.add(i, new FormatterToken(TokenType.SYMBOL, this.statementDelimiters.get(0)));
            ++i;
        }
    }

    private void concatenateDoublewordedKeywords(List<FormatterToken> argList) {
        for (int index = 0; index < argList.size() - 2; ++index) {
            FormatterToken t0 = argList.get(index);
            FormatterToken t1 = argList.get(index + 1);
            FormatterToken t2 = argList.get(index + 2);
            String tokenString = t0.getString().toUpperCase(Locale.ENGLISH);
            String token2String = t2.getString().toUpperCase(Locale.ENGLISH);
            if (t0.getType() == TokenType.KEYWORD && t1.getType() == TokenType.SPACE && t2.getType() == TokenType.KEYWORD && ((tokenString.equals("ORDER") || tokenString.equals("GROUP") || tokenString.equals("CONNECT")) && token2String.equals("BY") || tokenString.equals("START") && token2String.equals("WITH"))) {
                t0.setString(t0.getString() + " " + t2.getString());
                argList.remove(index + 1);
                argList.remove(index + 1);
            }
            if (!tokenString.equals("(") || !t1.getString().equals("+") || !token2String.equals(")")) continue;
            t0.setString("(+)");
            argList.remove(index + 1);
            argList.remove(index + 1);
        }
    }

    private static String getPrevDMLKeyword(List<FormatterToken> argList, int index) {
        for (int i = index - 1; i >= 0; --i) {
            FormatterToken token = argList.get(i);
            if (token.getType() != TokenType.KEYWORD || !ArrayUtils.contains((Object[])DML_KEYWORD, (Object)token.getString())) continue;
            return token.getString();
        }
        return null;
    }

    private static boolean isEmbeddedToken(FormatterToken token) {
        switch (token.getString()) {
            case ":": 
            case ".": 
            case ">": 
            case "<": 
            case "[": 
            case "]": 
            case "#": 
            case "-": 
            case "'": 
            case "%": 
            case "\"": 
            case "`": {
                return true;
            }
        }
        return false;
    }
}

