/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class ProjectSelectorPanel {
    private Label headerLabel;
    private DBPProject selectedProject;

    public ProjectSelectorPanel(@NotNull Composite parent, @Nullable DBPProject activeProject, int style) {
        this(parent, activeProject, style, false, true);
    }

    public ProjectSelectorPanel(@NotNull Composite parent, @Nullable DBPProject activeProject, int style, boolean showOnlyEditable) {
        this(parent, activeProject, style, showOnlyEditable, true);
    }

    public ProjectSelectorPanel(@NotNull Composite parent, @Nullable DBPProject activeProject, int style, boolean showOnlyEditable, boolean alignRight) {
        final ArrayList<DBPProject> projects = new ArrayList<DBPProject>(DBWorkbench.getPlatform().getWorkspace().getProjects());
        projects.sort((o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName()));
        if (showOnlyEditable) {
            projects.removeIf(p -> !p.hasRealmPermission("project-datasource-edit"));
        }
        if (projects.size() == 1) {
            this.selectedProject = (DBPProject)projects.getFirst();
        } else if (projects.size() > 1) {
            boolean showIcon = (style & 1) != 0;
            Composite projectGroup = UIUtils.createComposite((Composite)parent, (int)(showIcon ? 3 : 2));
            projectGroup.setLayoutData((Object)new GridData(alignRight ? 128 : 32));
            if (showIcon) {
                new Label(projectGroup, 0).setImage(DBeaverIcons.getImage((DBPImage)DBIcon.PROJECT));
            }
            this.headerLabel = UIUtils.createControlLabel((Composite)projectGroup, (String)UIConnectionMessages.dialog_connection_driver_project);
            final Combo projectCombo = new Combo(projectGroup, 12);
            projectCombo.setLayoutData((Object)new GridData(32));
            for (DBPProject project : projects) {
                projectCombo.add(project.getName());
            }
            if (this.selectedProject == null) {
                this.selectedProject = activeProject;
                if (this.selectedProject == null) {
                    this.selectedProject = NavigatorUtils.getSelectedProject();
                }
                if (!projects.contains(this.selectedProject)) {
                    this.selectedProject = (DBPProject)projects.getFirst();
                }
            }
            projectCombo.setText(this.selectedProject.getName());
            projectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ProjectSelectorPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$0.selectedProject = (DBPProject)projects.get(projectCombo.getSelectionIndex());
                    this.this$0.onProjectChange();
                }
            });
        }
    }

    protected void onProjectChange() {
    }

    @Nullable
    public DBPProject getSelectedProject() {
        return this.selectedProject;
    }

    public void setLabel(String text) {
        this.headerLabel.setText(text);
    }
}

