/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBInfoUtils;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.navigator.itemlist.ItemListControl;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ObjectInformationView {
    private static final Log log = Log.getLog(ObjectInformationView.class);
    private Composite infoComposite;
    private Object input;
    private Composite tableComposite;
    private Composite mainComposite;
    private ItemListControl itemListControl;

    @NotNull
    public Control createContent(@NotNull Composite parent) {
        GridData mainGridData = new GridData(1808);
        this.mainComposite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.mainComposite.setLayoutData((Object)mainGridData);
        GridData infoGridData = new GridData(768);
        this.infoComposite = UIUtils.createPlaceholder((Composite)this.mainComposite, (int)1);
        this.infoComposite.setLayoutData((Object)infoGridData);
        this.tableComposite = UIUtils.createPlaceholder((Composite)this.mainComposite, (int)1);
        this.tableComposite.setLayoutData((Object)mainGridData);
        return this.mainComposite;
    }

    public boolean hasContents() {
        return this.input != null;
    }

    public void setInput(@NotNull Object input) {
        this.input = input;
        if (input instanceof DBPNamedObject) {
            DBPNamedObject namedObject = (DBPNamedObject)input;
            if (!this.infoComposite.isDisposed() && !this.tableComposite.isDisposed()) {
                this.createMetadataFields(namedObject);
                if (input instanceof DBSTable) {
                    DBSTable table = (DBSTable)input;
                    this.createTreeControl(table);
                }
            }
        }
    }

    private void createMetadataFields(final @NotNull DBPNamedObject input) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginTop = 0;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        final Composite metadataComposite = new Composite(this.infoComposite, 0);
        metadataComposite.setLayout((Layout)layout);
        metadataComposite.setLayoutData((Object)new GridData(768));
        final DBPNamedObject[] targetObject = new DBPNamedObject[]{input};
        AbstractJob resolveObject = new AbstractJob(this, "Resolving object"){

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                if (input instanceof DBSObjectReference) {
                    DBSObjectReference objectReference = (DBSObjectReference)input;
                    try {
                        targetObject[0] = objectReference.resolveObject(monitor);
                    }
                    catch (DBException e) {
                        log.error((Object)"Error resolving object", (Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        resolveObject.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(this){
            final /* synthetic */ ObjectInformationView this$0;
            {
                this.this$0 = this$0;
            }

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                UIUtils.syncExec(() -> {
                    if (!(metadataComposite.isDisposed() || this.this$0.infoComposite.isDisposed() || this.this$0.mainComposite.isDisposed())) {
                        PropertyCollector collector = new PropertyCollector((Object)targetObject[0], false);
                        collector.collectProperties();
                        int maxWidth = 0;
                        GC gc = new GC((Drawable)metadataComposite);
                        try {
                            gc.setFont(BaseThemeSettings.instance.baseFontBold);
                            for (DBPPropertyDescriptor descriptor : collector.getProperties()) {
                                String propertyString = DBInfoUtils.getPropertyString((PropertyCollector)collector, (DBPPropertyDescriptor)descriptor);
                                if (CommonUtils.isEmpty((String)propertyString) || !descriptor.hasFeature("viewable")) continue;
                                Composite placeholder = UIUtils.createPlaceholder((Composite)metadataComposite, (int)2);
                                placeholder.setLayoutData((Object)new GridData(32));
                                Label label = new Label(placeholder, 8);
                                label.setText(descriptor.getDisplayName() + ":");
                                label.setFont(BaseThemeSettings.instance.baseFontBold);
                                Text valueText = new Text(placeholder, 8);
                                valueText.setText(propertyString);
                                maxWidth = Math.max(maxWidth, gc.stringExtent((String)label.getText()).x + gc.stringExtent((String)valueText.getText()).x);
                            }
                        }
                        finally {
                            gc.dispose();
                        }
                        int extraWidth = maxWidth;
                        this.this$0.infoComposite.layout(true, true);
                        this.this$0.mainComposite.layout(true, true);
                        UIUtils.asyncExec(() -> {
                            if (!this.this$0.mainComposite.isDisposed()) {
                                Shell shell = this.this$0.mainComposite.getShell();
                                Point sz = shell.getMinimumSize();
                                shell.setMinimumSize(sz.x + extraWidth, sz.y + metadataComposite2.getSize().y);
                                this.this$0.mainComposite.getShell().layout(true, true);
                            }
                        });
                    }
                });
            }
        });
        resolveObject.schedule();
    }

    private void createTreeControl(@NotNull DBSTable input) {
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 0;
        gridData.verticalSpan = 0;
        SubEditorSite subSite = new SubEditorSite(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite());
        final DBNDatabaseNode node = DBWorkbench.getPlatform().getNavigatorModel().findNode((DBSObject)input);
        this.itemListControl = new ItemListControl(this, this.tableComposite, 0, (IWorkbenchSite)subSite, (DBNNode)node, null){

            @NotNull
            protected String getListConfigId(List<Class<?>> classList) {
                return "Suggestion/" + super.getListConfigId(classList);
            }
        };
        this.itemListControl.setLayoutData((Object)gridData);
        final Object[] columnNodes = new Object[1];
        AbstractJob abstractJob = new AbstractJob(this, "Populating table tip columns"){
            final /* synthetic */ ObjectInformationView this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                monitor.beginTask("Load table columns", 1);
                try {
                    columnNodes[0] = this.this$0.getColumnNodes(monitor, (DBNNode)node);
                }
                catch (DBException e) {
                    log.error((Object)"Error reading table columns", (Throwable)e);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        abstractJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(this){
            final /* synthetic */ ObjectInformationView this$0;
            {
                this.this$0 = this$0;
            }

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    return;
                }
                UIUtils.syncExec(() -> {
                    if (this.this$0.itemListControl != null && !this.this$0.itemListControl.isDisposed()) {
                        Collection columnNodeList = (Collection)columnNodes[0];
                        if (CommonUtils.isEmpty((Collection)columnNodeList)) {
                            this.this$0.itemListControl.dispose();
                        } else {
                            this.this$0.itemListControl.appendListData(columnNodeList);
                            for (int i = 0; i < this.this$0.itemListControl.getColumnController().getColumnsCount(); ++i) {
                                this.this$0.itemListControl.getColumnController().setIsColumnVisible(i, false);
                            }
                            this.this$0.itemListControl.setIsColumnVisibleById("ordinalPosition", true);
                            this.this$0.itemListControl.setIsColumnVisibleById("name", true);
                            this.this$0.itemListControl.setIsColumnVisibleById("fullTypeName", true);
                            this.this$0.itemListControl.setIsColumnVisibleById("identity", true);
                            this.this$0.itemListControl.setIsColumnVisibleById("description", true);
                            this.this$0.itemListControl.getColumnController().createColumns(false);
                            this.this$0.itemListControl.getItemsViewer().refresh();
                            this.this$0.itemListControl.getColumnController().autoSizeColumns();
                        }
                        this.this$0.tableComposite.layout(true, true);
                        UIUtils.asyncExec(() -> {
                            Shell shell = this.this$0.tableComposite.getShell();
                            Point sz = shell.getMinimumSize();
                            int extraHeight = ((Table)this.this$0.itemListControl.getItemsViewer().getControl()).getHeaderHeight();
                            shell.setMinimumSize(sz.x, Math.min(sz.y + UIUtils.getFontHeight((Font)BaseThemeSettings.instance.baseFontBold) * columnNodeList.size() + extraHeight, 600));
                            this.this$0.tableComposite.getShell().layout(true, true);
                        });
                    }
                });
            }
        });
        abstractJob.schedule();
    }

    @NotNull
    private Collection<DBNNode> getColumnNodes(@NotNull DBRProgressMonitor monitor, @Nullable DBNNode node) throws DBException {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<DBNNode> children = new ArrayList<DBNNode>();
        for (DBNNode child : ArrayUtils.safeArray((Object[])node.getChildren(monitor))) {
            if (child instanceof DBNDatabaseFolder) {
                DBNNode[] folderChildren;
                DBNDatabaseFolder databaseFolder = (DBNDatabaseFolder)child;
                Class childrenClass = databaseFolder.getChildrenClass();
                if (childrenClass == null || !DBSTableColumn.class.isAssignableFrom(childrenClass)) continue;
                if (this.itemListControl != null && !this.itemListControl.isDisposed()) {
                    this.itemListControl.setRootNode(child);
                }
                if ((folderChildren = child.getChildren(monitor)) == null) continue;
                children.addAll(List.of(folderChildren));
                continue;
            }
            children.add(child);
        }
        return children;
    }
}

