/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBInfoUtils;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPInformationProvider;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWHandlerRegistry;
import org.jkiss.dbeaver.model.net.DBWUtils;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.secret.DBSSecretValue;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataSourceUtils {
    public static final String PARAM_ID = "id";
    public static final String PARAM_DRIVER = "driver";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_URL = "url";
    public static final String PARAM_HOST = "host";
    public static final String PARAM_PORT = "port";
    public static final String PARAM_SERVER = "server";
    public static final String PARAM_DATABASE = "database";
    public static final String PARAM_USER = "user";
    public static final String PROP_JUMP_SERVER = "jumpServer";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_SAVE_PASSWORD = "savePassword";
    private static final String PARAM_AUTH_MODEL = "auth";
    private static final String PARAM_SHOW_SYSTEM_OBJECTS = "showSystemObjects";
    private static final String PARAM_SHOW_UTILITY_OBJECTS = "showUtilityObjects";
    private static final String PARAM_SHOW_ONLY_ENTITIES = "showOnlyEntities";
    private static final String PARAM_HIDE_FOLDERS = "hideFolders";
    private static final String PARAM_HIDE_SCHEMAS = "hideSchemas";
    private static final String PARAM_MERGE_ENTITIES = "mergeEntities";
    private static final String PARAM_FOLDER = "folder";
    private static final String PARAM_AUTO_COMMIT = "autoCommit";
    private static final String PARAM_CREATE = "create";
    public static final String PARAM_SAVE = "save";
    private static final String PREFIX_HANDLER = "handler.";
    private static final String PREFIX_NET_HANDLER = "netHandler.";
    private static final String PREFIX_PROP = "prop.";
    private static final String PREFIX_AUTH_PROP = "authProp.";
    private static final String PREFIX_ADVANCED_PROP = "advProp.";
    private static final Log log = Log.getLog(DataSourceUtils.class);

    /*
     * WARNING - void declaration
     */
    public static DBPDataSourceContainer getDataSourceBySpec(@NotNull DBPProject project, @NotNull String connectionSpec, @Nullable GeneralUtils.IParameterHandler parameterHandler, boolean searchByParameters, boolean createNewDataSource) {
        String driverName = null;
        String url = null;
        String host = null;
        String port = null;
        String server = null;
        String database = null;
        String user = null;
        String password = null;
        String authModelId = null;
        boolean showSystemObjects = false;
        boolean showUtilityObjects = false;
        boolean showOnlyEntities = false;
        boolean hideFolders = false;
        boolean hideSchemas = false;
        boolean mergeEntities = false;
        boolean savePassword = true;
        boolean isTemporary = true;
        Boolean autoCommit = null;
        HashMap<String, String> conProperties = new HashMap<String, String>();
        HashMap<String, Map> handlerProps = new HashMap<String, Map>();
        HashMap<String, String> authProperties = new HashMap<String, String>();
        HashMap<String, String> handlerUpdateParams = new HashMap<String, String>();
        HashMap<String, String> advancedProperties = new HashMap<String, String>();
        DBPDataSourceFolder folder = null;
        String dsId = null;
        Object dsName = null;
        String dsIdOrName = null;
        DBPDataSourceRegistry dsRegistry = project.getDataSourceRegistry();
        String[] conParams = connectionSpec.split("\\|");
        if (conParams.length == 1 && conParams[0].indexOf(61) == -1) {
            dsIdOrName = conParams[0];
        } else {
            void var36_41;
            String[] stringArray = conParams;
            int n = stringArray.length;
            boolean bl = false;
            while (var36_41 < n) {
                String cp = stringArray[var36_41];
                int divPos = cp.indexOf(61);
                if (divPos != -1) {
                    Object paramName = cp.substring(0, divPos);
                    String string = cp.substring(divPos + 1);
                    switch (paramName) {
                        case "id": {
                            dsId = string;
                            break;
                        }
                        case "driver": {
                            driverName = string;
                            break;
                        }
                        case "name": {
                            dsName = string;
                            break;
                        }
                        case "url": {
                            url = string;
                            break;
                        }
                        case "host": {
                            host = string;
                            break;
                        }
                        case "port": {
                            port = string;
                            break;
                        }
                        case "server": {
                            server = string;
                            break;
                        }
                        case "database": {
                            database = string;
                            break;
                        }
                        case "user": {
                            user = string;
                            break;
                        }
                        case "password": {
                            password = string;
                            break;
                        }
                        case "auth": {
                            authModelId = string;
                            break;
                        }
                        case "savePassword": {
                            savePassword = CommonUtils.toBoolean((Object)string);
                            break;
                        }
                        case "showSystemObjects": {
                            showSystemObjects = CommonUtils.toBoolean((Object)string);
                            break;
                        }
                        case "showUtilityObjects": {
                            showUtilityObjects = CommonUtils.toBoolean((Object)string);
                            break;
                        }
                        case "showOnlyEntities": {
                            showOnlyEntities = CommonUtils.toBoolean((Object)string);
                            break;
                        }
                        case "hideFolders": {
                            hideFolders = CommonUtils.toBoolean((Object)string);
                            break;
                        }
                        case "hideSchemas": {
                            hideSchemas = CommonUtils.toBoolean((Object)string);
                            break;
                        }
                        case "mergeEntities": {
                            mergeEntities = CommonUtils.toBoolean((Object)string);
                            break;
                        }
                        case "folder": {
                            folder = dsRegistry.getFolder(string);
                            break;
                        }
                        case "autoCommit": {
                            autoCommit = CommonUtils.toBoolean((Object)string);
                            break;
                        }
                        case "create": {
                            createNewDataSource = CommonUtils.toBoolean((Object)string);
                            if (parameterHandler == null) break;
                            parameterHandler.setParameter((String)paramName, string);
                            break;
                        }
                        case "save": {
                            isTemporary = !CommonUtils.toBoolean((Object)string);
                            break;
                        }
                        default: {
                            boolean handled = false;
                            if (((String)paramName).length() > PREFIX_PROP.length() && ((String)paramName).startsWith(PREFIX_PROP)) {
                                paramName = ((String)paramName).substring(PREFIX_PROP.length());
                                conProperties.put((String)paramName, string);
                                handled = true;
                            } else if (((String)paramName).length() > PREFIX_AUTH_PROP.length() && ((String)paramName).startsWith(PREFIX_AUTH_PROP)) {
                                paramName = ((String)paramName).substring(PREFIX_AUTH_PROP.length());
                                authProperties.put((String)paramName, string);
                                handled = true;
                            } else if (((String)paramName).length() > PREFIX_HANDLER.length() && ((String)paramName).startsWith(PREFIX_HANDLER)) {
                                divPos = ((String)(paramName = ((String)paramName).substring(PREFIX_HANDLER.length()))).indexOf(46);
                                if (divPos == -1) {
                                    log.debug("Wrong handler parameter: '" + (String)paramName + "'");
                                    break;
                                }
                                String handlerId = ((String)paramName).substring(0, divPos);
                                paramName = ((String)paramName).substring(divPos + 1);
                                Map handlerPopMap = handlerProps.computeIfAbsent(handlerId, k -> new HashMap());
                                handlerPopMap.put(paramName, string);
                                handled = true;
                            } else if (((String)paramName).startsWith(PREFIX_ADVANCED_PROP)) {
                                suffix = ((String)paramName).substring(PREFIX_ADVANCED_PROP.length());
                                if (!suffix.isEmpty()) {
                                    advancedProperties.put(suffix, string);
                                    handled = true;
                                }
                            } else if (((String)paramName).startsWith(PREFIX_NET_HANDLER)) {
                                suffix = ((String)paramName).substring(PREFIX_NET_HANDLER.length());
                                if (!suffix.isEmpty()) {
                                    handlerUpdateParams.put(suffix, string);
                                    handled = true;
                                }
                            } else if (parameterHandler != null) {
                                handled = parameterHandler.setParameter((String)paramName, string);
                            }
                            if (handled) break;
                            log.debug("Unknown connection parameter '" + (String)paramName + "'");
                        }
                    }
                }
                ++var36_41;
            }
        }
        DBPDataSourceContainer dataSource = null;
        if (dsId != null) {
            dataSource = dsRegistry.getDataSource(dsId);
        } else if (dsName != null) {
            dataSource = dsRegistry.findDataSourceByName((String)dsName);
        }
        if (dataSource == null && dsIdOrName != null) {
            dataSource = dsRegistry.getDataSource(dsIdOrName);
            if (dataSource == null) {
                dataSource = dsRegistry.findDataSourceByName(dsIdOrName);
            }
            if (dataSource == null) {
                log.error("Datasource '" + dsIdOrName + "' not found in project '" + project.getName() + "'");
                return null;
            }
        }
        if (dataSource != null) {
            DBPConnectionConfiguration connConfig = dataSource.getConnectionConfiguration();
            if (!CommonUtils.isEmpty(database)) {
                connConfig.setDatabaseName(database);
            }
            if (!CommonUtils.isEmpty(user)) {
                connConfig.setUserName(user);
            }
            if (!CommonUtils.isEmpty(password)) {
                connConfig.setUserPassword(password);
            }
            if (!CommonUtils.isEmpty(conProperties)) {
                connConfig.setProperties(conProperties);
            }
            if (!CommonUtils.isEmpty(authProperties)) {
                connConfig.setAuthProperties(authProperties);
            }
            if (!CommonUtils.isEmpty(advancedProperties)) {
                connConfig.setProviderProperties(advancedProperties);
            }
            if (!CommonUtils.isEmpty((String)authModelId)) {
                connConfig.setAuthModelId(authModelId);
            }
            if (!CommonUtils.isEmpty(handlerUpdateParams)) {
                try {
                    DataSourceUtils.processNetworkHandlerProperties(dataSource, savePassword, handlerUpdateParams);
                }
                catch (DBException dBException) {
                    log.error("Error applying network handler properties", dBException);
                }
            }
            return dataSource;
        }
        if (searchByParameters) {
            if (url != null) {
                for (DBPDataSourceContainer dBPDataSourceContainer : dsRegistry.getDataSources()) {
                    if (!url.equals(dBPDataSourceContainer.getConnectionConfiguration().getUrl()) || user != null && !user.equals(dBPDataSourceContainer.getConnectionConfiguration().getUserName())) continue;
                    return dBPDataSourceContainer;
                }
            } else {
                for (DBPDataSourceContainer dBPDataSourceContainer : dsRegistry.getDataSources()) {
                    DBPConnectionConfiguration cfg = dBPDataSourceContainer.getConnectionConfiguration();
                    if (server != null && !server.equals(cfg.getServerName()) || host != null && !host.equals(cfg.getHostName()) || port != null && !port.equals(cfg.getHostPort()) || database != null && !database.equals(cfg.getDatabaseName()) || user != null && !user.equals(cfg.getUserName())) continue;
                    boolean matched = true;
                    if (!conProperties.isEmpty()) {
                        for (Map.Entry entry : conProperties.entrySet()) {
                            if (CommonUtils.equalObjects((Object)cfg.getProperty((String)entry.getKey()), entry.getValue())) continue;
                            matched = false;
                            break;
                        }
                        if (!matched) continue;
                    }
                    if (!handlerProps.isEmpty()) {
                        for (Map.Entry entry : handlerProps.entrySet()) {
                            DBWHandlerConfiguration handler = cfg.getHandler((String)entry.getKey());
                            if (handler == null) {
                                matched = false;
                                break;
                            }
                            for (Map.Entry prop : ((Map)entry.getValue()).entrySet()) {
                                if (CommonUtils.equalObjects((Object)handler.getProperty((String)prop.getKey()), prop.getValue())) continue;
                                matched = false;
                                break;
                            }
                            if (matched) continue;
                            break;
                        }
                        if (!matched) continue;
                    }
                    return dBPDataSourceContainer;
                }
            }
        }
        if (!createNewDataSource) {
            return null;
        }
        if (driverName == null) {
            log.error("Driver name not specified - can't create new datasource");
            return null;
        }
        DBPDriver driver = DBWorkbench.getPlatform().getDataSourceProviderRegistry().findDriver(driverName);
        if (driver == null) {
            log.error("Driver '" + driverName + "' not found");
            return null;
        }
        if (dsName == null) {
            dsName = "Ext: " + driver.getName();
            if (database != null) {
                dsName = (String)dsName + " - " + database;
            } else if (server != null) {
                dsName = (String)dsName + " - " + server;
            }
        }
        DBPConnectionConfiguration dBPConnectionConfiguration = new DBPConnectionConfiguration();
        dBPConnectionConfiguration.setUrl(url);
        dBPConnectionConfiguration.setHostName(host);
        dBPConnectionConfiguration.setHostPort(port);
        dBPConnectionConfiguration.setServerName(server);
        dBPConnectionConfiguration.setDatabaseName(database);
        dBPConnectionConfiguration.setUserName(user);
        dBPConnectionConfiguration.setUserPassword(password);
        dBPConnectionConfiguration.setProperties(conProperties);
        dBPConnectionConfiguration.setProviderProperties(advancedProperties);
        if (!CommonUtils.isEmpty(authProperties)) {
            dBPConnectionConfiguration.setAuthProperties(authProperties);
        }
        if (!CommonUtils.isEmpty((String)authModelId)) {
            dBPConnectionConfiguration.setAuthModelId(authModelId);
        }
        if (autoCommit != null) {
            dBPConnectionConfiguration.getBootstrap().setDefaultAutoCommit(autoCommit);
        }
        Object newDS = dsRegistry.createDataSource(driver, dBPConnectionConfiguration);
        newDS.setName((String)dsName);
        newDS.setTemporary(isTemporary);
        if (savePassword) {
            newDS.setSavePassword(true);
        }
        if (folder != null) {
            newDS.setFolder(folder);
        }
        DBNBrowseSettings navSettings = newDS.getNavigatorSettings();
        navSettings.setShowSystemObjects(showSystemObjects);
        navSettings.setShowUtilityObjects(showUtilityObjects);
        navSettings.setShowOnlyEntities(showOnlyEntities);
        navSettings.setHideSchemas(hideSchemas);
        navSettings.setHideFolders(hideFolders);
        navSettings.setMergeEntities(mergeEntities);
        if (!CommonUtils.isEmpty(handlerUpdateParams)) {
            try {
                DataSourceUtils.processNetworkHandlerProperties(newDS, savePassword, handlerUpdateParams);
            }
            catch (DBException e) {
                log.error("Error applying network handler properties", e);
            }
        }
        try {
            dsRegistry.addDataSource((DBPDataSourceContainer)newDS);
        }
        catch (DBException e) {
            log.error(e);
        }
        return newDS;
    }

    @NotNull
    public static String getDataSourceAddressText(DBPDataSourceContainer dataSourceContainer) {
        DBPInformationProvider dbpInformationProvider;
        String objectInformation;
        DBPDataSourceProvider dataSourceProvider;
        if (dataSourceContainer.getDriver().isCustomEndpointInformation() && (dataSourceProvider = dataSourceContainer.getDriver().getDataSourceProvider()) instanceof DBPInformationProvider && !CommonUtils.isEmpty((String)(objectInformation = (dbpInformationProvider = (DBPInformationProvider)((Object)dataSourceProvider)).getObjectInformation(dataSourceContainer, "targetAddress")))) {
            return objectInformation;
        }
        DBPConnectionConfiguration cfg = dataSourceContainer.getConnectionConfiguration();
        if (cfg.getConfigurationType() == DBPDriverConfigurationType.MANUAL) {
            String hostText = DBWUtils.getTargetTunnelHostName(dataSourceContainer, cfg);
            String hostPort = cfg.getHostPort();
            String serverName = cfg.getServerName();
            if (CommonUtils.isNotEmpty((String)hostPort)) {
                return hostText + ":" + hostPort;
            }
            if (CommonUtils.isNotEmpty((String)hostText)) {
                return hostText;
            }
            return CommonUtils.notEmpty((String)serverName);
        }
        return cfg.getUrl();
    }

    public static boolean isFolderHasTemporaryDataSources(DBPDataSourceFolder folder) {
        return folder.getDataSourceRegistry().getDataSources().stream().anyMatch(d -> d.getFolder() == folder && d.isTemporary());
    }

    @NotNull
    public static String getJumpServerSettingsPrefix(int index) {
        return PROP_JUMP_SERVER + index + ".";
    }

    public static String getSubjectFromSecret(DBSSecretValue secret) {
        String subjectId = secret.getSubjectId();
        return subjectId == null ? secret.getDisplayName() : subjectId;
    }

    public static String getUserNameFromSecret(DBSSecretValue secret) {
        Object userName;
        Map secretMap = (Map)DBInfoUtils.SECRET_GSON.fromJson(secret.getValue(), new TypeToken<Map<String, Object>>(){}.getType());
        if (secretMap != null && (userName = secretMap.get(PARAM_USER)) != null) {
            return userName.toString();
        }
        return "......";
    }

    public static void processNetworkHandlerProperties(@NotNull DBPDataSourceContainer dataSource, boolean savePassword, @Nullable Map<String, String> handlerParams) throws DBException {
        if (CommonUtils.isEmpty(handlerParams)) {
            return;
        }
        DBWHandlerRegistry handlerRegistry = DBWorkbench.getPlatform().getNetworkHandlerRegistry();
        Map<String, DBWHandlerDescriptor> availableHandlers = handlerRegistry.getDescriptors(dataSource.getDriver()).stream().collect(Collectors.toMap(DBWHandlerDescriptor::getPrefix, h -> h));
        HashSet<String> prefixes = new HashSet<String>();
        ArrayList<String> unknownParams = new ArrayList<String>();
        for (String networkHandlerParam : handlerParams.keySet()) {
            String[] paramParts = networkHandlerParam.split("\\.", 2);
            if (paramParts.length != 2) {
                unknownParams.add(networkHandlerParam);
                continue;
            }
            String prefix = paramParts[0];
            String param = paramParts[1];
            if (!availableHandlers.containsKey(prefix)) {
                unknownParams.add(networkHandlerParam);
                continue;
            }
            prefixes.add(prefix);
        }
        if (!CommonUtils.isEmpty(unknownParams)) {
            throw new DBException("Invalid network handler parameters: " + String.join((CharSequence)", ", unknownParams));
        }
        DBPConnectionConfiguration connectionConfiguration = dataSource.getConnectionConfiguration();
        for (String prefix : prefixes) {
            DBWHandlerDescriptor handlerDescriptor = availableHandlers.get(prefix);
            String handlerPrefix = handlerDescriptor.getPrefix() + ".";
            DBWHandlerConfiguration handlerConfiguration = connectionConfiguration.getHandler(handlerDescriptor.getId());
            if (handlerConfiguration == null) {
                handlerConfiguration = new DBWHandlerConfiguration(handlerDescriptor, dataSource);
            }
            block10: for (DBPPropertyDescriptor propertyDescriptor : handlerDescriptor.getHandlerProperties()) {
                String propId = propertyDescriptor.getId();
                String value = handlerParams.get(propId);
                if (CommonUtils.isEmpty((String)value) && !propId.startsWith(handlerPrefix)) {
                    value = handlerParams.get(handlerPrefix + propId);
                }
                if (CommonUtils.isEmpty((String)value)) {
                    value = CommonUtils.toString((Object)propertyDescriptor.getDefaultValue());
                }
                if (CommonUtils.isEmpty((String)value)) continue;
                switch (propertyDescriptor.getId()) {
                    case "user": {
                        handlerConfiguration.setUserName(value);
                        continue block10;
                    }
                    case "password": {
                        handlerConfiguration.setPassword(value);
                        continue block10;
                    }
                    default: {
                        if (propertyDescriptor.hasFeature("secured")) {
                            handlerConfiguration.setSecureProperty(propertyDescriptor.getId(), value);
                            continue block10;
                        }
                        handlerConfiguration.setProperty(propertyDescriptor.getId(), value);
                    }
                }
            }
            handlerConfiguration.setEnabled(true);
            handlerConfiguration.setSavePassword(savePassword);
            connectionConfiguration.updateHandler(handlerConfiguration);
        }
    }
}

