/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.runtime.DBRFinder;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLCommentScanner;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectRelational;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public final class SQLUtils {
    private static final Log log = Log.getLog(SQLUtils.class);
    public static final Pattern PATTERN_OUT_PARAM = Pattern.compile("((\\?)|(:[a-z0-9]+))\\s*:=");
    public static final Pattern PATTERN_SIMPLE_NAME = Pattern.compile("[a-z][a-z0-9_]*", 2);
    private static final Pattern CREATE_PREFIX_PATTERN = Pattern.compile("(CREATE (:OR REPLACE)?).+", 10);
    private static final int MAX_SQL_DESCRIPTION_LENGTH = 500;
    private static final String DBEAVER_DDL_COMMENT = "-- DDL generated by ";
    private static final String DBEAVER_DDL_WARNING = "-- WARNING: It may differ from actual native database DDL";
    private static final String DBEAVER_SCRIPT_DELIMITER = "$$";

    public static String stripTransformations(String query) {
        return query;
    }

    public static boolean isCommentLine(SQLDialect dialect, String line) {
        for (String slc : dialect.getSingleLineComments()) {
            if (!line.startsWith(slc)) continue;
            return true;
        }
        return false;
    }

    public static String stripComments(@NotNull SQLDialect dialect, @NotNull String query) {
        Pair<String, String> multiLineComments = dialect.getMultiLineComments();
        return SQLUtils.stripComments(query, multiLineComments == null ? null : (String)multiLineComments.getFirst(), multiLineComments == null ? null : (String)multiLineComments.getSecond(), dialect.getSingleLineComments());
    }

    @NotNull
    public static String[] extractComments(@NotNull SQLDialect dialect, @NotNull String query) {
        if (query.isEmpty()) {
            return new String[0];
        }
        SQLCommentScanner scanner = new SQLCommentScanner(dialect.getMultiLineComments(), dialect.getSingleLineComments(), query);
        ArrayList<String> comments = new ArrayList<String>();
        while (scanner.hasNext()) {
            comments.add(scanner.next());
        }
        return comments.toArray(new String[0]);
    }

    public static String stripComments(@NotNull String query, @Nullable String mlCommentStart, @Nullable String mlCommentEnd, String[] slComments) {
        int endPos;
        int startPos;
        for (startPos = 0; startPos < query.length() && Character.isWhitespace(query.charAt(startPos)); ++startPos) {
        }
        for (endPos = query.length() - 1; endPos > startPos && Character.isWhitespace(query.charAt(endPos)); --endPos) {
        }
        String leading = "";
        String trailing = "";
        if (startPos > 0) {
            leading = query.substring(0, startPos);
        }
        if (endPos < query.length() - 1) {
            trailing = query.substring(endPos + 1);
        }
        query = query.trim();
        query = SQLUtils.removeMlComments(query, mlCommentStart, mlCommentEnd);
        query = SQLUtils.removeSlComments(query, slComments);
        if (mlCommentStart != null && query.startsWith(mlCommentStart)) {
            query = SQLUtils.stripComments(query, mlCommentStart, mlCommentEnd, slComments);
        }
        return leading + query + trailing;
    }

    private static String removeMlComments(@NotNull String query, @Nullable String mlCommentStart, @Nullable String mlCommentEnd) {
        if (mlCommentStart != null && mlCommentEnd != null) {
            int startPos = ((String)query).indexOf(mlCommentStart);
            while (startPos != -1) {
                int endPos = ((String)query).indexOf(mlCommentEnd, startPos + mlCommentStart.length());
                if (endPos == -1) {
                    query = ((String)query).substring(0, startPos);
                    break;
                }
                query = ((String)query).substring(0, startPos) + ((String)query).substring(endPos + mlCommentEnd.length());
                startPos = ((String)query).indexOf(mlCommentStart);
            }
        }
        return query;
    }

    private static String removeSlComments(@NotNull String query, String[] slComments) {
        block0: for (String slComment : slComments) {
            while (query.startsWith(slComment)) {
                int crPos = query.indexOf(10);
                if (crPos == -1) {
                    query = "";
                    continue block0;
                }
                query = query.substring(crPos).trim();
            }
        }
        return query;
    }

    public static List<String> splitFilter(String filter) {
        if (CommonUtils.isEmpty((String)filter)) {
            return Collections.emptyList();
        }
        return CommonUtils.splitString((String)filter, (char)',');
    }

    public static boolean matchesAnyLike(String string, Collection<String> likes) {
        for (String like : likes) {
            if (!SQLUtils.matchesLike(string, like)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLikePattern(String like) {
        return like.indexOf(37) != -1 || like.indexOf(42) != -1 || like.indexOf(95) != -1 || like.indexOf(63) != -1;
    }

    @NotNull
    public static String makeLikePattern(@NotNull String like) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < like.length(); ++i) {
            char c = like.charAt(i);
            if (c == '*') {
                result.append(".*");
                continue;
            }
            if (c == '?' || c == '_') {
                result.append(".");
                continue;
            }
            if (c == '%') {
                result.append(".*");
                continue;
            }
            if (Character.isLetterOrDigit(c)) {
                result.append(c);
                continue;
            }
            if (c == '(' || c == ')' || c == '[' || c == ']') {
                result.append('\\').append(c);
                continue;
            }
            if (c == '+' || c == '^' || c == '$' || c == '.' || c == '|' || c == '{' || c == '}') {
                result.append('\\').append(c);
                continue;
            }
            if (c == '\\') {
                if (i >= like.length() - 1) continue;
                char nc = like.charAt(i + 1);
                if (nc == '_' || nc == '*' || nc == '?' || nc == '.' || nc == '%') {
                    result.append("\\").append(nc);
                    ++i;
                    continue;
                }
                result.append("\\");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @NotNull
    public static String makeRegexFromLike(@NotNull String clause) {
        StringBuilder sb = new StringBuilder();
        int length = clause.length();
        for (int index = 0; index < length; ++index) {
            char ch = clause.charAt(index);
            if (ch == '%') {
                if (index <= 0 || index >= length - 1) continue;
                sb.append(".*");
                continue;
            }
            if (index == 0) {
                sb.append('^');
            }
            sb.append(ch == '_' ? (char)'.' : (char)ch);
            if (index != length - 1) continue;
            sb.append('$');
        }
        return sb.toString();
    }

    public static String makeSQLLike(String like) {
        return like.replace("*", "%").replace("?", "_");
    }

    public static String makeGlobFromSqlLikePattern(@NotNull String sqlLikePattern) {
        StringBuilder result = new StringBuilder();
        block5: for (int i = 0; i < sqlLikePattern.length(); ++i) {
            char charAtI = sqlLikePattern.charAt(i);
            switch (charAtI) {
                case '_': {
                    result.append('?');
                    continue block5;
                }
                case '%': {
                    result.append('*');
                    continue block5;
                }
                case '?': {
                    result.append("\\?");
                    continue block5;
                }
                default: {
                    result.append(charAtI);
                }
            }
        }
        return result.toString();
    }

    public static boolean matchesLike(String string, String like) {
        Pattern pattern = Pattern.compile(SQLUtils.makeLikePattern(like), 10);
        return pattern.matcher(string).matches();
    }

    public static void appendValue(StringBuilder buffer, DBSTypedObject type, Object value) {
        if (type.getDataKind() == DBPDataKind.NUMERIC || type.getDataKind() == DBPDataKind.BOOLEAN) {
            buffer.append(value);
        } else {
            buffer.append('\'').append(value).append('\'');
        }
    }

    public static boolean isStringQuoted(DBSObject object, String string) {
        return object.getDataSource().getSQLDialect().isQuotedString(string);
    }

    public static String quoteString(DBSObject object, String string) {
        return SQLUtils.quoteString(object.getDataSource(), string);
    }

    public static String quoteString(DBPDataSource dataSource, String string) {
        return dataSource.getSQLDialect().getQuotedString(string);
    }

    public static String escapeString(DBPDataSource dataSource, String string) {
        return dataSource.getSQLDialect().escapeString(string);
    }

    public static String unQuoteString(DBPDataSource dataSource, String string) {
        if (string.length() > 1 && string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            return dataSource.getSQLDialect().unEscapeString(string.substring(1, string.length() - 1));
        }
        return string;
    }

    public static String getFirstKeyword(SQLDialect dialect, String query) {
        int i;
        query = SQLUtils.stripComments(dialect, query);
        int startPos = 0;
        int endPos = -1;
        for (i = 0; i < query.length(); ++i) {
            if (!Character.isLetterOrDigit(query.charAt(i))) continue;
            startPos = i;
            break;
        }
        for (i = startPos; i < query.length(); ++i) {
            if (!Character.isWhitespace(query.charAt(i))) continue;
            endPos = i;
            break;
        }
        if (endPos == -1) {
            return query;
        }
        return query.substring(startPos, endPos);
    }

    @Nullable
    public static String getQueryOutputParameter(DBCSession session, String query) {
        Matcher matcher = PATTERN_OUT_PARAM.matcher(query);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String makeUnifiedLineFeeds(DBPDataSource dataSource, String query) {
        SQLDialect dialect = SQLUtils.getDialectFromDataSource(dataSource);
        if (!dialect.isCRLFBroken()) {
            return query;
        }
        if (query.indexOf(13) == -1) {
            return query;
        }
        StringBuilder result = new StringBuilder(query.length());
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (c == '\r') continue;
            result.append(c);
        }
        return result.toString();
    }

    public static void appendLikeCondition(@NotNull StringBuilder sql, @NotNull String value, boolean not, @Nullable SQLDialect dialect) {
        if ((value = SQLUtils.makeSQLLike(value)).contains("%") || value.contains("_")) {
            if (not) {
                sql.append(" NOT");
            }
            sql.append(" LIKE ?");
            if (dialect instanceof SQLDialectRelational && ((SQLDialectRelational)dialect).getLikeEscapeClause("\\") != null) {
                sql.append(((SQLDialectRelational)dialect).getLikeEscapeClause("\\"));
            }
        } else {
            sql.append(not ? "<>?" : "=?");
        }
    }

    public static boolean appendFirstClause(StringBuilder sql, boolean firstClause) {
        if (firstClause) {
            sql.append(" WHERE ");
        } else {
            sql.append(" AND ");
        }
        return false;
    }

    public static String trimQueryStatement(SQLSyntaxManager syntaxManager, String sql, boolean trimDelimiter) {
        if (sql.isEmpty() || !trimDelimiter) {
            return sql;
        }
        String trailingSpaces = "";
        int trailingSpacesCount = 0;
        for (int i = sql.length() - 1; i >= 0 && Character.isWhitespace(sql.charAt(i)); --i) {
            ++trailingSpacesCount;
        }
        if (trailingSpacesCount > 0) {
            trailingSpaces = sql.substring(sql.length() - trailingSpacesCount);
            sql = sql.substring(0, sql.length() - trailingSpacesCount);
        }
        for (String statementDelimiter : syntaxManager.getStatementDelimiters()) {
            char lastChar;
            if (!sql.endsWith(statementDelimiter) && sql.length() > statementDelimiter.length()) continue;
            if (Character.isAlphabetic(statementDelimiter.charAt(0)) && Character.isUnicodeIdentifierPart(lastChar = sql.charAt(sql.length() - statementDelimiter.length() - 1))) break;
            boolean isBlockQuery = false;
            String trimmed = sql.substring(0, sql.length() - statementDelimiter.length());
            String test = trimmed.toUpperCase().trim();
            String[][] blockBoundStrings = syntaxManager.getDialect().getBlockBoundStrings();
            if (blockBoundStrings != null) {
                for (String[] blocks : blockBoundStrings) {
                    int endIndex = test.lastIndexOf(blocks[1]);
                    if (endIndex <= 0) continue;
                    if (test.endsWith(blocks[1])) {
                        isBlockQuery = true;
                        break;
                    }
                    String afterEnd = test.substring(endIndex + blocks[1].length()).trim();
                    if (!afterEnd.chars().noneMatch(Character::isWhitespace)) continue;
                    isBlockQuery = true;
                    break;
                }
            }
            if (isBlockQuery) break;
            sql = trimmed;
            break;
        }
        return sql + trailingSpaces;
    }

    public static boolean isBlockStartKeyword(SQLDialect dialect, String keyword) {
        String[][] blockBoundStrings = dialect.getBlockBoundStrings();
        if (blockBoundStrings != null) {
            for (String[] block : blockBoundStrings) {
                if (block.length <= 0 || !keyword.equalsIgnoreCase(block[0])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBlockEndKeyword(SQLDialect dialect, String keyword) {
        String[][] blockBoundStrings = dialect.getBlockBoundStrings();
        if (blockBoundStrings != null) {
            for (String[] block : blockBoundStrings) {
                if (block.length <= 1 || !keyword.equalsIgnoreCase(block[1])) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static SQLDialect getDialectFromObject(DBPObject object) {
        if (object instanceof DBSObject) {
            DBPDataSource dataSource = ((DBSObject)object).getDataSource();
            return SQLUtils.getDialectFromDataSource(dataSource);
        }
        return BasicSQLDialect.INSTANCE;
    }

    @NotNull
    public static SQLDialect getDialectFromDataSource(@Nullable DBPDataSource dataSource) {
        return dataSource == null ? BasicSQLDialect.INSTANCE : dataSource.getSQLDialect();
    }

    public static void appendConditionString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query, boolean inlineCriteria) throws DBException {
        SQLUtils.appendConditionString(filter, dataSource, conditionTable, query, inlineCriteria, false);
    }

    public static void appendConditionString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query, boolean inlineCriteria, boolean subQuery) throws DBException {
        dataSource.getSQLDialect().getQueryGenerator().appendConditionString(filter, dataSource, conditionTable, query, inlineCriteria, subQuery);
    }

    public static void appendConditionString(@NotNull DBDDataFilter filter, @NotNull List<DBDAttributeConstraint> constraints, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, @NotNull StringBuilder query, boolean inlineCriteria, boolean subQuery) throws DBException {
        dataSource.getSQLDialect().getQueryGenerator().appendConditionString(filter, constraints, dataSource, conditionTable, query, inlineCriteria, subQuery);
    }

    public static void appendOrderString(@NotNull DBDDataFilter filter, @NotNull DBPDataSource dataSource, @Nullable String conditionTable, boolean subQuery, @NotNull StringBuilder query) {
        dataSource.getSQLDialect().getQueryGenerator().appendOrderString(filter, dataSource, conditionTable, subQuery, query);
    }

    @Nullable
    public static String getConstraintCondition(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, @Nullable String conditionTable, boolean inlineCriteria) {
        return dataSource.getSQLDialect().getQueryGenerator().getConstraintCondition(dataSource, constraint, conditionTable, inlineCriteria);
    }

    private static String getStringValue(@NotNull DBPDataSource dataSource, @NotNull DBDAttributeConstraint constraint, boolean inlineCriteria, Object value) {
        String strValue = constraint.getAttribute() == null ? (value instanceof CharSequence ? dataSource.getSQLDialect().getQuotedString(value.toString()) : CommonUtils.toString((Object)value)) : (inlineCriteria ? SQLUtils.convertValueToSQL(dataSource, constraint.getAttribute(), value) : dataSource.getSQLDialect().getTypeCastClause(constraint.getAttribute(), "?", true));
        return strValue;
    }

    public static int getConstraintOrderIndex(@NotNull DBDDataFilter dataFilter, @NotNull DBDAttributeConstraint constraint) {
        int index = dataFilter.getConstraints().indexOf(constraint);
        return index == -1 ? index : index + 1;
    }

    public static String convertValueToSQL(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject attribute, @Nullable Object value) {
        DBDValueHandler valueHandler = DBUtils.findValueHandler(dataSource, attribute);
        return SQLUtils.convertValueToSQL(dataSource, attribute, valueHandler, value, DBDDisplayFormat.NATIVE, false);
    }

    public static String convertValueToSQL(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject attribute, @NotNull DBDValueHandler valueHandler, @Nullable Object value, DBDDisplayFormat displayFormat, boolean isInCondition) {
        if (DBUtils.isNullValue(value)) {
            return "NULL";
        }
        return dataSource.getSQLDialect().getTypeCastClause(attribute, SQLUtils.convertValueToSQLFormat(dataSource, attribute, valueHandler, value, displayFormat), isInCondition);
    }

    private static String convertValueToSQLFormat(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject attribute, @NotNull DBDValueHandler valueHandler, @Nullable Object value, DBDDisplayFormat displayFormat) {
        if (DBUtils.isNullValue(value)) {
            return "NULL";
        }
        String strValue = value instanceof DBDContent ? SQLUtils.convertStreamToSQL(attribute, (DBDContent)value, valueHandler, dataSource) : valueHandler.getValueDisplayString(attribute, value, displayFormat);
        SQLDialect sqlDialect = dataSource.getSQLDialect();
        DBPDataKind dataKind = attribute.getDataKind();
        switch (dataKind) {
            case CONTENT: {
                DBDContent contentValue;
                String contentType;
                if (value instanceof DBDContent && (contentType = (contentValue = (DBDContent)value).getContentType()) != null && !contentType.startsWith("text")) {
                    return strValue;
                }
            }
            case STRING: 
            case ROWID: {
                if (!sqlDialect.isQuotedString(strValue)) {
                    return sqlDialect.getQuotedString(strValue);
                }
                return strValue;
            }
        }
        if (sqlDialect != null) {
            return sqlDialect.escapeScriptValue(attribute, value, strValue);
        }
        return strValue;
    }

    public static String convertStreamToSQL(DBSTypedObject attribute, DBDContent content, DBDValueHandler valueHandler, DBPDataSource dataSource) {
        try {
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            if (!content.isNull() && ContentUtils.isTextContent(content)) {
                return ContentUtils.getContentStringValue(monitor, content);
            }
            byte[] binValue = ContentUtils.getContentBinaryValue(monitor, content);
            if (binValue == null) {
                return "NULL";
            }
            return dataSource.getSQLDialect().getNativeBinaryFormatter().toString(binValue, 0, binValue.length);
        }
        catch (Throwable e) {
            log.warn(e);
            return "NULL";
        }
    }

    public static String getColumnTypeModifiers(@Nullable DBPDataSource dataSource, DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        if (column == null) {
            return null;
        }
        if (dataSource == null) {
            return null;
        }
        return dataSource.getSQLDialect().getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }

    public static String getScriptDescription(@NotNull String sql) {
        Matcher matcher = CREATE_PREFIX_PATTERN.matcher((CharSequence)(sql = SQLUtils.stripComments(BasicSQLDialect.INSTANCE, (String)sql)));
        if (matcher.find() && matcher.start(0) == 0) {
            sql = ((String)sql).substring(matcher.end(1));
        }
        if (((String)(sql = ((String)sql).replaceAll(" +", " "))).length() > 500) {
            sql = ((String)sql).substring(0, 500) + " ...";
        }
        return sql;
    }

    public static String generateEntityAlias(DBSEntity entity, DBRFinder<Boolean, String> aliasFinder) {
        String name = entity.getName();
        if (CommonUtils.isEmpty((String)name)) {
            return name;
        }
        SQLDialect dialect = entity.getParentObject().getDataSource().getSQLDialect();
        StringBuilder buf = new StringBuilder();
        boolean prevNonLetter = true;
        char prevChar = '\u0000';
        for (int i = 0; i < name.length(); ++i) {
            boolean isValidChar;
            char c = name.charAt(i);
            boolean bl = isValidChar = buf.isEmpty() && dialect.validIdentifierStart(c) || !buf.isEmpty() && dialect.validIdentifierPart(c, false);
            if (!Character.isLetter(c)) {
                prevNonLetter = true;
            } else {
                if (isValidChar && (prevNonLetter || prevChar != '\u0000' && Character.isLowerCase(prevChar) && Character.isUpperCase(c))) {
                    buf.append(c);
                }
                prevNonLetter = false;
            }
            prevChar = c;
        }
        String alias = "t";
        if (!CommonUtils.isEmpty((CharSequence)buf)) {
            String generatedAlias = buf.toString();
            if (dialect.getReservedWords().stream().noneMatch(kw -> kw.equalsIgnoreCase(generatedAlias))) {
                alias = generatedAlias.toLowerCase(Locale.ENGLISH);
            }
        }
        Object result = alias;
        for (int i = 2; i < 500; ++i) {
            if (!aliasFinder.findObject((String)result).booleanValue()) {
                return result;
            }
            result = alias + i;
        }
        return alias;
    }

    @NotNull
    public static String generateCommentLine(@Nullable DBPDataSource dataSource, @NotNull String comment) {
        Object[] slComments;
        String separator = GeneralUtils.getDefaultLineSeparator();
        Object slComment = "--";
        if (dataSource != null && !ArrayUtils.isEmpty((Object[])(slComments = dataSource.getSQLDialect().getSingleLineComments()))) {
            slComment = slComments[0];
        }
        StringBuilder sb = new StringBuilder();
        for (String line : comment.split("\n|\r|\r\n")) {
            sb.append((String)slComment).append(" ").append(line).append(separator);
        }
        return sb.toString();
    }

    public static String generateParamList(int paramCount) {
        if (paramCount == 0) {
            return "";
        }
        if (paramCount == 1) {
            return "?";
        }
        StringBuilder sql = new StringBuilder("?");
        for (int i = 0; i < paramCount - 1; ++i) {
            sql.append(",?");
        }
        return sql.toString();
    }

    public static String fixLineFeeds(String sql) {
        if (sql.indexOf(13) == -1) {
            return sql;
        }
        boolean hasFixes = false;
        char[] initial = sql.toCharArray();
        StringBuilder fixed = new StringBuilder(initial.length);
        for (int i = 0; i < initial.length; ++i) {
            fixed.append(initial[i]);
            if (initial[i] != '\r' || i > 0 && initial[i - 1] == '\n' || i == initial.length - 1 || initial[i + 1] == '\n') continue;
            fixed.append('\n');
            hasFixes = true;
        }
        return hasFixes ? fixed.toString() : sql;
    }

    public static boolean compareAliases(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return SQLUtils.removeExtraSpaces(str1).equals(SQLUtils.removeExtraSpaces(str2));
    }

    public static String removeExtraSpaces(@NotNull String str) {
        if (str.indexOf(32) == -1) {
            return str;
        }
        StringBuilder result = new StringBuilder(str.length());
        int length = str.length();
        block0: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                boolean needsSpace = i > 0 && Character.isLetterOrDigit(str.charAt(i - 1));
                ++i;
                while (i < length) {
                    c = str.charAt(i);
                    if (!Character.isWhitespace(c)) {
                        if (needsSpace && Character.isLetterOrDigit(c)) {
                            result.append(' ');
                        }
                        result.append(c);
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @NotNull
    public static String generateScript(DBPDataSource dataSource, DBEPersistAction[] persistActions, boolean addComments) {
        SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource(dataSource);
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        StringBuilder script = new StringBuilder(64);
        if (addComments) {
            script.append(DBEAVER_DDL_COMMENT).append(Platform.getProduct().getName()).append(lineSeparator).append(DBEAVER_DDL_WARNING).append(lineSeparator);
        }
        if (persistActions != null) {
            for (DBEPersistAction action : persistActions) {
                String scriptLine = action.getScript();
                if (CommonUtils.isEmpty((String)scriptLine)) continue;
                String redefiner = sqlDialect.getScriptDelimiterRedefiner();
                String delimiter = SQLUtils.getScriptLineDelimiter(sqlDialect);
                if (action.isComplex() && redefiner != null && !redefiner.equals(delimiter)) {
                    script.append(lineSeparator).append(redefiner).append(" ").append(DBEAVER_SCRIPT_DELIMITER).append(lineSeparator);
                    delimiter = DBEAVER_SCRIPT_DELIMITER;
                    script.append(delimiter).append(lineSeparator);
                } else if (action.getType() == DBEPersistAction.ActionType.COMMENT && script.length() > 2) {
                    int lfCount = 0;
                    for (int i = script.length() - 1; i >= 0 && Character.isWhitespace(script.charAt(i)); --i) {
                        if (script.charAt(i) != '\n') continue;
                        ++lfCount;
                    }
                    if (lfCount < 2) {
                        script.append(lineSeparator);
                    }
                }
                script.append(scriptLine);
                if (action.getType() != DBEPersistAction.ActionType.COMMENT) {
                    String testLine = scriptLine.trim();
                    if (testLine.lastIndexOf(delimiter) != testLine.length() - delimiter.length()) {
                        script.append(delimiter);
                    }
                } else {
                    script.append(lineSeparator);
                }
                script.append(lineSeparator);
                if (!action.isComplex() || redefiner == null || redefiner.equals(delimiter)) continue;
                script.append(redefiner).append(" ").append(SQLUtils.getScriptLineDelimiter(sqlDialect)).append(lineSeparator);
            }
        }
        return script.toString();
    }

    @NotNull
    public static String generateComments(DBPDataSource dataSource, DBEPersistAction[] persistActions, boolean addComments) {
        SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource(dataSource);
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        StringBuilder script = new StringBuilder(64);
        if (addComments) {
            script.append(DBEAVER_DDL_COMMENT).append(Platform.getProduct().getName()).append(lineSeparator).append(DBEAVER_DDL_WARNING).append(lineSeparator);
        }
        if (persistActions != null) {
            Object[] slComments = sqlDialect.getSingleLineComments();
            Object slComment = ArrayUtils.isEmpty((Object[])slComments) ? "--" : slComments[0];
            for (DBEPersistAction action : persistActions) {
                if (action.getType() != DBEPersistAction.ActionType.COMMENT) {
                    scriptLine = action.getTitle();
                    if (CommonUtils.isEmpty((String)scriptLine)) continue;
                    script.append((String)slComment).append(" ").append(scriptLine);
                } else {
                    scriptLine = action.getScript();
                    if (CommonUtils.isEmpty((String)scriptLine)) continue;
                    script.append(scriptLine);
                }
                script.append(lineSeparator);
            }
        }
        return script.toString();
    }

    public static String getScriptLineDelimiter(SQLDialect sqlDialect) {
        Object delimiter = SQLUtils.getDefaultScriptDelimiter(sqlDialect);
        if (!((String)delimiter).isEmpty() && Character.isLetterOrDigit(((String)delimiter).charAt(0))) {
            delimiter = " " + (String)delimiter;
        }
        return delimiter;
    }

    public static String[] splitFullIdentifier(String fullName, char nameSeparator, String[][] quoteStrings) {
        return SQLUtils.splitFullIdentifier(fullName, String.valueOf(nameSeparator), quoteStrings, false);
    }

    public static String[] splitFullIdentifier(String fullName, String nameSeparator, String[][] quoteStrings, boolean keepQuotes) {
        String name = fullName.trim();
        if (ArrayUtils.isEmpty((Object[])quoteStrings)) {
            return name.split(Pattern.quote(nameSeparator));
        }
        if (!name.contains(nameSeparator)) {
            name = keepQuotes ? name : DBUtils.getUnQuotedIdentifier(name, quoteStrings);
            return new String[]{name};
        }
        ArrayList<String> nameList = new ArrayList<String>();
        while (!name.isEmpty()) {
            boolean hadQuotedPart = false;
            for (String[] quotePair : quoteStrings) {
                String partName;
                int endPos;
                String startQuote = quotePair[0];
                String endQuote = quotePair[1];
                if (CommonUtils.isEmpty((String)startQuote) || CommonUtils.isEmpty((String)endQuote) || !name.startsWith(startQuote) || (endPos = name.indexOf(endQuote, startQuote.length())) == -1) continue;
                String string = partName = keepQuotes ? name.substring(0, endPos + endQuote.length()) : name.substring(startQuote.length(), endPos);
                while (partName.endsWith(nameSeparator)) {
                    partName = partName.substring(0, partName.length() - 1);
                }
                if (!partName.isEmpty()) {
                    nameList.add(partName);
                }
                name = name.substring(endPos + endQuote.length()).trim();
                hadQuotedPart = true;
                break;
            }
            if (!hadQuotedPart) {
                int endPos = name.indexOf(nameSeparator);
                if (endPos != -1) {
                    nameList.add(name.substring(0, endPos));
                    name = name.substring(endPos);
                } else {
                    nameList.add(name);
                    break;
                }
            }
            if (name.isEmpty() || !name.startsWith(nameSeparator)) continue;
            name = name.substring(nameSeparator.length()).trim();
        }
        return nameList.toArray(new String[0]);
    }

    public static String generateTableJoin(DBRProgressMonitor monitor, DBSEntity leftTable, String leftAlias, DBSEntity rightTable, String rightAlias) throws DBException {
        String sql = SQLUtils.generateTableJoinByAssociation(monitor, leftTable, leftAlias, rightTable, rightAlias);
        if (sql != null) {
            return sql;
        }
        sql = SQLUtils.generateTableJoinByAssociation(monitor, rightTable, rightAlias, leftTable, leftAlias);
        if (sql != null) {
            return sql;
        }
        sql = SQLUtils.generateTableJoinByColumns(monitor, leftTable, leftAlias, rightTable, rightAlias);
        if (sql != null) {
            return sql;
        }
        sql = SQLUtils.generateTableJoinByColumns(monitor, rightTable, rightAlias, leftTable, leftAlias);
        return sql;
    }

    private static String generateTableJoinByColumns(DBRProgressMonitor monitor, DBSEntity leftTable, String leftAlias, DBSEntity rightTable, String rightAlias) throws DBException {
        ArrayList<? extends DBSEntityAttribute> leftIdentifier = new ArrayList<DBSEntityAttribute>(DBUtils.getBestTableIdentifier(monitor, leftTable));
        if (!leftIdentifier.isEmpty()) {
            DBSEntityAttribute attr;
            DBSEntityAttribute rightAttr;
            ArrayList<DBSEntityAttribute> rightAttributes = new ArrayList<DBSEntityAttribute>();
            Iterator iterator = leftIdentifier.iterator();
            while (iterator.hasNext() && (rightAttr = rightTable.getAttribute(monitor, (attr = (DBSEntityAttribute)iterator.next()).getName())) != null) {
                rightAttributes.add(rightAttr);
            }
            if (leftIdentifier.size() != rightAttributes.size()) {
                return null;
            }
            StringBuilder joinSQL = new StringBuilder();
            for (int i = 0; i < leftIdentifier.size(); ++i) {
                joinSQL.append(leftAlias).append(".").append(DBUtils.getQuotedIdentifier((DBSObject)leftIdentifier.get(i))).append(" = ").append(rightAlias).append(".").append(DBUtils.getQuotedIdentifier((DBSObject)rightAttributes.get(i)));
            }
            return joinSQL.toString();
        }
        return null;
    }

    private static String generateTableJoinByAssociation(DBRProgressMonitor monitor, DBSEntity leftTable, String leftAlias, DBSEntity rightTable, String rightAlias) throws DBException {
        Collection<? extends DBSEntityAssociation> associations = leftTable.getAssociations(monitor);
        if (!CommonUtils.isEmpty(associations)) {
            for (DBSEntityAssociation dBSEntityAssociation : associations) {
                if (!(dBSEntityAssociation instanceof DBSTableForeignKey) || dBSEntityAssociation.getAssociatedEntity() != rightTable) continue;
                return SQLUtils.generateTablesJoin(monitor, (DBSTableForeignKey)dBSEntityAssociation, leftAlias, rightAlias);
            }
        }
        return null;
    }

    private static String generateTablesJoin(DBRProgressMonitor monitor, DBSTableForeignKey fk, String leftAlias, String rightAlias) throws DBException {
        boolean hasCriteria = false;
        StringBuilder joinSQL = new StringBuilder();
        for (DBSEntityAttributeRef dBSEntityAttributeRef : fk.getAttributeReferences(monitor)) {
            if (!(dBSEntityAttributeRef instanceof DBSTableForeignKeyColumn)) continue;
            DBSTableForeignKeyColumn fkc = (DBSTableForeignKeyColumn)dBSEntityAttributeRef;
            if (hasCriteria) {
                joinSQL.append(" AND ");
            }
            joinSQL.append(leftAlias).append(".").append(DBUtils.getQuotedIdentifier(fkc)).append(" = ").append(rightAlias).append(".").append(DBUtils.getQuotedIdentifier(fkc.getReferencedColumn()));
            hasCriteria = true;
        }
        return joinSQL.toString();
    }

    public static String getTableAlias(DBSEntity table) {
        return CommonUtils.escapeIdentifier((String)table.getName());
    }

    public static void appendQueryConditions(@NotNull DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) throws DBException {
        dataSource.getSQLDialect().getQueryGenerator().appendQueryConditions(dataSource, query, tableAlias, dataFilter);
    }

    public static void appendQueryOrder(DBPDataSource dataSource, @NotNull StringBuilder query, @Nullable String tableAlias, @Nullable DBDDataFilter dataFilter) {
        dataSource.getSQLDialect().getQueryGenerator().appendQueryOrder(dataSource, query, tableAlias, dataFilter);
    }

    public static boolean isExecQuery(@NotNull SQLDialect dialect, String query) {
        String[] executeKeywords = dialect.getExecuteKeywords();
        if (executeKeywords != null && executeKeywords.length > 0) {
            String queryStart = SQLUtils.getFirstKeyword(dialect, query);
            return SQLUtils.isExecKeyword(dialect, queryStart);
        }
        return false;
    }

    public static boolean isExecKeyword(SQLDialect dialect, String word) {
        return ArrayUtils.containsIgnoreCase((String[])dialect.getExecuteKeywords(), (String)word);
    }

    public static String stripColumnTypeModifiers(String type) {
        int endPos;
        int startPos = type.indexOf("(");
        if (startPos != -1 && (endPos = type.lastIndexOf(")")) != -1) {
            return type.substring(0, startPos);
        }
        return type;
    }

    public static void fillQueryParameters(SQLQuery sqlStatement, List<SQLQueryParameter> parameters) {
        Object query = sqlStatement.getText();
        for (int i = parameters.size(); i > 0; --i) {
            SQLQueryParameter parameter = parameters.get(i - 1);
            String paramValue = parameter.getValue();
            if (paramValue == null || paramValue.isEmpty()) {
                paramValue = "NULL";
            }
            query = ((String)query).substring(0, parameter.getTokenOffset()) + paramValue + ((String)query).substring(parameter.getTokenOffset() + parameter.getTokenLength());
        }
        sqlStatement.setText((String)query);
    }

    public static boolean needQueryDelimiter(SQLDialect sqlDialect, String query) {
        String[] scriptDelimiters;
        for (String delimiter : scriptDelimiters = sqlDialect.getScriptDelimiters()) {
            if (delimiter.isEmpty()) continue;
            if (Character.isLetterOrDigit(delimiter.charAt(0))) {
                if (!query.toUpperCase().endsWith(delimiter.toUpperCase()) || Character.isLetterOrDigit(query.charAt(query.length() - delimiter.length() - 1))) continue;
                return true;
            }
            return !query.endsWith(delimiter);
        }
        return false;
    }

    public static String removeQueryDelimiter(SQLDialect sqlDialect, String query) {
        String[] scriptDelimiters;
        for (String delimiter : scriptDelimiters = sqlDialect.getScriptDelimiters()) {
            if (delimiter.isEmpty() || !query.contains(delimiter)) continue;
            String queryWithoutDelimiter = query.substring(0, query.lastIndexOf(delimiter));
            if (!(Character.isLetterOrDigit(delimiter.charAt(0)) ? query.toUpperCase().endsWith(delimiter.toUpperCase()) && !Character.isLetterOrDigit(query.charAt(query.length() - delimiter.length() - 1)) : query.endsWith(delimiter))) continue;
            return queryWithoutDelimiter;
        }
        return query;
    }

    public static String getDefaultScriptDelimiter(SQLDialect sqlDialect) {
        Object[] scriptDelimiters = sqlDialect.getScriptDelimiters();
        if (!ArrayUtils.isEmpty((Object[])scriptDelimiters)) {
            return scriptDelimiters[0];
        }
        return ";";
    }

    public static boolean isLatinLetter(int codePoint) {
        return Character.isLetter(codePoint) && Character.UnicodeBlock.of(codePoint) == Character.UnicodeBlock.BASIC_LATIN;
    }

    public static String identifierToCanonicalForm(@NotNull SQLDialect dialect, @NotNull String rawIdentifierString, boolean forceUnquotted, boolean prepared) {
        String unquottedIdentifier;
        if (prepared) {
            unquottedIdentifier = rawIdentifierString;
        } else {
            boolean isQuoted = dialect.isQuotedIdentifier(rawIdentifierString);
            DBPIdentifierCase identifierCase = isQuoted ? dialect.storesQuotedCase() : dialect.storesUnquotedCase();
            unquottedIdentifier = identifierCase.transform(dialect.getUnquotedIdentifier(rawIdentifierString, true));
        }
        String actualIdentifierString = forceUnquotted ? unquottedIdentifier : dialect.getQuotedIdentifier(unquottedIdentifier, true, false);
        return actualIdentifierString;
    }

    public static String extractProcedureParameterTypes(@Nullable String sig) {
        if (CommonUtils.isEmpty((String)sig)) {
            return "()";
        }
        String s = sig.trim();
        if (s.startsWith("(") && s.endsWith(")")) {
            s = s.substring(1, s.length() - 1).trim();
        }
        if (s.isEmpty()) {
            return "()";
        }
        List<String> parts = SQLUtils.extractParts(s);
        ArrayList<String> types = new ArrayList<String>(parts.size());
        for (String p : parts) {
            int spaceIndex = p.lastIndexOf(32);
            String type = spaceIndex >= 0 ? p.substring(spaceIndex + 1) : p;
            types.add(type.toUpperCase());
        }
        return "(" + String.join((CharSequence)", ", types) + ")";
    }

    @NotNull
    private static List<String> extractParts(String s) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder cur = new StringBuilder();
        int depth = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '(') {
                ++depth;
            }
            if (c == ')') {
                depth = Math.max(0, depth - 1);
            }
            if (c == ',' && depth == 0) {
                parts.add(cur.toString().trim());
                cur.setLength(0);
                continue;
            }
            cur.append(c);
        }
        if (!cur.isEmpty()) {
            parts.add(cur.toString().trim());
        }
        return parts;
    }

    public static void addMultiStatementDDL(@NotNull SQLDialect sqlDialect, @NotNull StringBuilder sql, @Nullable String ddl) {
        if (CommonUtils.isEmpty((String)ddl)) {
            return;
        }
        String[] lines = ddl.trim().split("\\r?\\n");
        boolean hasStatements = false;
        for (String line : lines) {
            String trimmed = line.trim();
            if (CommonUtils.isEmpty((String)trimmed)) continue;
            hasStatements = true;
            boolean hasDelimiter = false;
            for (String scriptDelimiter : sqlDialect.getScriptDelimiters()) {
                if (!trimmed.endsWith(scriptDelimiter)) continue;
                hasDelimiter = true;
                break;
            }
            sql.append(trimmed);
            if (!hasDelimiter) {
                sql.append(SQLUtils.getDefaultScriptDelimiter(sqlDialect));
            }
            sql.append("\n");
        }
        if (hasStatements) {
            sql.append("\n");
        }
    }
}

