/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.rm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.rm.RMController;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManager;
import org.jkiss.dbeaver.registry.rm.DataSourceRMStorage;

public class DataSourceConfigurationManagerRM
implements DataSourceConfigurationManager {
    private static final Log log = Log.getLog(DataSourceConfigurationManagerRM.class);
    @NotNull
    private final DBPProject project;
    private final RMController rmController;

    public DataSourceConfigurationManagerRM(@NotNull DBPProject project, @NotNull RMController client) {
        this.project = project;
        this.rmController = client;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public List<DBPDataSourceConfigurationStorage> getConfigurationStorages() {
        return Collections.singletonList(new DataSourceRMStorage(this.project));
    }

    @Override
    public InputStream readConfiguration(@NotNull String name, @Nullable Collection<String> dataSourceIds) throws DBException, IOException {
        if (name.startsWith("credentials-config")) {
            return null;
        }
        if (!name.equals(this.project.getName())) {
            throw new DBException("Wrong storage name: " + name);
        }
        String projectId = this.project.getId();
        try {
            String dsContent = this.rmController.getProjectsDataSources(projectId, dataSourceIds == null ? null : dataSourceIds.toArray(new String[0]));
            if (dsContent == null) {
                return null;
            }
            return new ByteArrayInputStream(dsContent.getBytes(StandardCharsets.UTF_8));
        }
        catch (DBException e) {
            throw new DBException("Could not load project datasources:\n" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void writeConfiguration(@NotNull String name, @Nullable byte[] data) throws DBException {
        throw new DBException("This method should not be called");
    }
}

