﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/cur/CostandUsageReportServiceRequest.h>
#include <aws/cur/CostandUsageReportService_EXPORTS.h>

#include <utility>

namespace Aws {
namespace CostandUsageReportService {
namespace Model {

/**
 */
class UntagResourceRequest : public CostandUsageReportServiceRequest {
 public:
  AWS_COSTANDUSAGEREPORTSERVICE_API UntagResourceRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UntagResource"; }

  AWS_COSTANDUSAGEREPORTSERVICE_API Aws::String SerializePayload() const override;

  AWS_COSTANDUSAGEREPORTSERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The report name of the report definition that tags are to be disassociated
   * from.</p>
   */
  inline const Aws::String& GetReportName() const { return m_reportName; }
  inline bool ReportNameHasBeenSet() const { return m_reportNameHasBeenSet; }
  template <typename ReportNameT = Aws::String>
  void SetReportName(ReportNameT&& value) {
    m_reportNameHasBeenSet = true;
    m_reportName = std::forward<ReportNameT>(value);
  }
  template <typename ReportNameT = Aws::String>
  UntagResourceRequest& WithReportName(ReportNameT&& value) {
    SetReportName(std::forward<ReportNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags to be disassociated from the report definition resource.</p>
   */
  inline const Aws::Vector<Aws::String>& GetTagKeys() const { return m_tagKeys; }
  inline bool TagKeysHasBeenSet() const { return m_tagKeysHasBeenSet; }
  template <typename TagKeysT = Aws::Vector<Aws::String>>
  void SetTagKeys(TagKeysT&& value) {
    m_tagKeysHasBeenSet = true;
    m_tagKeys = std::forward<TagKeysT>(value);
  }
  template <typename TagKeysT = Aws::Vector<Aws::String>>
  UntagResourceRequest& WithTagKeys(TagKeysT&& value) {
    SetTagKeys(std::forward<TagKeysT>(value));
    return *this;
  }
  template <typename TagKeysT = Aws::String>
  UntagResourceRequest& AddTagKeys(TagKeysT&& value) {
    m_tagKeysHasBeenSet = true;
    m_tagKeys.emplace_back(std::forward<TagKeysT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_reportName;
  bool m_reportNameHasBeenSet = false;

  Aws::Vector<Aws::String> m_tagKeys;
  bool m_tagKeysHasBeenSet = false;
};

}  // namespace Model
}  // namespace CostandUsageReportService
}  // namespace Aws
