/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.contextmanager;

import lombok.Generated;
import org.opensearch.ml.common.contextmanager.ActivationRule;
import org.opensearch.ml.common.contextmanager.ContextManagerContext;

public class MessageCountExceedRule
implements ActivationRule {
    private final int messageThreshold;

    @Override
    public boolean evaluate(ContextManagerContext context) {
        if (context == null) {
            return false;
        }
        int currentMessageCount = context.getMessageCount();
        return currentMessageCount > this.messageThreshold;
    }

    @Override
    public String getDescription() {
        return "message_count_exceed: " + this.messageThreshold;
    }

    @Generated
    public MessageCountExceedRule(int messageThreshold) {
        this.messageThreshold = messageThreshold;
    }

    @Generated
    public int getMessageThreshold() {
        return this.messageThreshold;
    }
}

