/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.analysis.CharFilter;
import org.opensearch.client.opensearch._types.analysis.TokenFilter;
import org.opensearch.client.opensearch._types.analysis.Tokenizer;
import org.opensearch.client.opensearch.indices.AnalyzeResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class AnalyzeRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, AnalyzeRequest> {
    @Nullable
    private final String analyzer;
    @Nonnull
    private final List<String> attributes;
    @Nonnull
    private final List<CharFilter> charFilter;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final String field;
    @Nonnull
    private final List<TokenFilter> filter;
    @Nullable
    private final String index;
    @Nullable
    private final String normalizer;
    @Nonnull
    private final List<String> text;
    @Nullable
    private final Tokenizer tokenizer;
    public static final JsonpDeserializer<AnalyzeRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyzeRequest::setupAnalyzeRequestDeserializer);
    public static final Endpoint<AnalyzeRequest, AnalyzeResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<AnalyzeRequest, AnalyzeResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_analyze";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_analyze");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, AnalyzeResponse._DESERIALIZER);

    private AnalyzeRequest(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.attributes = ApiTypeHelper.unmodifiable(builder.attributes);
        this.charFilter = ApiTypeHelper.unmodifiable(builder.charFilter);
        this.explain = builder.explain;
        this.field = builder.field;
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
        this.index = builder.index;
        this.normalizer = builder.normalizer;
        this.text = ApiTypeHelper.unmodifiable(builder.text);
        this.tokenizer = builder.tokenizer;
    }

    public static AnalyzeRequest of(Function<Builder, ObjectBuilder<AnalyzeRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nonnull
    public final List<String> attributes() {
        return this.attributes;
    }

    @Nonnull
    public final List<CharFilter> charFilter() {
        return this.charFilter;
    }

    @Nullable
    public final Boolean explain() {
        return this.explain;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nonnull
    public final List<TokenFilter> filter() {
        return this.filter;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String normalizer() {
        return this.normalizer;
    }

    @Nonnull
    public final List<String> text() {
        return this.text;
    }

    @Nullable
    public final Tokenizer tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartArray();
            for (String string : this.attributes) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.charFilter)) {
            generator.writeKey("char_filter");
            generator.writeStartArray();
            for (CharFilter charFilter : this.charFilter) {
                charFilter.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain.booleanValue());
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (TokenFilter tokenFilter : this.filter) {
                tokenFilter.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.normalizer != null) {
            generator.writeKey("normalizer");
            generator.write(this.normalizer);
        }
        if (ApiTypeHelper.isDefined(this.text)) {
            generator.writeKey("text");
            generator.writeStartArray();
            for (String string : this.text) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.tokenizer != null) {
            generator.writeKey("tokenizer");
            this.tokenizer.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAnalyzeRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::attributes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::charFilter, JsonpDeserializer.arrayDeserializer(CharFilter._DESERIALIZER), "char_filter");
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(TokenFilter._DESERIALIZER), "filter");
        op.add(Builder::normalizer, JsonpDeserializer.stringDeserializer(), "normalizer");
        op.add(Builder::text, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "text");
        op.add(Builder::tokenizer, Tokenizer._DESERIALIZER, "tokenizer");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.analyzer);
        result = 31 * result + Objects.hashCode(this.attributes);
        result = 31 * result + Objects.hashCode(this.charFilter);
        result = 31 * result + Objects.hashCode(this.explain);
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.filter);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.normalizer);
        result = 31 * result + Objects.hashCode(this.text);
        result = 31 * result + Objects.hashCode(this.tokenizer);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyzeRequest other = (AnalyzeRequest)o;
        return Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.charFilter, other.charFilter) && Objects.equals(this.explain, other.explain) && Objects.equals(this.field, other.field) && Objects.equals(this.filter, other.filter) && Objects.equals(this.index, other.index) && Objects.equals(this.normalizer, other.normalizer) && Objects.equals(this.text, other.text) && Objects.equals(this.tokenizer, other.tokenizer);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, AnalyzeRequest> {
        @Nullable
        private String analyzer;
        @Nullable
        private List<String> attributes;
        @Nullable
        private List<CharFilter> charFilter;
        @Nullable
        private Boolean explain;
        @Nullable
        private String field;
        @Nullable
        private List<TokenFilter> filter;
        @Nullable
        private String index;
        @Nullable
        private String normalizer;
        @Nullable
        private List<String> text;
        @Nullable
        private Tokenizer tokenizer;

        public Builder() {
        }

        private Builder(AnalyzeRequest o) {
            super(o);
            this.analyzer = o.analyzer;
            this.attributes = Builder._listCopy(o.attributes);
            this.charFilter = Builder._listCopy(o.charFilter);
            this.explain = o.explain;
            this.field = o.field;
            this.filter = Builder._listCopy(o.filter);
            this.index = o.index;
            this.normalizer = o.normalizer;
            this.text = Builder._listCopy(o.text);
            this.tokenizer = o.tokenizer;
        }

        private Builder(Builder o) {
            super(o);
            this.analyzer = o.analyzer;
            this.attributes = Builder._listCopy(o.attributes);
            this.charFilter = Builder._listCopy(o.charFilter);
            this.explain = o.explain;
            this.field = o.field;
            this.filter = Builder._listCopy(o.filter);
            this.index = o.index;
            this.normalizer = o.normalizer;
            this.text = Builder._listCopy(o.text);
            this.tokenizer = o.tokenizer;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        @Nonnull
        public final Builder attributes(List<String> list) {
            this.attributes = Builder._listAddAll(this.attributes, list);
            return this;
        }

        @Nonnull
        public final Builder attributes(String value, String ... values) {
            this.attributes = Builder._listAdd(this.attributes, value, values);
            return this;
        }

        @Nonnull
        public final Builder charFilter(List<CharFilter> list) {
            this.charFilter = Builder._listAddAll(this.charFilter, list);
            return this;
        }

        @Nonnull
        public final Builder charFilter(CharFilter value, CharFilter ... values) {
            this.charFilter = Builder._listAdd(this.charFilter, value, values);
            return this;
        }

        @Nonnull
        public final Builder charFilter(Function<CharFilter.Builder, ObjectBuilder<CharFilter>> fn) {
            return this.charFilter(fn.apply(new CharFilter.Builder()).build(), new CharFilter[0]);
        }

        @Nonnull
        public final Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        @Nonnull
        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder filter(List<TokenFilter> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        @Nonnull
        public final Builder filter(TokenFilter value, TokenFilter ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        @Nonnull
        public final Builder filter(Function<TokenFilter.Builder, ObjectBuilder<TokenFilter>> fn) {
            return this.filter(fn.apply(new TokenFilter.Builder()).build(), new TokenFilter[0]);
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder normalizer(@Nullable String value) {
            this.normalizer = value;
            return this;
        }

        @Nonnull
        public final Builder text(List<String> list) {
            this.text = Builder._listAddAll(this.text, list);
            return this;
        }

        @Nonnull
        public final Builder text(String value, String ... values) {
            this.text = Builder._listAdd(this.text, value, values);
            return this;
        }

        @Nonnull
        public final Builder tokenizer(@Nullable Tokenizer value) {
            this.tokenizer = value;
            return this;
        }

        @Nonnull
        public final Builder tokenizer(Function<Tokenizer.Builder, ObjectBuilder<Tokenizer>> fn) {
            return this.tokenizer(fn.apply(new Tokenizer.Builder()).build());
        }

        @Override
        @Nonnull
        public AnalyzeRequest build() {
            this._checkSingleUse();
            return new AnalyzeRequest(this);
        }
    }
}

